/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package com.sun.xml.wss.impl.callback;

import com.sun.xml.wss.saml.Assertion;
import com.sun.xml.wss.saml.AuthorityBinding;
import javax.security.auth.callback.Callback;
import javax.xml.bind.JAXBElement;
import org.w3c.dom.Element;
import javax.xml.stream.XMLStreamReader;


public class SAMLCallback extends XWSSCallback implements Callback {
    
    Element assertion;
    Element authorityBinding;
    //Assertion jaxbAssertion;
    AuthorityBinding authorityInfo;
    XMLStreamReader assertionStream;
    
    String confirmation = null;
    String version =null;
    String assertionId = null;
    
    public static final String SV_ASSERTION_TYPE="SV-Assertion";
    public static final String HOK_ASSERTION_TYPE="HOK-Assertion";
    
    public static final String V10_ASSERTION="SAML10Assertion";
    public static final String V11_ASSERTION="SAML11Assertion";
    public static final String V20_ASSERTION="SAML20Assertion";
    
    /** Creates a new instance of SAMLCallback */
    public SAMLCallback() {
    }
    
    public void setAssertionElement(Element samlAssertion) {
        assertion = samlAssertion;
    }
    
    public void setAssertionReader(XMLStreamReader samlAssertion) {
        this.assertionStream = samlAssertion;
    }
    
    public Element getAssertionElement() {
        return assertion;
    }
   
    public XMLStreamReader getAssertionReader() {
        return this.assertionStream;
    }
    
    public void setAuthorityBindingElement(Element authority) {
        authorityBinding = authority;
    }
    
    public Element getAuthorityBindingElement() {
        return authorityBinding;
    }
    
    public AuthorityBinding getAuthorityBinding() {
        return authorityInfo;
    }
    
    public void setAuthorityBinding(AuthorityBinding auth) {
        authorityInfo = auth;
    }
    
    public void setConfirmationMethod(String meth) {
        confirmation = meth;
    }
    
    public String getConfirmationMethod() {
        return confirmation;
    }
    
    public String getSAMLVersion() {
        return version;
    }
    
    public void setSAMLVersion(String ver) {
       version = ver;    
    }
    
    public void setAssertionId(String id) {
        assertionId = id;
    }
    
    public String getAssertionId() {
        return assertionId;
    }
}
