/*
 * $Id: XWSSecurityException.java,v 1.3 2006/09/29 12:04:43 kumarjayanti Exp $
 */

/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */
package com.sun.xml.wss;

/**
 * Top level exception used to describe various Errors while processing
 * Secure SOAP messages.
 */
public class XWSSecurityException extends Exception {
    
    /**
     * Constructor specifying the message string.
     * @param message the exception message string
     */
    public XWSSecurityException(String message) {
        super(message);
    }

                                                                                                        
    /**
     * Constructor specifying the message string and a  nested exception
     * @param message the exception message string
     * @param cause the nested exception as a Throwable
     */
    public XWSSecurityException(String message, Throwable cause) {
        super(message, cause);
    }
    
    /**
     * Constructor specifying a nested exception
     * @param cause the nested exception as a Throwable
     */
    public XWSSecurityException(Throwable cause) {
        super(cause);
    }
}
