/*
 * TeeOutputStream.java
 *
 * Created on September 15, 2006, 3:09 PM
 *
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package com.sun.xml.ws.security.opt.impl.util;

import java.io.IOException;
import java.io.OutputStream;

/**
 *
 * @author Ashutosh.Shahi@sun.com
 */
public class TeeOutputStream extends OutputStream{
    
    OutputStream tee = null;
    OutputStream out = null;
    
    /** Creates a new instance of TeeOutputStream */
    public TeeOutputStream(OutputStream chainedStream, OutputStream teeStream) {
        out = chainedStream;
        tee = teeStream;
    }

    public void write(int b) throws IOException {
        out.write(b);
        tee.write(b);
    }
    
    public void close() throws IOException{
        flush();
        out.close();
        tee.close();
    }
    
    public void flush() throws IOException {
        out.flush();
        tee.flush();
    }
}
