/*
 * BufferedStreamWriter.java
 *
 * Created on August 7, 2006, 11:39 AM
 *
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package com.sun.xml.ws.security.opt.impl.util;

import java.io.IOException;
import javax.crypto.CipherOutputStream;

/**
 *
 * @author K.Venugopal@sun.com
 */
public class BufferedStreamWriter extends java.io.OutputStream {
    int size=4*1024;
    byte []buf=null;
    int pos =0;
    CipherOutputStream cos = null;
    /** Creates a new instance of BufferedStreamWriter */
    public BufferedStreamWriter(CipherOutputStream cos) {
        buf =new byte[this.size];
        this.cos = cos;
    }
    public BufferedStreamWriter(CipherOutputStream cos, int size) {
        buf =new byte[size];
        this.cos = cos;
    }
    public void write(byte[] arg0)throws IOException {
        int newPos=pos+arg0.length;
        if (newPos>=size) {
            flush();
            System.arraycopy(arg0,0,buf,0,arg0.length);
            pos = arg0.length;
        }else{
            System.arraycopy(arg0,0,buf,pos,arg0.length);
            pos=newPos;
        }
    }
    /** @inheritDoc */
    public void write(byte[] arg0, int arg1, int arg2)throws IOException {
        int newPos=pos+arg2;
        if (newPos>=size) {
            flush();
            System.arraycopy(arg0,arg1,buf,0,arg2);
            pos = arg2;
        }else{
            System.arraycopy(arg0,arg1,buf,pos,arg2);
            pos=newPos;
        }
    }
    /** @inheritDoc */
    public void write(int arg0)throws IOException {
        if (pos>=size) {
            flush();
        }
        buf[pos++]=(byte)arg0;
    }
    
    public void flush() throws IOException {
        cos.write(buf,0,pos);
        pos = 0;
    }
}
