/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package com.sun.xml.ws.security.opt.impl.message;

import com.sun.xml.stream.buffer.MutableXMLStreamBuffer;
import com.sun.xml.stream.buffer.stax.StreamWriterBufferCreator;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.message.source.PayloadSourceMessage;
import com.sun.xml.ws.message.stream.StreamMessage;
import com.sun.xml.ws.security.opt.api.SecurityElement;
import com.sun.xml.ws.security.opt.api.SecurityElementWriter;
import com.sun.xml.ws.security.opt.impl.util.NamespaceContextEx;
import com.sun.xml.ws.security.opt.impl.util.XMLStreamFilterWithId;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import com.sun.xml.wss.impl.MessageConstants;
import javax.xml.stream.XMLStreamReader;

/**
 *
 * @author K.Venugopal@sun.com
 */
public class SOAPBody{
    private static final String BODY = "Body";
    private static final String BODY_PREFIX = "S";
    
    private Message  message;
    private SOAPVersion soapVersion ;
    private byte [] byteStream;
    private SecurityElement bodyContent;
    private String wsuId;
    private String contentId;
    private MutableXMLStreamBuffer buffer = null;
    
    public SOAPBody(Message message ) {
        this.message = message;
        this.soapVersion  = SOAPVersion.SOAP_11;
    }
    
    /**
     *
     * Creates a new instance of SOAPBody
     *
     */
    
    public SOAPBody(Message message,SOAPVersion soapVersion ) {
        this.message = message;
        this.soapVersion  = soapVersion;
    }
    
    public SOAPBody(byte[]  payLoad,SOAPVersion soapVersion ) {
        byteStream = payLoad;
        this.soapVersion  = soapVersion;
    }
    
    public SOAPBody(SecurityElement se,SOAPVersion soapVersion ) {
        bodyContent = se;
        this.soapVersion  = soapVersion;
    }
    
    public SOAPVersion getSOAPVersion(){
        return soapVersion;
    }
    
    public String getId(){
        return wsuId;
    }
    
    public void setId(String id){
        wsuId = id;
    }
    
    public String getBodyContentId(){
        if(contentId != null)
            return contentId;
        else if(bodyContent != null)
            return bodyContent.getId();
        return null;
    }
    
    public void setBodyContentId(String id){
        this.contentId = id;
    }
    
    public void writePayload(XMLStreamWriter writer)throws XMLStreamException{
        if(this.message != null){
            if(getBodyContentId() == null)
                this.message.writePayloadTo(writer);
            else{
                boolean isSOAP12 = (this.soapVersion == SOAPVersion.SOAP_12) ? true : false;
                XMLStreamFilterWithId xmlStreamFilterWithId = new XMLStreamFilterWithId(writer, new NamespaceContextEx(isSOAP12),getBodyContentId());
                this.message.writePayloadTo(xmlStreamFilterWithId);
            }
        }else if(bodyContent != null){
            ((SecurityElementWriter)bodyContent).writeTo(writer);
        }else if(buffer != null){
            buffer.writeToXMLStreamWriter(writer);
        }else{
            throw new UnsupportedOperationException();
            //TODO
        }
    }
    
    public void writeTo(XMLStreamWriter writer) throws XMLStreamException{
        writer.writeStartElement(BODY_PREFIX,BODY,this.soapVersion.nsUri);
        if(wsuId != null){
            writer.writeAttribute("wsu",MessageConstants.WSU_NS,"Id",wsuId);
        }
        writePayload(writer);
        writer.writeEndElement();
        //writer.flush();
    }
    
    public String getPayloadNamespaceURI(){
        if(message != null){
            return message.getPayloadNamespaceURI();
        }
        if(bodyContent != null){
            return bodyContent.getNamespaceURI();
        }
        return null;
    }
    
    public String getPayloadLocalPart(){
        if(message != null){
            return message.getPayloadLocalPart();
        }
        if(bodyContent != null){
            return bodyContent.getLocalPart();
        }
        return null;
    }
    
    public XMLStreamReader read() throws XMLStreamException{
        if(message != null){
            return message.readPayload();
        }else if(bodyContent != null){
            return bodyContent.readHeader();
        }
        throw new XMLStreamException("Invalid SOAPBody");
    }
    
    public void cachePayLoad() throws XMLStreamException {
        if(message != null){
            if(message instanceof StreamMessage ||  message instanceof PayloadSourceMessage ||
                    message instanceof com.sun.xml.ws.message.jaxb.JAXBMessage){
                if(buffer == null){
                    buffer = new MutableXMLStreamBuffer();
                    StreamWriterBufferCreator creator = new StreamWriterBufferCreator(buffer);
                    this.writePayload(creator);
                    this.message = null;
                }
            }
        }
    }
}

