/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package com.sun.xml.ws.security.opt.impl.keyinfo;

import com.sun.xml.ws.security.opt.api.keyinfo.BinarySecurityToken;
import com.sun.xml.ws.security.opt.api.keyinfo.BuilderResult;
import com.sun.xml.ws.security.opt.api.reference.DirectReference;
import com.sun.xml.ws.security.opt.impl.crypto.OctectStreamData;
import com.sun.xml.ws.security.opt.impl.reference.KeyIdentifier;
import com.sun.xml.ws.security.opt.impl.reference.X509Data;
import com.sun.xml.ws.security.opt.impl.reference.X509IssuerSerial;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import com.sun.xml.wss.logging.impl.opt.token.LogStringsMessages;

/**
 *
 * @author K.Venugopal@sun.com
 */
public class X509TokenBuilder extends TokenBuilder{
    
    AuthenticationTokenPolicy.X509CertificateBinding binding = null;
    /** Creates a new instance of X509TokenBuilder */
    public X509TokenBuilder(JAXBFilterProcessingContext context,AuthenticationTokenPolicy.X509CertificateBinding binding) {
        super(context);
        this.binding = binding;
    }
    
    
    public BuilderResult process() throws XWSSecurityException{
        
        String x509id = binding.getUUID();
        if(x509id == null || x509id.equals("")){
            x509id = context.generateID();
        }
        SecurityUtil.checkIncludeTokenPolicyOpt(context, binding, x509id);
        
        String referenceType = binding.getReferenceType();
        if(logger.isLoggable(Level.FINEST)){
            logger.log(Level.FINEST, LogStringsMessages.WSS_1851_REFERENCETYPE_X_509_TOKEN(referenceType));
        }
        BuilderResult result = new BuilderResult();
        if(referenceType.equals("Direct")){
            BinarySecurityToken bst = createBinarySecurityToken(binding,binding.getX509Certificate());
            if(bst == null){
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1802_WRONG_TOKENINCLUSION_POLICY());
                throw new XWSSecurityException(LogStringsMessages.WSS_1802_WRONG_TOKENINCLUSION_POLICY());
            }
            DirectReference dr = buildDirectReference(bst.getId(), MessageConstants.X509v3_NS);
            buildKeyInfo(dr,binding.getSTRID());
        }else if(referenceType.equals("Identifier")){
            BinarySecurityToken bst = createBinarySecurityToken(binding,binding.getX509Certificate());
            buildKeyInfoWithKI(binding,MessageConstants.X509SubjectKeyIdentifier_NS);
            try{
                if(binding.getSTRID() != null){
                    OctectStreamData osd = new OctectStreamData(new String(binding.getX509Certificate().getEncoded()));
                    context.getElementCache().put(binding.getSTRID(),osd);                
                }
            }catch(CertificateEncodingException ce){
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1814_ERROR_ENCODING_CERTIFICATE());
                throw new XWSSecurityException(LogStringsMessages.WSS_1814_ERROR_ENCODING_CERTIFICATE(), ce);
            }
        }else if (referenceType.equals(MessageConstants.THUMB_PRINT_TYPE)){
            BinarySecurityToken bst = createBinarySecurityToken(binding,binding.getX509Certificate());
            KeyIdentifier ki = buildKeyInfoWithKI(binding,MessageConstants.ThumbPrintIdentifier_NS);
            try{
                if(binding.getSTRID() != null){
                    OctectStreamData osd = new OctectStreamData(new String(binding.getX509Certificate().getEncoded()));
                    context.getElementCache().put(binding.getSTRID(),osd);
                }
            }catch(CertificateEncodingException ce){
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1814_ERROR_ENCODING_CERTIFICATE());
                throw new XWSSecurityException(LogStringsMessages.WSS_1814_ERROR_ENCODING_CERTIFICATE(), ce);
            }
        }else if(referenceType.equals(MessageConstants.X509_ISSUER_TYPE)){
            X509Certificate xCert = binding.getX509Certificate();
            X509IssuerSerial xis = elementFactory.createX509IssuerSerial(xCert.getIssuerDN().getName(),xCert.getSerialNumber());
            X509Data x509Data = elementFactory.createX509DataWithIssuerSerial(xis);
            buildKeyInfo(x509Data,binding.getSTRID());
            try{
                if(binding.getSTRID() != null){
                    OctectStreamData osd = new OctectStreamData(new String(binding.getX509Certificate().getEncoded()));
                    context.getElementCache().put(binding.getSTRID(),osd);                
                }
            }catch(CertificateEncodingException ce){
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1814_ERROR_ENCODING_CERTIFICATE());
                throw new XWSSecurityException(LogStringsMessages.WSS_1814_ERROR_ENCODING_CERTIFICATE(), ce);
            }
        }else{
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1803_UNSUPPORTED_REFERENCE_TYPE(referenceType));
            throw new XWSSecurityException(LogStringsMessages.WSS_1803_UNSUPPORTED_REFERENCE_TYPE(referenceType));
        }
        result.setKeyInfo(keyInfo);
        return result;
    }
    
}
