/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package com.sun.xml.ws.security.opt.impl.keyinfo;

import com.sun.org.apache.xml.internal.security.encryption.XMLCipher;
import com.sun.xml.ws.security.opt.api.SecurityHeaderElement;
import com.sun.xml.ws.security.opt.api.keyinfo.BuilderResult;
import com.sun.xml.ws.security.opt.impl.enc.JAXBEncryptedKey;
import com.sun.xml.ws.security.opt.impl.incoming.SAMLAssertion;
import com.sun.xml.ws.security.opt.impl.reference.DirectReference;
import com.sun.xml.ws.security.opt.impl.reference.KeyIdentifier;
import com.sun.xml.ws.security.opt.impl.message.GSHeaderElement;
import com.sun.xml.ws.security.secext10.SecurityTokenReferenceType;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.ws.security.opt.impl.util.NamespaceContextEx;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.wss.impl.policy.mls.PrivateKeyBinding;
import com.sun.xml.wss.logging.impl.opt.token.LogStringsMessages;

import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.logging.Level;
import org.w3c.dom.Element;

/**
 *
 * @author K.Venugopal@sun.com
 */
public class SamlTokenBuilder extends TokenBuilder{
    
    private AuthenticationTokenPolicy.SAMLAssertionBinding keyBinding = null;
    private boolean forSign = false;
    /** Creates a new instance of SamlTokenProcessor */
    public SamlTokenBuilder(JAXBFilterProcessingContext context,AuthenticationTokenPolicy.SAMLAssertionBinding samlBinding,boolean forSign) {
        super(context);
        this.forSign = forSign;
        this.keyBinding = samlBinding;
    }
    
    public BuilderResult process() throws XWSSecurityException {
        BuilderResult result = new BuilderResult();
        String assertionId = null;
        
        SecurityHeaderElement she = null;
        
        Element samlAssertion = keyBinding.getAssertion();
        if(samlAssertion != null)
            she = new GSHeaderElement(samlAssertion);
        JAXBEncryptedKey ek  = null;
        String asID = "";
        String id = "";
        String keyEncAlgo = XMLCipher.RSA_v1dot5;
        X509Certificate x509Cert = null;
        Key samlkey = null;
        if(samlAssertion != null){
            asID = samlAssertion.getAttributeNS(null,"AssertionID");
            if(she == null){
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1811_NULL_SAML_ASSERTION());
                throw new XWSSecurityException("SAML Assertion is NULL");
            }
            if(asID == null || asID.length() ==0){
                id = samlAssertion.getAttributeNS(null,"ID");
                she.setId(id);
            }else{
                she.setId(asID);
            }
        }else{
            she = (SecurityHeaderElement) context.getExtraneousProperty(MessageConstants.INCOMING_SAML_ASSERTION);
            if(she == null){
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1811_NULL_SAML_ASSERTION());
                throw new XWSSecurityException("SAML Assertion is NULL");
            }
            asID = she.getId();
        }
        if(logger.isLoggable(Level.FINEST)){
            logger.log(Level.FINEST, "SAML Assertion id:"+asID);
        }
        
        Key dataProtectionKey = null;
        if(forSign){
            PrivateKeyBinding privKBinding  = (PrivateKeyBinding)keyBinding.getKeyBinding();
            dataProtectionKey = privKBinding.getPrivateKey();
            if (dataProtectionKey == null) {
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1810_NULL_PRIVATEKEY_SAML());
                throw new XWSSecurityException("PrivateKey null inside PrivateKeyBinding set for SAML Policy ");
            }
            
            if(context.getSecurityHeader().getChildElement(she.getId()) == null){
                context.getSecurityHeader().add(she);
            }
            
        }else{
            //Key key = null;
            //key = KeyResolver.resolveSamlAssertion(context.getSecurableSoapMessage(), samlBinding.getAssertion(), true, context, assertionID);
            
            SecurityHeaderElement assertion = (SecurityHeaderElement) context.getExtraneousProperty(MessageConstants.INCOMING_SAML_ASSERTION);
            samlkey = ((SAMLAssertion)assertion).getKey();
            /*
            x509Cert = context.getSecurityEnvironment().getCertificate(
                    context.getExtraneousProperties() ,(PublicKey)key, false);
            if (x509Cert == null) {
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1812_MISSING_CERT_SAMLASSERTION());
                throw new XWSSecurityException("Could not locate Certificate corresponding to Key in SubjectConfirmation of SAML Assertion");
            }
            */
            if (!"".equals(keyBinding.getKeyAlgorithm())) {
                keyEncAlgo = keyBinding.getKeyAlgorithm();
            }
            String dataEncAlgo = SecurityUtil.getDataEncryptionAlgo(context);
            dataProtectionKey = SecurityUtil.generateSymmetricKey(dataEncAlgo);
            
        }
        Element authorityBinding = keyBinding.getAuthorityBinding();
        //assertionId = keyBinding.getAssertionId();
        
        
        
        String referenceType = keyBinding.getReferenceType();
        if (referenceType.equals(MessageConstants.EMBEDDED_REFERENCE_TYPE)) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1813_UNSUPPORTED_EMBEDDEDREFERENCETYPE_SAML());
            throw new XWSSecurityException("Embedded Reference Type for SAML Assertions not supported yet");
        }
        
        assertionId = she.getId();
        
        //todo reference different keyreference types.
        SecurityTokenReference samlSTR = null;
        if(authorityBinding == null){
            KeyIdentifier keyIdentifier = new KeyIdentifier(context.getSOAPVersion());
            keyIdentifier.setValue(assertionId);
            keyIdentifier.setValueType(MessageConstants.WSSE_SAML_KEY_IDENTIFIER_VALUE_TYPE);
            samlSTR = elementFactory.createSecurityTokenReference(keyIdentifier);
            if(id != null){
                samlSTR.setTokenType(MessageConstants.WSSE_SAML_v2_0_TOKEN_TYPE);
            }else{
                samlSTR.setTokenType(MessageConstants.WSSE_SAML_v1_1_TOKEN_TYPE);
            }
            //((SecurityTokenReferenceType)samlSTR).getAny().add(authorityBinding);
            ((NamespaceContextEx)context.getNamespaceContext()).addWSS11NS();
            buildKeyInfo((SecurityTokenReference) samlSTR);
        } else{
            //TODO: handle authorityBinding != null
        }
        
        
        if(!forSign){
            HashMap ekCache = context.getEncryptedKeyCache();
            ek = (JAXBEncryptedKey)elementFactory.createEncryptedKey(context.generateID(),keyEncAlgo,super.keyInfo,samlkey,dataProtectionKey);
            context.getSecurityHeader().add(ek);
            String ekId = ek.getId();
            DirectReference dr = buildDirectReference(ekId,MessageConstants.EncryptedKey_NS);
            result.setKeyInfo(buildKeyInfo(dr,""));
        }else{
            result.setKeyInfo(super.keyInfo);
        }
        
        HashMap sentSamlKeys = (HashMap) context.getExtraneousProperty(MessageConstants.STORED_SAML_KEYS);
        if(sentSamlKeys == null)
            sentSamlKeys = new HashMap();
        sentSamlKeys.put(assertionId, dataProtectionKey);
        context.setExtraneousProperty(MessageConstants.STORED_SAML_KEYS, sentSamlKeys);
        
        result.setDataProtectionKey(dataProtectionKey);
        
        return result;
    }
    
}
