/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package com.sun.xml.ws.security.opt.impl.keyinfo;

import com.sun.xml.ws.security.opt.api.SecurityElementWriter;
import com.sun.xml.ws.security.opt.api.SecurityHeaderElement;
import com.sun.xml.ws.security.opt.impl.util.JAXBUtil;
import com.sun.xml.wss.saml.Assertion;
import java.io.OutputStream;
import java.util.HashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

import com.sun.xml.ws.api.SOAPVersion;
/**
 *
 * @author K.Venugopal@sun.com
 */
public class SAMLToken implements SecurityHeaderElement, SecurityElementWriter {
    private Assertion samlToken =null;
    private JAXBContext jxbContext = null;
    private SOAPVersion soapVersion = null;
    /** Creates a new instance of SAMLToken */
    public SAMLToken(Assertion assertion,JAXBContext jxbContext,SOAPVersion soapVersion) {
        this.samlToken = assertion;
        this.jxbContext = jxbContext;
        this.soapVersion = soapVersion;
        
    }
    
    public boolean refersToSecHdrWithId(String id) {
        throw new UnsupportedOperationException();
    }
    
    public String getId() {
        return samlToken.getAssertionID();
    }
    
    public void setId(String id) {
        throw new UnsupportedOperationException();
    }
    
    public String getNamespaceURI() {
        throw new UnsupportedOperationException();
    }
    
    public String getLocalPart() {
        throw new UnsupportedOperationException();
    }
    
    public XMLStreamReader readHeader() throws XMLStreamException {
        throw new UnsupportedOperationException();
    }
    
    public void writeTo(XMLStreamWriter streamWriter) throws XMLStreamException {
        try{
            Marshaller marshaller = jxbContext.createMarshaller();
            if(SOAPVersion.SOAP_11 == soapVersion){
                marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", JAXBUtil.prefixMapper11);
            }else{
                marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", JAXBUtil.prefixMapper12);
            }
            marshaller.setProperty(Marshaller.JAXB_FRAGMENT,true);
            marshaller.setProperty("com.sun.xml.bind.xmlDeclaration", false);
            marshaller.marshal(samlToken,streamWriter);
            
        }catch(javax.xml.bind.PropertyException pe){
            throw new XMLStreamException("Error occurred while setting security marshaller properties",pe);
        }catch(JAXBException je){
            throw new XMLStreamException("Error occurred while marshalling SAMLAssertion",je);
        }
    }
    
    public void writeTo(XMLStreamWriter streamWriter, HashMap props) throws XMLStreamException {
    }
    
    public void writeTo(OutputStream os) {
    }
    
}
