/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package com.sun.xml.ws.security.opt.impl.keyinfo;

import com.sun.xml.ws.security.impl.kerberos.KerberosContext;
import com.sun.xml.ws.security.opt.api.keyinfo.BuilderResult;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.crypto.OctectStreamData;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.ws.security.opt.api.keyinfo.BinarySecurityToken;
import com.sun.xml.ws.security.opt.api.reference.DirectReference;
import com.sun.xml.wss.logging.impl.opt.token.LogStringsMessages;
import java.util.logging.Level;

/**
 *
 * @author ashutosh.shahi@sun.com
 */
public class KerberosTokenBuilder extends TokenBuilder {
    
    AuthenticationTokenPolicy.KerberosTokenBinding binding = null;
    
    public KerberosTokenBuilder(JAXBFilterProcessingContext context,
            AuthenticationTokenPolicy.KerberosTokenBinding binding) {
        super(context);
        this.binding = binding;
    }
    
    public BuilderResult process() throws XWSSecurityException {
        String id = binding.getUUID();
        if(id == null || id.equals("")){
            id = context.generateID();
        }
        
        setIncludeTokenPolicy();
        
        String referenceType = binding.getReferenceType();
        if(logger.isLoggable(Level.FINEST)){
            logger.log(Level.FINEST, LogStringsMessages.WSS_1853_REFERENCETYPE_KERBEROS_TOKEN(referenceType));
        }
        BuilderResult result = new BuilderResult();
        
        if(referenceType.equals(MessageConstants.DIRECT_REFERENCE_TYPE)){
            BinarySecurityToken bst = createKerberosBST(binding, binding.getTokenValue());
            if(bst == null){
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1802_WRONG_TOKENINCLUSION_POLICY());
                throw new XWSSecurityException(LogStringsMessages.WSS_1802_WRONG_TOKENINCLUSION_POLICY());
            }
            DirectReference dr = buildDirectReference(bst.getId(), MessageConstants.KERBEROS_V5_GSS_APREQ);
            buildKeyInfo(dr,binding.getSTRID());
        } else if(referenceType.equals(MessageConstants.KEY_INDETIFIER_TYPE)){
            BinarySecurityToken bst = createKerberosBST(binding,binding.getTokenValue());
            buildKeyInfoWithKIKerberos(binding, MessageConstants.KERBEROS_v5_APREQ_IDENTIFIER);
            if(binding.getSTRID() != null){
                OctectStreamData osd = new OctectStreamData(new String(binding.getTokenValue()));
                context.getElementCache().put(binding.getSTRID(),osd);
            }
        } else{
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1803_UNSUPPORTED_REFERENCE_TYPE(referenceType));
            throw new XWSSecurityException(LogStringsMessages.WSS_1803_UNSUPPORTED_REFERENCE_TYPE(referenceType));
        }
        result.setKeyInfo(keyInfo);
        return result;
    }
    
    private void setIncludeTokenPolicy() throws XWSSecurityException{
        // no referencetype adjustment if it is not WS-SecurityPolicy
        if(!binding.policyTokenWasSet()){
            return;
        }
        
        if(binding.INCLUDE_ALWAYS.equals(binding.getIncludeToken()) ||
                binding.INCLUDE_ALWAYS_TO_RECIPIENT.equals(binding.getIncludeToken()) ){
            // This should never happen as Always and AlwaysToRecipient 
            // are not allowed for Kerberos Tokens
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1822_KERBEROS_ALWAYS_NOTALLOWED());
            throw new XWSSecurityException(LogStringsMessages.WSS_1822_KERBEROS_ALWAYS_NOTALLOWED());
        } else if(binding.INCLUDE_NEVER.equals(binding.getIncludeToken())){
            binding.setReferenceType(MessageConstants.KEY_INDETIFIER_TYPE);
        } else if(binding.INCLUDE_ONCE.equals(binding.getIncludeToken())){
            binding.setReferenceType(MessageConstants.DIRECT_REFERENCE_TYPE);
        }
    }
    
}
