/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package com.sun.xml.ws.security.opt.impl.incoming;

import com.sun.xml.stream.buffer.MutableXMLStreamBuffer;
import com.sun.xml.stream.buffer.stax.StreamReaderBufferCreator;
import com.sun.xml.stream.buffer.stax.StreamWriterBufferCreator;
import com.sun.xml.ws.security.opt.api.NamespaceContextInfo;
import com.sun.xml.ws.security.opt.api.PolicyBuilder;
import com.sun.xml.ws.security.opt.api.SecurityElementWriter;
import com.sun.xml.ws.security.opt.api.SecurityHeaderElement;
import com.sun.xml.ws.security.opt.api.TokenValidator;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.incoming.processor.KeyInfoProcessor;
import com.sun.xml.ws.security.opt.impl.util.StreamUtil;
import com.sun.xml.wss.ProcessingContext;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.MessageConstants;

import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import java.io.OutputStream;
import java.security.Key;
import java.util.HashMap;
import javax.xml.crypto.KeySelector.Purpose;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import static com.sun.xml.wss.impl.MessageConstants.SIGNATURE_LNAME;
import static com.sun.xml.wss.impl.MessageConstants.DSIG_NS;
import com.sun.xml.wss.saml.Assertion;
import com.sun.xml.wss.saml.SAMLException;
import java.util.logging.Level;
import javax.security.auth.Subject;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.transform.dom.DOMResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/**
 *
 * @author K.Venugopal@sun.com
 */
public class SAMLAssertion implements SecurityHeaderElement,PolicyBuilder,TokenValidator,NamespaceContextInfo,
        SecurityElementWriter{
    
    private String id ="";
    private String localName= "";
    private String namespaceURI="";
    private Key key = null;
    private JAXBFilterProcessingContext jpc = null;
    private HashMap<String,String> samlHeaderNSContext = null;
    private StreamReaderBufferCreator creator = null;
    private Signature sig = null;
    private MutableXMLStreamBuffer buffer = null;
    
    private static final String KEYINFO_ELEMENT = "KeyInfo";
    
    /** Creates a new instance of SAMLAssertion */
    public SAMLAssertion(XMLStreamReader reader, JAXBFilterProcessingContext jpc,StreamReaderBufferCreator creator ,HashMap nsDecl) throws XWSSecurityException{
        this.jpc = jpc;
        this.creator = creator;
        id = reader.getAttributeValue(null,"AssertionID");
        if(id == null){
            id = reader.getAttributeValue(null,"ID");
        }
        namespaceURI = reader.getNamespaceURI();
        localName = reader.getLocalName();
        samlHeaderNSContext = new HashMap<String,String>();
        samlHeaderNSContext.putAll(nsDecl);
        if (reader.getNamespaceCount() > 0) {
            for (int i = 0; i < reader.getNamespaceCount(); i++) {
                samlHeaderNSContext.put(reader.getNamespacePrefix(i), reader.getNamespaceURI(i));
            }
        }
        
        //to be picked up from pool of buffers.
        buffer = new MutableXMLStreamBuffer();
        StreamWriterBufferCreator bCreator = new StreamWriterBufferCreator(buffer);
        process(reader,(XMLStreamWriter)bCreator);
    }
    
    public SAMLAssertion(){
    }
   
    
    public boolean refersToSecHdrWithId(String id) {
        return false;
    }
    
    public String getId() {
        return id;
    }
    
    public void setId(final String id) {
        throw new UnsupportedOperationException("not implemented");
    }
    
    public String getNamespaceURI() {
        return namespaceURI;
    }
    
    public String getLocalPart() {
        return localName;
    }
    
    public XMLStreamReader readHeader() throws XMLStreamException {
        return buffer.readAsXMLStreamReader();
    }    
  
    public WSSPolicy getPolicy() {
        return null;
    }
    
    public void validate(ProcessingContext context) throws XWSSecurityException {
        try{
            context.getSecurityEnvironment().validateSAMLAssertion(context.getExtraneousProperties(),readHeader());
            context.getSecurityEnvironment().updateOtherPartySubject((Subject)context.getExtraneousProperties().get(MessageConstants.AUTH_SUBJECT),readHeader());
        }catch(XMLStreamException xe){
            throw new XWSSecurityException("Error occurred while trying to validate SAMLAssertion",xe);
        }
    }
    
    public HashMap<String, String> getInscopeNSContext() {
        return samlHeaderNSContext;
    }
    
    public void writeTo(XMLStreamWriter streamWriter) throws XMLStreamException {
        buffer.writeToXMLStreamWriter(streamWriter);
    }
    
    public void writeTo(XMLStreamWriter streamWriter, HashMap props) throws XMLStreamException {
        //is this ok?
        writeTo(streamWriter);
    }
    
    public void writeTo(OutputStream os) {
        throw new UnsupportedOperationException();
    }
    
    public boolean isHOK(){
        if(sig != null){
            return true;
        }
        return false;
    }
    
    public boolean validateSignature()throws XWSSecurityException{
        if(isHOK()){
            return sig.validate();
        }
        return false;
    }
    
    public void processNoValidation(XMLStreamReader reader,XMLStreamWriter buffer) throws XWSSecurityException{
       
        try{
            StreamUtil.writeCurrentEvent(reader,buffer);
            while(reader.hasNext()){               
                reader.next();
                if(_break(reader)){
                    StreamUtil.writeCurrentEvent(reader,buffer);
                    reader.next();
                    break;
                }else{
                    StreamUtil.writeCurrentEvent(reader,buffer);
                }
            }
        }catch(XMLStreamException xe){
            throw new XWSSecurityException("Error occurred while reading SAMLAssertion",xe);
        }
    }
    
    public void process(XMLStreamReader reader,XMLStreamWriter buffer) throws XWSSecurityException{       
        
        try{
            StreamUtil.writeCurrentEvent(reader,buffer);
            while(reader.hasNext()){               
                reader.next();
                switch(reader.getEventType()){
                    case XMLStreamReader.START_ELEMENT :{                        
                        if(reader.getLocalName() == SIGNATURE_LNAME && reader.getNamespaceURI() == DSIG_NS){
                            sig = new Signature(jpc,samlHeaderNSContext,creator,false);
                            jpc.isSamlSignatureKey(true);
                            sig.process(reader, false);  
                            jpc.isSamlSignatureKey(false);
                        }
                        break;
                    }                    
                }
                if(_break(reader)){
                    StreamUtil.writeCurrentEvent(reader,buffer);
                    reader.next();
                    break;
                }else{
                    if(reader.getEventType() == reader.START_ELEMENT && reader.getLocalName().equals("Advice")){                        
                        StreamUtil.writeCurrentEvent(reader,buffer);
                        skipAdviceValidation(reader, buffer);
                    }else{
                        StreamUtil.writeCurrentEvent(reader,buffer);
                    }
                }
            }
        }catch(XMLStreamException xe){
            throw new XWSSecurityException("Error occurred while reading SAMLAssertion",xe);
        }
    }
    
    public void skipAdviceValidation(XMLStreamReader reader,XMLStreamWriter buffer) throws XWSSecurityException{
        int adviceElementCount = 1;
        try{
            while(!(reader.getLocalName().equals("Advice") && 
                        reader.getEventType() == reader.END_ELEMENT && 
                            adviceElementCount == 0)){                
                reader.next();
                if(reader.getEventType() == reader.START_ELEMENT && reader.getLocalName().equals("Advice")){
                    adviceElementCount++;
                }
                if(reader.getEventType() == reader.END_ELEMENT && reader.getLocalName().equals("Advice")){
                    adviceElementCount--;
                }
                StreamUtil.writeCurrentEvent(reader,buffer);
            }
        }catch(XMLStreamException xe){
            throw new XWSSecurityException("Error occurred while reading SAMLAssertion",xe);
        }
    }
    
    public Key getKey()throws XWSSecurityException{
        if(key == null){
            try{
                XMLStreamReader reader = readHeader();
                while(reader.getEventType() != reader.END_DOCUMENT){
                    switch(reader.getEventType()){
                        case XMLStreamReader.START_ELEMENT :{
                            if(reader.getLocalName() == KEYINFO_ELEMENT && reader.getNamespaceURI() == DSIG_NS){
                                jpc.isSAMLEK(true);
                                KeyInfoProcessor kip = new KeyInfoProcessor(jpc,Purpose.VERIFY, true);
                                key = kip.getKey(reader);
                                jpc.isSAMLEK(false);
                                return key;
                            }
                            break;
                        }
                        default:{
                            break;
                        }
                    }
                    if(reader.hasNext()){
                        if(reader.getEventType() == reader.START_ELEMENT && reader.getLocalName().equals("Advice")){
                            int adviceElementCount = 1;
                            while(!(reader.getLocalName().equals("Advice") &&
                                    reader.getEventType() == reader.END_ELEMENT &&
                                    adviceElementCount == 0)){
                                reader.next();
                                if(reader.getEventType() == reader.START_ELEMENT && reader.getLocalName().equals("Advice")){
                                    adviceElementCount++;
                                }
                                if(reader.getEventType() == reader.END_ELEMENT && reader.getLocalName().equals("Advice")){
                                    adviceElementCount--;
                                }
                            }
                            reader.next();
                        }else{
                            reader.next();
                        }
                    }else{
                        break;//should not happen;
                    }
                }
            }catch(XMLStreamException xe){
                throw new XWSSecurityException("Error occurred while obtaining Key from SAMLAssertion",xe);
            }
        }
        return key;
    }
    
    private boolean _break(XMLStreamReader reader) {
        if(reader.getEventType() == reader.END_ELEMENT){
            if(reader.getLocalName() == MessageConstants.SAML_ASSERTION_LNAME ){
                String uri = reader.getNamespaceURI();
                if( uri == MessageConstants.SAML_v2_0_NS || uri ==MessageConstants.SAML_v1_0_NS || uri == MessageConstants.SAML_v1_1_NS ){
                    return true;
                }
            }
        }
        return false;
    }
    
}
