/*

 * The contents of this file are subject to the terms

 * of the Common Development and Distribution License

 * (the License).  You may not use this file except in

 * compliance with the License.

 *

 * You can obtain a copy of the license at

 * https://glassfish.dev.java.net/public/CDDLv1.0.html.

 * See the License for the specific language governing

 * permissions and limitations under the License.

 *

 * When distributing Covered Code, include this CDDL

 * Header Notice in each file and include the License file

 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.

 * If applicable, add the following below the CDDL Header,

 * with the fields enclosed by brackets [] replaced by

 * you own identifying information:

 * "Portions Copyrighted [year] [name of copyright owner]"

 *

 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved

 */



package com.sun.xml.ws.security.opt.impl.incoming;



import com.sun.xml.ws.security.opt.api.SecurityElementWriter;

import com.sun.xml.ws.security.opt.api.SecurityHeaderElement;

import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;

import com.sun.xml.wss.XWSSecurityException;

import com.sun.xml.wss.impl.MessageConstants;

import com.sun.xml.wss.impl.policy.mls.WSSPolicy;



import java.io.InputStream;

import java.io.OutputStream;

import java.security.Key;

import java.util.HashMap;



import javax.xml.stream.XMLStreamException;

import javax.xml.stream.XMLStreamReader;

import javax.xml.stream.XMLStreamWriter;



/**

 *

 * @author Ashutosh.Shahi@sun.com

 */

public class EncryptedHeader implements SecurityHeaderElement, SecurityElementWriter  {

    

    private JAXBFilterProcessingContext pc = null;

    private String id = "";

    private String namespaceURI = "";

    private String localName = "";

    private EncryptedData ed = null;

    private HashMap<String, String> parentNS = null;



    /** Creates a new instance of EncryptedHeader */

    public EncryptedHeader(XMLStreamReader reader,JAXBFilterProcessingContext pc, HashMap<String, String> parentNS) throws XMLStreamException, XWSSecurityException {

        this.pc = pc;

        this.parentNS = parentNS;

        process(reader);

    }

    

    public EncryptedData getEncryptedData(){

        return ed;

    }

    

    public String getEncryptionAlgorithm(){

        return ed.getEncryptionAlgorithm();

    }

    

    public Key getKey(){

        return ed.getKey();

    }

    

    public InputStream getCipherInputStream() throws XWSSecurityException{

        return ed.getCipherInputStream();

    }

    

    public InputStream getCipherInputStream(Key key) throws XWSSecurityException{

        return ed.getCipherInputStream(key);

    }

    

    public XMLStreamReader getDecryptedData() throws XMLStreamException, XWSSecurityException{

        return ed.getDecryptedData();

    }

    

    public XMLStreamReader getDecryptedData(Key key) throws XMLStreamException, XWSSecurityException{

        return ed.getDecryptedData(key);

    }

    

    public boolean refersToSecHdrWithId(String id) {

        throw new UnsupportedOperationException();

    }

    

    public String getId() {

        return id;

    }

    

    public void setId(String id) {

        throw new UnsupportedOperationException();

    }

    

    public String getNamespaceURI() {

        return namespaceURI;

    }

    

    public String getLocalPart() {

        return localName;

    }

    

    public XMLStreamReader readHeader() throws XMLStreamException {

        throw new UnsupportedOperationException();

    }

    

    public void writeTo(XMLStreamWriter streamWriter) throws XMLStreamException {

        throw new UnsupportedOperationException();

    }

    

    public void writeTo(XMLStreamWriter streamWriter, HashMap props) throws XMLStreamException {

        throw new UnsupportedOperationException();

    }

    

    public void writeTo(OutputStream os) {

        throw new UnsupportedOperationException();

    }

    

    private void process(XMLStreamReader reader) throws XMLStreamException, XWSSecurityException{

        id = reader.getAttributeValue(MessageConstants.WSU_NS,"Id");

        namespaceURI = reader.getNamespaceURI();

        localName = reader.getLocalName();

        

        while(reader.hasNext()){

            reader.next();

            if(reader.getEventType() == XMLStreamReader.START_ELEMENT){

                if(MessageConstants.ENCRYPTED_DATA_LNAME.equals(reader.getLocalName()) && MessageConstants.XENC_NS.equals(reader.getNamespaceURI())){

                    ed = new EncryptedData(reader, pc, parentNS);

                }

            }

            

            if(reader.getEventType() == XMLStreamReader.END_ELEMENT){

                if(MessageConstants.ENCRYPTED_HEADER_LNAME.equals(reader.getLocalName()) && MessageConstants.WSSE11_NS.equals(reader.getNamespaceURI())){

                    break;

                }

            }

        }

    }

    

    public WSSPolicy getInferredKB(){

        return ed.getInferredKB();

    }

    

}

