/*
 * SignedMessagePart.java
 *
 * Created on August 24, 2006, 2:19 PM
 *
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package com.sun.xml.ws.security.opt.impl.dsig;

import com.sun.xml.ws.security.opt.api.SecurityElement;
import com.sun.xml.ws.security.opt.api.SecurityElementWriter;
import com.sun.xml.ws.security.opt.api.SignedData;
import com.sun.xml.ws.security.opt.impl.message.SOAPBody;
import com.sun.xml.wss.impl.XWSSecurityRuntimeException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.ByteArrayOutputStream;
import java.util.HashMap;

/**
 *
 * @author Ashutosh.Shahi@sun.com
 */
public class SignedMessagePart implements SecurityElement, SignedData, SecurityElementWriter{
    protected boolean isCanonicalized = false;
    private SecurityElement se = null;
    private SOAPBody body = null;
    private boolean contentOnly = false;
    
    private ByteArrayOutputStream storedStream = new ByteArrayOutputStream();
    
    protected byte[] digestValue = null;
    
    /** Creates a new instance of SignedMessagePart */
    public SignedMessagePart(){
    }
    
    public SignedMessagePart(SecurityElement se) {
        this.se = se;
    }
    
    public SignedMessagePart(SOAPBody body, boolean contentOnly){
        this.body = body;
        this.contentOnly = contentOnly;
    }
    
    public String getId() {
        if(body != null){
            if(!contentOnly){
                return body.getId();
            } else{
                return body.getBodyContentId();
            }
        }else{
            return se.getId();
        }
    }
    
    public void setId(String id) {
        if(body != null){
            if(!contentOnly){
                body.setId(id);
            } else{
                body.setBodyContentId(id);
            }
        }else{
            se.setId(id);
        }
    }
    
    public String getNamespaceURI() {
        if(body != null){
            if(!contentOnly){
                return body.getSOAPVersion().nsUri;
            } else {
                return body.getPayloadNamespaceURI();
            }
        }else {
            return se.getNamespaceURI();
        }
    }
    
    public String getLocalPart() {
        if(body != null){
            if(!contentOnly){
                return "Body";
            } else {
                return body.getPayloadLocalPart();
            }
        }else {
            return se.getLocalPart();
        }
    }
    
    public javax.xml.stream.XMLStreamReader readHeader() throws javax.xml.stream.XMLStreamException {
        throw new UnsupportedOperationException();
    }
    
    public void writeTo(OutputStream os) {
        try{
            if(isCanonicalized)
                writeCanonicalized(os);
        } catch(IOException ioe){
            throw new XWSSecurityRuntimeException(ioe);
        }
    }
    
    public void writeTo(javax.xml.stream.XMLStreamWriter streamWriter) throws javax.xml.stream.XMLStreamException {
        if(body != null){
            body.cachePayLoad();//will be replaced with 2nd round of optimization.            
            if(!contentOnly){
                body.writeTo(streamWriter);
            }else{
                body.writePayload(streamWriter);
            }            
        }else{
            ((SecurityElementWriter)se).writeTo(streamWriter);
        }
        
    }
    
    public void writeTo(javax.xml.stream.XMLStreamWriter streamWriter, HashMap props) throws javax.xml.stream.XMLStreamException {     
        writeTo(streamWriter);
    }
    
    public void writeCanonicalized(OutputStream os) throws IOException{
        if(storedStream == null)
            return;
        storedStream.writeTo(os);
    }
    
    public void setDigestValue(byte[] digestValue) {
        this.digestValue = digestValue;
    }
    
    public byte[] getDigestValue() {
        return digestValue;
    }
}
