/*

 * JAXBURIDereferencer.java

 *

 * Created on January 24, 2006, 11:47 AM

 */



/*

 * The contents of this file are subject to the terms

 * of the Common Development and Distribution License

 * (the License).  You may not use this file except in

 * compliance with the License.

 * 

 * You can obtain a copy of the license at

 * https://glassfish.dev.java.net/public/CDDLv1.0.html.

 * See the License for the specific language governing

 * permissions and limitations under the License.

 * 

 * When distributing Covered Code, include this CDDL

 * Header Notice in each file and include the License file

 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.

 * If applicable, add the following below the CDDL Header,

 * with the fields enclosed by brackets [] replaced by

 * you own identifying information:

 * "Portions Copyrighted [year] [name of copyright owner]"

 * 

 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved

 */



package com.sun.xml.ws.security.opt.crypto.jaxb;



import javax.xml.bind.JAXBContext;

import javax.xml.bind.JAXBElement;

import javax.xml.crypto.Data;

import javax.xml.crypto.URIReference;

import javax.xml.crypto.URIReferenceException;

import javax.xml.crypto.XMLCryptoContext;



import com.sun.xml.ws.security.opt.impl.crypto.JAXBDataImpl;



/**

 *

 * @author Abhijit Das

 */

public class JAXBURIDereferencer  implements javax.xml.crypto.URIDereferencer {

    private JAXBElement jaxbElement = null;

    private JAXBContext jbContext = null;

    /**

     * Creates a new instance of JAXBURIDereferencer

     */

    public JAXBURIDereferencer() {

    }



    /**

     * Dereferences the specified URIReference and returns the dereferenced data.

     *

     * uriReference - the URIReference

     * xMLCryptoContext - an XMLCryptoContext that may contain additional useful 

     * information for dereferencing the URI. This implementation should 

     * dereference the specified URIReference against the context's baseURI 

     * parameter, if specified.

     *

     * 

     * @return Data - the dereferenced data

     */

    public Data dereference(URIReference uRIReference, XMLCryptoContext xMLCryptoContext) throws URIReferenceException {

        JAXBDataImpl data = new JAXBDataImpl(getJaxbElement(), getJbContext(), new com.sun.xml.ws.security.opt.impl.util.NamespaceContextEx(false));

        return data;

    }



    /**

     * Get the JAXBElement

     *

     * @return JAXBElement

     */

    public JAXBElement getJaxbElement() {

        return jaxbElement;

    }



    /*

     * Set JAXBElement

     * @param - jaxbElement 

     */

    public void setJaxbElement(JAXBElement jaxbElement) {

        this.jaxbElement = jaxbElement;

    }



    /**

     * Get JAXBContext

     *

     * @return JAXBContext

     */

    public JAXBContext getJbContext() {

        return jbContext;

    }



    /**

     * Set JAXBContext

     *

     * @param jbContext - JAXBContext

     */

    public void setJbContext(JAXBContext jbContext) {

        this.jbContext = jbContext;

    }

    

}

