/*
 * SignedInfo.java
 *
 * Created on January 24, 2006, 3:12 PM
 */

/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package com.sun.xml.ws.security.opt.crypto.dsig;

import java.io.InputStream;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.jvnet.staxex.XMLStreamReaderEx;

/**
 *
 * @author Abhijit Das
 */
@XmlRootElement(name="SignedInfo",namespace = "http://www.w3.org/2000/09/xmldsig#")
public class SignedInfo extends com.sun.xml.security.core.dsig.SignedInfoType implements javax.xml.crypto.dsig.SignedInfo {
    @XmlTransient private XMLStreamReaderEx _streamSI = null;
    @XmlTransient private byte [] canonInfo = null;
    /** Creates a new instance of SignedInfo */
    public SignedInfo() {
    }
    
    public List getReferences() {
        return reference;
    }
    
    public InputStream getCanonicalizedData() {
        return null;
    }
    
    public boolean isFeatureSupported(String string) {
        return false;
    }
    
    public SignatureMethod getSignatureMethod() {
        return signatureMethod;
    }
    
    public CanonicalizationMethod getCanonicalizationMethod() {
        return canonicalizationMethod;
    }
    
    public void setReference(List<Reference> reference) {
        this.reference = reference;
    }
    
    public byte [] getCanonicalizedSI(){
        //System.out.println("CanonSI is "+ new String(canonInfo));
        return canonInfo;
    }
    
    public void setCanonicalizedSI(byte [] info){
        this.canonInfo = info;
    }
    
    public XMLStreamReaderEx getSignedInfo() {
        return _streamSI;
    }
    
    public void setSignedInfo(XMLStreamReaderEx _streamSI) {
        this._streamSI = _streamSI;
    }
}
