/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package com.sun.wsit.security;

import java.io.IOException;
import java.security.cert.X509Certificate;
/**
 *
 * @author sk112103
 */
public class SunKeyIdentifierSPI extends com.sun.xml.wss.core.reference.KeyIdentifierSPI {
    
    /** Creates a new instance of SunKeyIdentifierSPI */
    public SunKeyIdentifierSPI() {
    }

    public byte[] getSubjectKeyIdentifier(X509Certificate cert) throws KeyIdentifierSPIException {
        byte[] subjectKeyIdentifier =
                cert.getExtensionValue(SUBJECT_KEY_IDENTIFIER_OID);
        if (subjectKeyIdentifier == null)
            return null;
        
        try {
            sun.security.x509.KeyIdentifier keyId = null;
            
            sun.security.util.DerValue derVal = new sun.security.util.DerValue(
                    new sun.security.util.DerInputStream(subjectKeyIdentifier).getOctetString());
            
            keyId = new sun.security.x509.KeyIdentifier(derVal.getOctetString());
            return keyId.getIdentifier();
        } catch (NoClassDefFoundError ncde) {
            // TODO X509 Token profile states that only the contents of the
            // OCTET STRING should be returned, excluding the "prefix"
            byte[] dest = new byte[subjectKeyIdentifier.length-4];
            System.arraycopy(
                    subjectKeyIdentifier, 4, dest, 0, subjectKeyIdentifier.length-4);
            return dest;
            
        } catch (IOException e) {
            //log exception
            throw new KeyIdentifierSPIException(e);
        }

    }
    
    
}
