/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.processor.util;

import com.sun.tools.ws.processor.model.AbstractType;
import com.sun.tools.ws.processor.model.Block;
import com.sun.tools.ws.processor.model.ExtendedModelVisitor;
import com.sun.tools.ws.processor.model.Fault;
import com.sun.tools.ws.processor.model.Model;
import com.sun.tools.ws.processor.model.Parameter;
import com.sun.tools.ws.processor.model.Port;
import com.sun.tools.ws.processor.model.Service;
import com.sun.tools.ws.processor.model.jaxb.JAXBType;
import com.sun.tools.ws.processor.model.jaxb.JAXBTypeVisitor;
import com.sun.tools.ws.processor.model.jaxb.RpcLitStructure;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassNameCollector
extends ExtendedModelVisitor
implements JAXBTypeVisitor {
    private Set<String> _seiClassNames;
    private Set<String> _jaxbGeneratedClassNames;
    private Set<String> _exceptionClassNames;
    boolean doneVisitingJAXBModel = false;
    private Set _allClassNames;
    private Set _exceptions;
    private Set _wsdlBindingNames;
    private Set _conflictingClassNames;
    private Set<QName> _portTypeNames;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Model model) {
        try {
            this._allClassNames = new HashSet();
            this._exceptions = new HashSet();
            this._wsdlBindingNames = new HashSet();
            this._conflictingClassNames = new HashSet();
            this._seiClassNames = new HashSet<String>();
            this._jaxbGeneratedClassNames = new HashSet<String>();
            this._exceptionClassNames = new HashSet<String>();
            this._portTypeNames = new HashSet<QName>();
            this.visit(model);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this._allClassNames = null;
            this._exceptions = null;
        }
    }

    public Set getConflictingClassNames() {
        return this._conflictingClassNames;
    }

    @Override
    protected void postVisit(Model model) throws Exception {
        Iterator iter = model.getExtraTypes();
        while (iter.hasNext()) {
            this.visitType((AbstractType)iter.next());
        }
    }

    @Override
    protected void preVisit(Service service) throws Exception {
        this.registerClassName(service.getJavaInterface().getName());
    }

    protected void processPort11x(Port port) {
        QName wsdlBindingName = (QName)port.getProperty("com.sun.xml.ws.processor.model.WSDLBindingName");
        if (!this._wsdlBindingNames.contains(wsdlBindingName)) {
            this.registerClassName(port.getJavaInterface().getName());
        }
        this.registerClassName((String)port.getProperty("com.sun.xml.ws.processor.model.StubClassName"));
        this.registerClassName((String)port.getProperty("com.sun.xml.ws.processor.model.TieClassName"));
    }

    @Override
    protected void preVisit(Port port) throws Exception {
        QName portTypeName = (QName)port.getProperty("com.sun.xml.ws.processor.model.WSDLPortTypeName");
        if (this._portTypeNames.contains(portTypeName)) {
            return;
        }
        this.addSEIClassName(port.getJavaInterface().getName());
    }

    private void addSEIClassName(String s) {
        this._seiClassNames.add(s);
        this.registerClassName(s);
    }

    @Override
    protected void postVisit(Port port) throws Exception {
        QName portTypeName;
        QName wsdlBindingName = (QName)port.getProperty("com.sun.xml.ws.processor.model.WSDLBindingName");
        if (!this._wsdlBindingNames.contains(wsdlBindingName)) {
            this._wsdlBindingNames.add(wsdlBindingName);
        }
        if (!this._portTypeNames.contains(portTypeName = (QName)port.getProperty("com.sun.xml.ws.processor.model.WSDLPortTypeName"))) {
            this._portTypeNames.add(portTypeName);
        }
    }

    @Override
    protected boolean shouldVisit(Port port) {
        QName wsdlBindingName = (QName)port.getProperty("com.sun.xml.ws.processor.model.WSDLBindingName");
        return !this._wsdlBindingNames.contains(wsdlBindingName);
    }

    @Override
    protected void preVisit(Fault fault) throws Exception {
        if (!this._exceptions.contains(fault.getJavaException())) {
            this._exceptions.add(fault.getJavaException());
            this.addExceptionClassName(fault.getJavaException().getName());
            if (fault.getParentFault() != null) {
                this.preVisit(fault.getParentFault());
            }
            Iterator iter = fault.getSubfaults();
            while (iter != null && iter.hasNext()) {
                Fault subfault = (Fault)iter.next();
                this.preVisit(subfault);
            }
        }
    }

    private void addExceptionClassName(String name) {
        if (this._allClassNames.contains(name)) {
            this._exceptionClassNames.add(name);
        }
        this.registerClassName(name);
    }

    @Override
    protected void visitBodyBlock(Block block) throws Exception {
        this.visitBlock(block);
    }

    @Override
    protected void visitHeaderBlock(Block block) throws Exception {
        this.visitBlock(block);
    }

    @Override
    protected void visitFaultBlock(Block block) throws Exception {
    }

    protected void visitBlock(Block block) throws Exception {
        this.visitType(block.getType());
    }

    @Override
    protected void visit(Parameter parameter) throws Exception {
        this.visitType(parameter.getType());
    }

    private void visitType(AbstractType type) throws Exception {
        if (type != null) {
            if (type instanceof JAXBType) {
                this.visitType((JAXBType)type);
            } else if (type instanceof RpcLitStructure) {
                this.visitType((RpcLitStructure)type);
            }
        }
    }

    private void visitType(JAXBType type) throws Exception {
        type.accept(this);
    }

    private void visitType(RpcLitStructure type) throws Exception {
        type.accept(this);
    }

    private void registerClassName(String name) {
        if (name == null || name.equals("")) {
            return;
        }
        if (this._allClassNames.contains(name)) {
            this._conflictingClassNames.add(name);
        } else {
            this._allClassNames.add(name);
        }
    }

    public Set<String> getSeiClassNames() {
        return this._seiClassNames;
    }

    public Set<String> getJaxbGeneratedClassNames() {
        return this._jaxbGeneratedClassNames;
    }

    public Set<String> getExceptionClassNames() {
        return this._exceptionClassNames;
    }

    @Override
    public void visit(JAXBType type) throws Exception {
        if (!this.doneVisitingJAXBModel && type.getJaxbModel() != null) {
            Set<String> classNames = type.getJaxbModel().getGeneratedClassNames();
            for (String className : classNames) {
                this.addJAXBGeneratedClassName(className);
            }
            this.doneVisitingJAXBModel = true;
        }
    }

    @Override
    public void visit(RpcLitStructure type) throws Exception {
        if (!this.doneVisitingJAXBModel) {
            Set<String> classNames = type.getJaxbModel().getGeneratedClassNames();
            for (String className : classNames) {
                this.addJAXBGeneratedClassName(className);
            }
            this.doneVisitingJAXBModel = true;
        }
    }

    private void addJAXBGeneratedClassName(String name) {
        this._jaxbGeneratedClassNames.add(name);
        this.registerClassName(name);
    }
}

