/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 *
 * Contributor(s):
 *
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package com.sun.tools.ws.resources;

import com.sun.xml.ws.util.localization.Localizable;
import com.sun.xml.ws.util.localization.LocalizableMessageFactory;
import com.sun.xml.ws.util.localization.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class ConfigurationMessages {

    private final static LocalizableMessageFactory messageFactory = new LocalizableMessageFactory("com.sun.tools.ws.resources.configuration");
    private final static Localizer localizer = new Localizer();

    public static Localizable localizableCONFIGURATION_INVALID_ELEMENT(Object arg0, Object arg1, Object arg2) {
        return messageFactory.getMessage("configuration.invalidElement", arg0, arg1, arg2);
    }

    /**
     * invalid element "{2}" in file "{0}" (line {1})
     * 
     */
    public static String CONFIGURATION_INVALID_ELEMENT(Object arg0, Object arg1, Object arg2) {
        return localizer.localize(localizableCONFIGURATION_INVALID_ELEMENT(arg0, arg1, arg2));
    }

    public static Localizable localizableCONFIGURATION_NOT_BINDING_FILE(Object arg0) {
        return messageFactory.getMessage("configuration.notBindingFile", arg0);
    }

    /**
     * Ignoring: binding file ""{0}". It is not a jaxws or a jaxb binding file.
     * 
     */
    public static String CONFIGURATION_NOT_BINDING_FILE(Object arg0) {
        return localizer.localize(localizableCONFIGURATION_NOT_BINDING_FILE(arg0));
    }

}
