/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.processor.modeler.annotation;

import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.ConstructorDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.Modifier;
import com.sun.mirror.declaration.PackageDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.ClassType;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.type.ReferenceType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.type.VoidType;
import com.sun.mirror.util.DeclarationVisitor;
import com.sun.mirror.util.SimpleDeclarationVisitor;
import com.sun.mirror.util.SourcePosition;
import com.sun.tools.ws.processor.model.Port;
import com.sun.tools.ws.processor.modeler.JavaSimpleTypeCreator;
import com.sun.tools.ws.processor.modeler.annotation.AnnotationProcessorContext;
import com.sun.tools.ws.processor.modeler.annotation.ModelBuilder;
import com.sun.tools.ws.processor.modeler.annotation.WebServiceConstants;
import com.sun.tools.ws.resources.WebserviceapMessages;
import com.sun.tools.ws.util.ClassNameInfo;
import com.sun.tools.ws.wsdl.document.soap.SOAPStyle;
import com.sun.tools.ws.wsdl.document.soap.SOAPUse;
import com.sun.xml.ws.developer.Stateful;
import com.sun.xml.ws.model.RuntimeModeler;
import com.sun.xml.ws.util.localization.Localizable;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import javax.jws.HandlerChain;
import javax.jws.Oneway;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;

public abstract class WebServiceVisitor
extends SimpleDeclarationVisitor
implements WebServiceConstants {
    protected ModelBuilder builder;
    protected String wsdlNamespace;
    protected String typeNamespace;
    protected Stack<SOAPBinding> soapBindingStack;
    protected SOAPBinding typeDeclSOAPBinding;
    protected SOAPUse soapUse = SOAPUse.LITERAL;
    protected SOAPStyle soapStyle = SOAPStyle.DOCUMENT;
    protected boolean wrapped = true;
    protected HandlerChain hChain;
    protected Port port;
    protected String serviceImplName;
    protected String endpointInterfaceName;
    protected AnnotationProcessorContext context;
    protected AnnotationProcessorContext.SEIContext seiContext;
    protected boolean processingSEI = false;
    protected String serviceName;
    protected String packageName;
    protected String portName;
    protected boolean endpointReferencesInterface = false;
    protected boolean hasWebMethods = false;
    protected JavaSimpleTypeCreator simpleTypeCreator;
    protected TypeDeclaration typeDecl;
    protected Set<String> processedMethods;
    protected boolean pushedSOAPBinding = false;
    protected static final String ANNOTATION_ELEMENT_ERROR = "webserviceap.endpointinteface.plus.element";

    public WebServiceVisitor(ModelBuilder builder, AnnotationProcessorContext context) {
        this.builder = builder;
        this.context = context;
        this.simpleTypeCreator = new JavaSimpleTypeCreator();
        this.soapBindingStack = new Stack();
        this.processedMethods = new HashSet<String>();
    }

    public void visitInterfaceDeclaration(InterfaceDeclaration d) {
        WebService webService = (WebService)d.getAnnotation(WebService.class);
        if (!this.shouldProcessWebService(webService, d)) {
            return;
        }
        if (this.builder.checkAndSetProcessed((TypeDeclaration)d)) {
            return;
        }
        this.typeDecl = d;
        if (this.endpointInterfaceName != null && !this.endpointInterfaceName.equals(d.getQualifiedName())) {
            this.builder.onError(d.getPosition(), WebserviceapMessages.localizableWEBSERVICEAP_ENDPOINTINTERFACES_DO_NOT_MATCH(this.endpointInterfaceName, d.getQualifiedName()));
        }
        this.verifySEIAnnotations(webService, d);
        this.endpointInterfaceName = d.getQualifiedName();
        this.processingSEI = true;
        this.preProcessWebService(webService, (TypeDeclaration)d);
        this.processWebService(webService, (TypeDeclaration)d);
        this.postProcessWebService(webService, d);
    }

    public void visitClassDeclaration(ClassDeclaration d) {
        String endpointInterfaceName;
        WebService webService = (WebService)d.getAnnotation(WebService.class);
        if (!this.shouldProcessWebService(webService, d)) {
            return;
        }
        if (this.builder.checkAndSetProcessed((TypeDeclaration)d)) {
            return;
        }
        this.typeDeclSOAPBinding = (SOAPBinding)d.getAnnotation(SOAPBinding.class);
        this.typeDecl = d;
        if (this.serviceImplName == null) {
            this.serviceImplName = d.getQualifiedName();
        }
        String string = endpointInterfaceName = webService != null ? webService.endpointInterface() : null;
        if (endpointInterfaceName != null && endpointInterfaceName.length() > 0) {
            SourcePosition pos = d.getPosition();
            this.checkForInvalidImplAnnotation((Declaration)d, SOAPBinding.class);
            if (webService.name().length() > 0) {
                this.annotationError(pos, WebserviceapMessages.localizableWEBSERVICEAP_ENDPOINTINTEFACE_PLUS_ELEMENT("name"));
            }
            this.endpointReferencesInterface = true;
            this.verifyImplAnnotations(d);
            this.inspectEndpointInterface(endpointInterfaceName, d);
            this.serviceImplName = null;
            return;
        }
        this.processingSEI = false;
        this.preProcessWebService(webService, (TypeDeclaration)d);
        this.processWebService(webService, (TypeDeclaration)d);
        this.serviceImplName = null;
        this.postProcessWebService(webService, d);
        this.serviceImplName = null;
    }

    protected void verifySEIAnnotations(WebService webService, InterfaceDeclaration d) {
        if (webService.endpointInterface().length() > 0) {
            this.builder.onError(d.getPosition(), WebserviceapMessages.localizableWEBSERVICEAP_ENDPOINTINTERFACE_ON_INTERFACE(d.getQualifiedName(), webService.endpointInterface()));
        }
        if (webService.serviceName().length() > 0) {
            this.builder.onError(d.getPosition(), WebserviceapMessages.localizableWEBSERVICEAP_INVALID_SEI_ANNOTATION_ELEMENT("serviceName", d.getQualifiedName()));
        }
        if (webService.portName().length() > 0) {
            this.builder.onError(d.getPosition(), WebserviceapMessages.localizableWEBSERVICEAP_INVALID_SEI_ANNOTATION_ELEMENT("portName", d.getQualifiedName()));
        }
    }

    protected void verifyImplAnnotations(ClassDeclaration d) {
        for (MethodDeclaration method : d.getMethods()) {
            this.checkForInvalidImplAnnotation((Declaration)method, WebMethod.class);
            this.checkForInvalidImplAnnotation((Declaration)method, Oneway.class);
            this.checkForInvalidImplAnnotation((Declaration)method, WebResult.class);
            for (ParameterDeclaration param : method.getParameters()) {
                this.checkForInvalidImplAnnotation((Declaration)param, WebParam.class);
            }
        }
    }

    protected void checkForInvalidSEIAnnotation(InterfaceDeclaration d, Class annotationClass) {
        Annotation annotation = d.getAnnotation(annotationClass);
        if (annotation != null) {
            SourcePosition pos = d.getPosition();
            this.annotationError(pos, WebserviceapMessages.localizableWEBSERVICEAP_INVALID_SEI_ANNOTATION(annotationClass.getName(), d.getQualifiedName()));
        }
    }

    protected void checkForInvalidImplAnnotation(Declaration d, Class annotationClass) {
        Annotation annotation = d.getAnnotation(annotationClass);
        if (annotation != null) {
            SourcePosition pos = d.getPosition();
            this.annotationError(pos, WebserviceapMessages.localizableWEBSERVICEAP_ENDPOINTINTEFACE_PLUS_ANNOTATION(annotationClass.getName()));
        }
    }

    protected void annotationError(SourcePosition pos, Localizable message) {
        this.builder.onError(pos, message);
    }

    protected void preProcessWebService(WebService webService, TypeDeclaration d) {
        this.processedMethods = new HashSet<String>();
        this.seiContext = this.context.getSEIContext(d);
        String targetNamespace = null;
        if (webService != null) {
            targetNamespace = webService.targetNamespace();
        }
        if (targetNamespace == null || targetNamespace.length() == 0) {
            String packageName = d.getPackage().getQualifiedName();
            if (packageName == null || packageName.length() == 0) {
                this.builder.onError(d.getPosition(), WebserviceapMessages.localizableWEBSERVICEAP_NO_PACKAGE_CLASS_MUST_HAVE_TARGETNAMESPACE(d.getQualifiedName()));
            }
            targetNamespace = this.getNamespace(d.getPackage());
        }
        this.seiContext.setNamespaceURI(targetNamespace);
        if (this.serviceImplName == null) {
            this.serviceImplName = this.seiContext.getSEIImplName();
        }
        if (this.serviceImplName != null) {
            this.seiContext.setSEIImplName(this.serviceImplName);
            this.context.addSEIContext(this.serviceImplName, this.seiContext);
        }
        this.portName = ClassNameInfo.getName(d.getSimpleName().replace('$', '_'));
        this.packageName = d.getPackage().getQualifiedName();
        this.portName = webService != null && webService.name() != null && webService.name().length() > 0 ? webService.name() : this.portName;
        this.serviceName = ClassNameInfo.getName(d.getQualifiedName()) + "Service";
        this.serviceName = webService != null && webService.serviceName() != null && webService.serviceName().length() > 0 ? webService.serviceName() : this.serviceName;
        this.typeNamespace = this.wsdlNamespace = this.seiContext.getNamespaceURI();
        SOAPBinding soapBinding = (SOAPBinding)d.getAnnotation(SOAPBinding.class);
        if (soapBinding != null) {
            this.pushedSOAPBinding = this.pushSOAPBinding(soapBinding, (Declaration)d, d);
        } else if (d.equals(this.typeDecl)) {
            this.pushedSOAPBinding = this.pushSOAPBinding(new MySOAPBinding(), (Declaration)d, d);
        }
    }

    public static boolean sameStyle(SOAPBinding.Style style, SOAPStyle soapStyle) {
        if (style.equals((Object)SOAPBinding.Style.DOCUMENT) && soapStyle.equals(SOAPStyle.DOCUMENT)) {
            return true;
        }
        return style.equals((Object)SOAPBinding.Style.RPC) && soapStyle.equals(SOAPStyle.RPC);
    }

    protected boolean pushSOAPBinding(SOAPBinding soapBinding, Declaration bindingDecl, TypeDeclaration classDecl) {
        boolean changed = false;
        if (!WebServiceVisitor.sameStyle(soapBinding.style(), this.soapStyle)) {
            changed = true;
            if (this.pushedSOAPBinding) {
                this.builder.onError(bindingDecl.getPosition(), WebserviceapMessages.localizableWEBSERVICEAP_MIXED_BINDING_STYLE(classDecl.getQualifiedName()));
            }
        }
        if (soapBinding.style().equals((Object)SOAPBinding.Style.RPC)) {
            this.soapStyle = SOAPStyle.RPC;
            this.wrapped = true;
            if (soapBinding.parameterStyle().equals((Object)SOAPBinding.ParameterStyle.BARE)) {
                this.builder.onError(bindingDecl.getPosition(), WebserviceapMessages.localizableWEBSERVICEAP_RPC_LITERAL_MUST_NOT_BE_BARE(classDecl.getQualifiedName()));
            }
        } else {
            this.soapStyle = SOAPStyle.DOCUMENT;
            if (this.wrapped != soapBinding.parameterStyle().equals((Object)SOAPBinding.ParameterStyle.WRAPPED)) {
                this.wrapped = soapBinding.parameterStyle().equals((Object)SOAPBinding.ParameterStyle.WRAPPED);
                changed = true;
            }
        }
        if (soapBinding.use().equals((Object)SOAPBinding.Use.ENCODED)) {
            String style = "rpc";
            if (soapBinding.style().equals((Object)SOAPBinding.Style.DOCUMENT)) {
                style = "document";
            }
            this.builder.onError(bindingDecl.getPosition(), WebserviceapMessages.localizableWEBSERVICE_ENCODED_NOT_SUPPORTED(classDecl.getQualifiedName(), style));
        }
        if (changed || this.soapBindingStack.empty()) {
            this.soapBindingStack.push(soapBinding);
            this.pushedSOAPBinding = true;
        }
        return changed;
    }

    protected SOAPBinding popSOAPBinding() {
        if (this.pushedSOAPBinding) {
            this.soapBindingStack.pop();
        }
        SOAPBinding soapBinding = null;
        if (!this.soapBindingStack.empty()) {
            soapBinding = this.soapBindingStack.peek();
            if (soapBinding.style().equals((Object)SOAPBinding.Style.RPC)) {
                this.soapStyle = SOAPStyle.RPC;
                this.wrapped = true;
            } else {
                this.soapStyle = SOAPStyle.DOCUMENT;
                this.wrapped = soapBinding.parameterStyle().equals((Object)SOAPBinding.ParameterStyle.WRAPPED);
            }
        }
        return soapBinding;
    }

    protected String getNamespace(PackageDeclaration packageDecl) {
        return RuntimeModeler.getNamespace((String)packageDecl.getQualifiedName());
    }

    protected boolean shouldProcessWebService(WebService webService, InterfaceDeclaration intf) {
        this.hasWebMethods = false;
        if (webService == null) {
            this.builder.onError(intf.getPosition(), WebserviceapMessages.localizableWEBSERVICEAP_ENDPOINTINTERFACE_HAS_NO_WEBSERVICE_ANNOTATION(intf.getQualifiedName()));
        }
        return this.isLegalSEI(intf);
    }

    protected boolean shouldProcessWebService(WebService webService, ClassDeclaration classDecl) {
        if (webService == null) {
            return false;
        }
        this.hasWebMethods = this.hasWebMethods(classDecl);
        return this.isLegalImplementation(webService, classDecl);
    }

    protected abstract void processWebService(WebService var1, TypeDeclaration var2);

    protected void postProcessWebService(WebService webService, InterfaceDeclaration d) {
        this.processMethods(d);
        this.popSOAPBinding();
    }

    protected void postProcessWebService(WebService webService, ClassDeclaration d) {
        this.processMethods(d);
        this.popSOAPBinding();
    }

    protected boolean hasWebMethods(ClassDeclaration d) {
        if (d.getQualifiedName().equals("java.lang.Object")) {
            return false;
        }
        for (MethodDeclaration method : d.getMethods()) {
            WebMethod webMethod = (WebMethod)method.getAnnotation(WebMethod.class);
            if (webMethod == null) continue;
            if (webMethod.exclude()) {
                if (webMethod.operationName().length() > 0) {
                    this.builder.onError(method.getPosition(), WebserviceapMessages.localizableWEBSERVICEAP_INVALID_WEBMETHOD_ELEMENT_WITH_EXCLUDE("operationName", d.getQualifiedName(), method.toString()));
                }
                if (webMethod.action().length() <= 0) continue;
                this.builder.onError(method.getPosition(), WebserviceapMessages.localizableWEBSERVICEAP_INVALID_WEBMETHOD_ELEMENT_WITH_EXCLUDE("action", d.getQualifiedName(), method.toString()));
                continue;
            }
            return true;
        }
        return false;
    }

    protected void processMethods(InterfaceDeclaration d) {
        this.builder.log("ProcessedMethods Interface: " + d);
        this.hasWebMethods = false;
        for (MethodDeclaration methodDecl : d.getMethods()) {
            methodDecl.accept((DeclarationVisitor)this);
        }
        for (InterfaceType superType : d.getSuperinterfaces()) {
            this.processMethods(superType.getDeclaration());
        }
    }

    protected void processMethods(ClassDeclaration d) {
        this.builder.log("ProcessedMethods Class: " + d);
        this.hasWebMethods = this.hasWebMethods(d);
        if (d.getQualifiedName().equals("java.lang.Object")) {
            return;
        }
        if (d.getAnnotation(WebService.class) != null) {
            for (MethodDeclaration methodDecl : d.getMethods()) {
                methodDecl.accept((DeclarationVisitor)this);
            }
        }
        if (d.getSuperclass() != null) {
            this.processMethods(d.getSuperclass().getDeclaration());
        }
    }

    private InterfaceDeclaration getEndpointInterfaceDecl(String endpointInterfaceName, ClassDeclaration d) {
        InterfaceDeclaration intTypeDecl = null;
        for (InterfaceType interfaceType : d.getSuperinterfaces()) {
            if (!endpointInterfaceName.equals(interfaceType.toString())) continue;
            intTypeDecl = interfaceType.getDeclaration();
            this.seiContext = this.context.getSEIContext(intTypeDecl.getQualifiedName());
            assert (this.seiContext != null);
            this.seiContext.setImplementsSEI(true);
            break;
        }
        if (intTypeDecl == null) {
            intTypeDecl = (InterfaceDeclaration)this.builder.getTypeDeclaration(endpointInterfaceName);
        }
        if (intTypeDecl == null) {
            this.builder.onError(WebserviceapMessages.WEBSERVICEAP_ENDPOINTINTERFACE_CLASS_NOT_FOUND(endpointInterfaceName));
        }
        return intTypeDecl;
    }

    private void inspectEndpointInterface(String endpointInterfaceName, ClassDeclaration d) {
        InterfaceDeclaration intTypeDecl = this.getEndpointInterfaceDecl(endpointInterfaceName, d);
        if (intTypeDecl != null) {
            intTypeDecl.accept((DeclarationVisitor)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitMethodDeclaration(MethodDeclaration method) {
        if (!method.getModifiers().contains(Modifier.PUBLIC)) {
            return;
        }
        if (this.processedMethod(method)) {
            return;
        }
        WebMethod webMethod = (WebMethod)method.getAnnotation(WebMethod.class);
        if (webMethod != null && webMethod.exclude()) {
            return;
        }
        SOAPBinding soapBinding = (SOAPBinding)method.getAnnotation(SOAPBinding.class);
        if (soapBinding == null && !method.getDeclaringType().equals(this.typeDecl) && method.getDeclaringType() instanceof ClassDeclaration) {
            soapBinding = (SOAPBinding)method.getDeclaringType().getAnnotation(SOAPBinding.class);
            if (soapBinding != null) {
                this.builder.log("using " + method.getDeclaringType() + "'s SOAPBinding.");
            } else {
                soapBinding = new MySOAPBinding();
            }
        }
        boolean newBinding = false;
        if (soapBinding != null) {
            newBinding = this.pushSOAPBinding(soapBinding, (Declaration)method, this.typeDecl);
        }
        try {
            if (this.shouldProcessMethod(method, webMethod)) {
                this.processMethod(method, webMethod);
            }
        }
        finally {
            if (newBinding) {
                this.popSOAPBinding();
            }
        }
    }

    protected boolean processedMethod(MethodDeclaration method) {
        String id = method.toString();
        if (this.processedMethods.contains(id)) {
            return true;
        }
        this.processedMethods.add(id);
        return false;
    }

    protected boolean shouldProcessMethod(MethodDeclaration method, WebMethod webMethod) {
        this.builder.log("should process method: " + method.getSimpleName() + " hasWebMethods: " + this.hasWebMethods + " ");
        if (this.hasWebMethods && webMethod == null) {
            this.builder.log("webMethod == null");
            return false;
        }
        boolean retval = this.endpointReferencesInterface || method.getDeclaringType().equals(this.typeDecl) || method.getDeclaringType().getAnnotation(WebService.class) != null;
        this.builder.log("endpointReferencesInterface: " + this.endpointReferencesInterface);
        this.builder.log("declaring class has WebSevice: " + (method.getDeclaringType().getAnnotation(WebService.class) != null));
        this.builder.log("returning: " + retval);
        return retval;
    }

    protected abstract void processMethod(MethodDeclaration var1, WebMethod var2);

    protected boolean isLegalImplementation(WebService webService, ClassDeclaration classDecl) {
        InterfaceDeclaration intfDecl;
        boolean isStateful = this.isStateful(classDecl);
        Collection modifiers = classDecl.getModifiers();
        if (!modifiers.contains(Modifier.PUBLIC)) {
            this.builder.onError(classDecl.getPosition(), WebserviceapMessages.localizableWEBSERVICEAP_WEBSERVICE_CLASS_NOT_PUBLIC(classDecl.getQualifiedName()));
            return false;
        }
        if (modifiers.contains(Modifier.FINAL) && !isStateful) {
            this.builder.onError(classDecl.getPosition(), WebserviceapMessages.localizableWEBSERVICEAP_WEBSERVICE_CLASS_IS_FINAL(classDecl.getQualifiedName()));
            return false;
        }
        if (modifiers.contains(Modifier.ABSTRACT) && !isStateful) {
            this.builder.onError(classDecl.getPosition(), WebserviceapMessages.localizableWEBSERVICEAP_WEBSERVICE_CLASS_IS_ABSTRACT(classDecl.getQualifiedName()));
            return false;
        }
        if (classDecl.getDeclaringType() != null && !modifiers.contains(Modifier.STATIC) && !isStateful) {
            this.builder.onError(classDecl.getPosition(), WebserviceapMessages.localizableWEBSERVICEAP_WEBSERVICE_CLASS_IS_INNERCLASS_NOT_STATIC(classDecl.getQualifiedName()));
            return false;
        }
        boolean hasDefaultConstructor = false;
        for (ConstructorDeclaration constructor : classDecl.getConstructors()) {
            if (!constructor.getModifiers().contains(Modifier.PUBLIC) || constructor.getParameters().size() != 0) continue;
            hasDefaultConstructor = true;
            break;
        }
        if (!hasDefaultConstructor && !isStateful) {
            this.builder.onError(classDecl.getPosition(), WebserviceapMessages.localizableWEBSERVICEAP_WEBSERVICE_NO_DEFAULT_CONSTRUCTOR(classDecl.getQualifiedName()));
            return false;
        }
        return !(webService.endpointInterface().length() == 0 ? !this.methodsAreLegal(classDecl) : !this.classImplementsSEI(classDecl, intfDecl = this.getEndpointInterfaceDecl(webService.endpointInterface(), classDecl)));
    }

    private boolean isStateful(ClassDeclaration classDecl) {
        return classDecl.getAnnotation(Stateful.class) != null;
    }

    protected boolean classImplementsSEI(ClassDeclaration classDecl, InterfaceDeclaration intfDecl) {
        for (InterfaceType interfaceType : classDecl.getSuperinterfaces()) {
            if (!interfaceType.getDeclaration().equals(intfDecl)) continue;
            return true;
        }
        for (MethodDeclaration method : intfDecl.getMethods()) {
            boolean implementsMethod = false;
            for (MethodDeclaration classMethod : classDecl.getMethods()) {
                if (!this.sameMethod(method, classMethod)) continue;
                implementsMethod = true;
                break;
            }
            if (implementsMethod) continue;
            this.builder.onError(method.getPosition(), WebserviceapMessages.localizableWEBSERVICEAP_METHOD_NOT_IMPLEMENTED(intfDecl.getSimpleName(), classDecl.getSimpleName(), method));
            return false;
        }
        return true;
    }

    protected boolean sameMethod(MethodDeclaration method1, MethodDeclaration method2) {
        ParameterDeclaration[] params2;
        if (!method1.getSimpleName().equals(method2.getSimpleName())) {
            return false;
        }
        if (!method1.getReturnType().equals(method2.getReturnType())) {
            return false;
        }
        ParameterDeclaration[] params1 = method1.getParameters().toArray(new ParameterDeclaration[0]);
        if (params1.length != (params2 = method2.getParameters().toArray(new ParameterDeclaration[0])).length) {
            return false;
        }
        int pos = 0;
        for (ParameterDeclaration param1 : method1.getParameters()) {
            if (param1.getType().equals(params2[pos++].getType())) continue;
            return false;
        }
        return true;
    }

    protected boolean isLegalSEI(InterfaceDeclaration intf) {
        for (FieldDeclaration field : intf.getFields()) {
            if (field.getConstantValue() == null) continue;
            this.builder.onError(WebserviceapMessages.WEBSERVICEAP_SEI_CANNOT_CONTAIN_CONSTANT_VALUES(intf.getQualifiedName(), field.getSimpleName()));
            return false;
        }
        return this.methodsAreLegal(intf);
    }

    protected boolean methodsAreLegal(InterfaceDeclaration intfDecl) {
        this.hasWebMethods = false;
        for (MethodDeclaration method : intfDecl.getMethods()) {
            if (this.isLegalMethod(method, (TypeDeclaration)intfDecl)) continue;
            return false;
        }
        for (InterfaceType superIntf : intfDecl.getSuperinterfaces()) {
            if (this.methodsAreLegal(superIntf.getDeclaration())) continue;
            return false;
        }
        return true;
    }

    protected boolean methodsAreLegal(ClassDeclaration classDecl) {
        this.hasWebMethods = this.hasWebMethods(classDecl);
        for (MethodDeclaration method : classDecl.getMethods()) {
            if (this.isLegalMethod(method, (TypeDeclaration)classDecl)) continue;
            return false;
        }
        ClassType superClass = classDecl.getSuperclass();
        return superClass == null || this.methodsAreLegal(superClass.getDeclaration());
    }

    protected boolean isLegalMethod(MethodDeclaration method, TypeDeclaration typeDecl) {
        boolean isOneway;
        WebMethod webMethod = (WebMethod)method.getAnnotation(WebMethod.class);
        if (this.hasWebMethods && webMethod == null) {
            return true;
        }
        if (!this.hasWebMethods && webMethod != null && webMethod.exclude()) {
            return true;
        }
        if (typeDecl instanceof ClassDeclaration && method.getModifiers().contains(Modifier.ABSTRACT)) {
            this.builder.onError(method.getPosition(), WebserviceapMessages.localizableWEBSERVICEAP_WEBSERVICE_METHOD_IS_ABSTRACT(typeDecl.getQualifiedName(), method.getSimpleName()));
            return false;
        }
        if (!this.isLegalType(method.getReturnType())) {
            this.builder.onError(method.getPosition(), WebserviceapMessages.localizableWEBSERVICEAP_METHOD_RETURN_TYPE_CANNOT_IMPLEMENT_REMOTE(typeDecl.getQualifiedName(), method.getSimpleName(), method.getReturnType()));
        }
        boolean bl = isOneway = method.getAnnotation(Oneway.class) != null;
        if (isOneway && !this.isValidOnewayMethod(method, typeDecl)) {
            return false;
        }
        SOAPBinding soapBinding = (SOAPBinding)method.getAnnotation(SOAPBinding.class);
        if (soapBinding != null && soapBinding.style().equals((Object)SOAPBinding.Style.RPC)) {
            this.builder.onError(method.getPosition(), WebserviceapMessages.localizableWEBSERVICEAP_RPC_SOAPBINDING_NOT_ALLOWED_ON_METHOD(typeDecl.getQualifiedName(), method.toString()));
        }
        int paramIndex = 0;
        for (ParameterDeclaration parameter : method.getParameters()) {
            if (this.isLegalParameter(parameter, method, typeDecl, paramIndex++)) continue;
            return false;
        }
        if (!this.isDocLitWrapped() && this.soapStyle.equals(SOAPStyle.DOCUMENT)) {
            ParameterDeclaration outParam = this.getOutParameter(method);
            int inParams = this.getModeParameterCount(method, WebParam.Mode.IN);
            int outParams = this.getModeParameterCount(method, WebParam.Mode.OUT);
            if (inParams != 1) {
                this.builder.onError(method.getPosition(), WebserviceapMessages.localizableWEBSERVICEAP_DOC_BARE_AND_NO_ONE_IN(typeDecl.getQualifiedName(), method.toString()));
            }
            if (method.getReturnType() instanceof VoidType) {
                if (outParam == null && !isOneway) {
                    this.builder.onError(method.getPosition(), WebserviceapMessages.localizableWEBSERVICEAP_DOC_BARE_NO_OUT(typeDecl.getQualifiedName(), method.toString()));
                }
                if (outParams != 1 && !isOneway && outParams != 0) {
                    this.builder.onError(method.getPosition(), WebserviceapMessages.localizableWEBSERVICEAP_DOC_BARE_NO_RETURN_AND_NO_OUT(typeDecl.getQualifiedName(), method.toString()));
                }
            } else if (outParams > 0) {
                this.builder.onError(outParam.getPosition(), WebserviceapMessages.localizableWEBSERVICEAP_DOC_BARE_RETURN_AND_OUT(typeDecl.getQualifiedName(), method.toString()));
            }
        }
        return true;
    }

    protected boolean isLegalParameter(ParameterDeclaration param, MethodDeclaration method, TypeDeclaration typeDecl, int paramIndex) {
        if (!this.isLegalType(param.getType())) {
            this.builder.onError(param.getPosition(), WebserviceapMessages.localizableWEBSERVICEAP_METHOD_PARAMETER_TYPES_CANNOT_IMPLEMENT_REMOTE(typeDecl.getQualifiedName(), method.getSimpleName(), param.getSimpleName(), param.getType().toString()));
            return false;
        }
        TypeMirror holderType = this.builder.getHolderValueType(param.getType());
        WebParam webParam = (WebParam)param.getAnnotation(WebParam.class);
        WebParam.Mode mode = null;
        if (webParam != null) {
            mode = webParam.mode();
        }
        if (holderType != null) {
            if (mode != null && mode == WebParam.Mode.IN) {
                this.builder.onError(param.getPosition(), WebserviceapMessages.localizableWEBSERVICEAP_HOLDER_PARAMETERS_MUST_NOT_BE_IN_ONLY(typeDecl.getQualifiedName(), method.toString(), paramIndex));
            }
        } else if (mode != null && mode != WebParam.Mode.IN) {
            this.builder.onError(param.getPosition(), WebserviceapMessages.localizableWEBSERVICEAP_NON_IN_PARAMETERS_MUST_BE_HOLDER(typeDecl.getQualifiedName(), method.toString(), paramIndex));
        }
        return true;
    }

    protected boolean isDocLitWrapped() {
        return this.soapStyle.equals(SOAPStyle.DOCUMENT) && this.wrapped;
    }

    protected boolean isValidOnewayMethod(MethodDeclaration method, TypeDeclaration typeDecl) {
        int inCnt;
        ParameterDeclaration outParam;
        boolean valid = true;
        if (!(method.getReturnType() instanceof VoidType)) {
            this.builder.onError(method.getPosition(), WebserviceapMessages.localizableWEBSERVICEAP_ONEWAY_OPERATION_CANNOT_HAVE_RETURN_TYPE(typeDecl.getQualifiedName(), method.toString()));
            valid = false;
        }
        if ((outParam = this.getOutParameter(method)) != null) {
            this.builder.onError(outParam.getPosition(), WebserviceapMessages.localizableWEBSERVICEAP_ONEWAY_AND_OUT(typeDecl.getQualifiedName(), method.toString()));
            valid = false;
        }
        if (!this.isDocLitWrapped() && this.soapStyle.equals(SOAPStyle.DOCUMENT) && (inCnt = this.getModeParameterCount(method, WebParam.Mode.IN)) != 1) {
            this.builder.onError(method.getPosition(), WebserviceapMessages.localizableWEBSERVICEAP_ONEWAY_AND_NOT_ONE_IN(typeDecl.getQualifiedName(), method.toString()));
            valid = false;
        }
        for (ReferenceType thrownType : method.getThrownTypes()) {
            ClassDeclaration exDecl = ((ClassType)thrownType).getDeclaration();
            if (this.builder.isRemoteException((TypeDeclaration)exDecl)) continue;
            this.builder.onError(method.getPosition(), WebserviceapMessages.localizableWEBSERVICEAP_ONEWAY_OPERATION_CANNOT_DECLARE_EXCEPTIONS(typeDecl.getQualifiedName(), method.toString(), exDecl.getQualifiedName()));
            valid = false;
        }
        return valid;
    }

    protected int getModeParameterCount(MethodDeclaration method, WebParam.Mode mode) {
        int cnt = 0;
        for (ParameterDeclaration param : method.getParameters()) {
            WebParam webParam = (WebParam)param.getAnnotation(WebParam.class);
            if (webParam != null) {
                if (webParam.header() || !this.isEquivalentModes(mode, webParam.mode())) continue;
                ++cnt;
                continue;
            }
            if (!this.isEquivalentModes(mode, WebParam.Mode.IN)) continue;
            ++cnt;
        }
        return cnt;
    }

    protected boolean isEquivalentModes(WebParam.Mode mode1, WebParam.Mode mode2) {
        if (mode1.equals((Object)mode2)) {
            return true;
        }
        assert (mode1 == WebParam.Mode.IN || mode1 == WebParam.Mode.OUT);
        if (mode1 == WebParam.Mode.IN && mode2 != WebParam.Mode.OUT) {
            return true;
        }
        return mode1 == WebParam.Mode.OUT && mode2 != WebParam.Mode.IN;
    }

    protected boolean isHolder(ParameterDeclaration param) {
        return this.builder.getHolderValueType(param.getType()) != null;
    }

    protected boolean isLegalType(TypeMirror type) {
        if (!(type instanceof DeclaredType)) {
            return true;
        }
        return !this.builder.isRemote(((DeclaredType)type).getDeclaration());
    }

    protected ParameterDeclaration getOutParameter(MethodDeclaration method) {
        for (ParameterDeclaration param : method.getParameters()) {
            WebParam webParam = (WebParam)param.getAnnotation(WebParam.class);
            if (webParam == null || webParam.mode() == WebParam.Mode.IN) continue;
            return param;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MySOAPBinding
    implements SOAPBinding {
        protected MySOAPBinding() {
        }

        public SOAPBinding.Style style() {
            return SOAPBinding.Style.DOCUMENT;
        }

        public SOAPBinding.Use use() {
            return SOAPBinding.Use.LITERAL;
        }

        public SOAPBinding.ParameterStyle parameterStyle() {
            return SOAPBinding.ParameterStyle.WRAPPED;
        }

        public Class<? extends Annotation> annotationType() {
            return SOAPBinding.class;
        }
    }
}

