/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.wscompile;

import com.sun.istack.NotNull;
import com.sun.tools.ws.resources.WscompileMessages;
import com.sun.tools.ws.wscompile.AuthInfo;
import com.sun.tools.ws.wscompile.BadCommandLineException;
import com.sun.tools.ws.wscompile.ErrorReceiver;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;

public class DefaultAuthenticator
extends Authenticator {
    private final List<AuthInfo> authInfo = new ArrayList<AuthInfo>();
    private final ErrorReceiver errReceiver;
    private final String proxyUser;
    private final String proxyPasswd;
    public static final String defaultAuthfile = System.getProperty("user.home") + System.getProperty("file.separator") + ".metro" + System.getProperty("file.separator") + "auth";
    private File authFile = new File(defaultAuthfile);
    private boolean giveError;

    public DefaultAuthenticator(@NotNull ErrorReceiver receiver, @NotNull File authfile) throws BadCommandLineException {
        this.errReceiver = receiver;
        this.proxyUser = System.getProperty("http.proxyUser");
        this.proxyPasswd = System.getProperty("http.proxyPassword");
        if (authfile != null) {
            this.authFile = authfile;
            this.giveError = true;
        }
        if (!this.authFile.exists()) {
            try {
                this.error(new SAXParseException(WscompileMessages.WSIMPORT_AUTH_FILE_NOT_FOUND(this.authFile.getCanonicalPath(), defaultAuthfile), null));
            }
            catch (IOException e) {
                this.error(new SAXParseException(WscompileMessages.WSIMPORT_FAILED_TO_PARSE(this.authFile, e.getMessage()), null));
            }
            return;
        }
        if (!this.authFile.canRead()) {
            this.error(new SAXParseException("Authorization file: " + this.authFile + " does not have read permission!", null));
            return;
        }
        this.parseAuth();
    }

    protected PasswordAuthentication getPasswordAuthentication() {
        if (this.getRequestorType() == Authenticator.RequestorType.PROXY && this.proxyUser != null && this.proxyPasswd != null) {
            return new PasswordAuthentication(this.proxyUser, this.proxyPasswd.toCharArray());
        }
        for (AuthInfo auth : this.authInfo) {
            if (!auth.matchingHost(this.getRequestingURL())) continue;
            return new PasswordAuthentication(auth.getUser(), auth.getPassword().toCharArray());
        }
        return null;
    }

    private void parseAuth() {
        BufferedReader in;
        this.errReceiver.info(new SAXParseException(WscompileMessages.WSIMPORT_READING_AUTH_FILE(this.authFile), null));
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.authFile), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            this.error(new SAXParseException(e.getMessage(), null));
            return;
        }
        catch (FileNotFoundException e) {
            this.error(new SAXParseException(WscompileMessages.WSIMPORT_AUTH_FILE_NOT_FOUND(this.authFile, defaultAuthfile), null, e));
            return;
        }
        LocatorImpl locator = new LocatorImpl();
        try {
            String text;
            int lineno = 1;
            locator.setSystemId(this.authFile.getCanonicalPath());
            while ((text = in.readLine()) != null) {
                locator.setLineNumber(lineno++);
                try {
                    URL url = new URL(text);
                    String authinfo = url.getUserInfo();
                    if (authinfo != null) {
                        int i = authinfo.indexOf(58);
                        if (i >= 0) {
                            String user = authinfo.substring(0, i);
                            String password = authinfo.substring(i + 1);
                            this.authInfo.add(new AuthInfo(new URL(text), user, password));
                            continue;
                        }
                        this.error(new SAXParseException(WscompileMessages.WSIMPORT_ILLEGAL_AUTH_INFO(url), locator));
                        continue;
                    }
                    this.error(new SAXParseException(WscompileMessages.WSIMPORT_ILLEGAL_AUTH_INFO(url), locator));
                }
                catch (NumberFormatException e) {
                    this.error(new SAXParseException(WscompileMessages.WSIMPORT_ILLEGAL_AUTH_INFO(text), locator));
                }
            }
            in.close();
        }
        catch (IOException e) {
            this.error(new SAXParseException(WscompileMessages.WSIMPORT_FAILED_TO_PARSE(this.authFile, e.getMessage()), locator));
        }
    }

    private void error(SAXParseException e) {
        if (this.giveError) {
            this.errReceiver.error(e);
        } else {
            this.errReceiver.debug(e);
        }
    }
}

