/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.wscompile;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.writer.ProgressCodeWriter;
import com.sun.tools.ws.ToolVersion;
import com.sun.tools.ws.api.TJavaGeneratorExtension;
import com.sun.tools.ws.processor.generator.CustomExceptionGenerator;
import com.sun.tools.ws.processor.generator.SeiGenerator;
import com.sun.tools.ws.processor.generator.ServiceGenerator;
import com.sun.tools.ws.processor.model.Model;
import com.sun.tools.ws.processor.modeler.wsdl.ConsoleErrorReporter;
import com.sun.tools.ws.processor.modeler.wsdl.WSDLModeler;
import com.sun.tools.ws.resources.WscompileMessages;
import com.sun.tools.ws.resources.WsdlMessages;
import com.sun.tools.ws.wscompile.AbortException;
import com.sun.tools.ws.wscompile.BadCommandLineException;
import com.sun.tools.ws.wscompile.ErrorReceiver;
import com.sun.tools.ws.wscompile.ErrorReceiverFilter;
import com.sun.tools.ws.wscompile.JavaCompilerHelper;
import com.sun.tools.ws.wscompile.Options;
import com.sun.tools.ws.wscompile.WSCodeWriter;
import com.sun.tools.ws.wscompile.WsimportListener;
import com.sun.tools.ws.wscompile.WsimportOptions;
import com.sun.tools.xjc.util.NullStream;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.util.ServiceFinder;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.ws.EndpointReference;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXParseException;

public class WsimportTool {
    private static final String WSIMPORT = "wsimport";
    private final PrintStream out;
    private final Container container;
    private final WsimportOptions options = new WsimportOptions();

    public WsimportTool(OutputStream out) {
        this(out, null);
    }

    public WsimportTool(OutputStream logStream, Container container) {
        this.out = logStream instanceof PrintStream ? (PrintStream)logStream : new PrintStream(logStream);
        this.container = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean run(String[] args) {
        class Listener
        extends WsimportListener {
            ConsoleErrorReporter cer;

            Listener() {
                this.cer = new ConsoleErrorReporter(WsimportTool.this.out == null ? new PrintStream((OutputStream)new NullStream()) : WsimportTool.this.out);
            }

            public void generatedFile(String fileName) {
                this.message(fileName);
            }

            public void message(String msg) {
                WsimportTool.this.out.println(msg);
            }

            public void error(SAXParseException exception) {
                this.cer.error(exception);
            }

            public void fatalError(SAXParseException exception) {
                this.cer.fatalError(exception);
            }

            public void warning(SAXParseException exception) {
                this.cer.warning(exception);
            }

            public void info(SAXParseException exception) {
                this.cer.info(exception);
            }

            public void enableDebugging() {
                this.cer.enableDebugging();
            }
        }
        final Listener listener = new Listener();
        ErrorReceiverFilter receiver = new ErrorReceiverFilter(listener){
            {
                super(x0);
            }

            public void info(SAXParseException exception) {
                if (((WsimportTool)WsimportTool.this).options.verbose) {
                    super.info(exception);
                }
            }

            public void warning(SAXParseException exception) {
                if (!((WsimportTool)WsimportTool.this).options.quiet) {
                    super.warning(exception);
                }
            }

            public void pollAbort() throws AbortException {
                if (listener.isCanceled()) {
                    throw new AbortException();
                }
            }
        };
        for (String arg : args) {
            if (!arg.equals("-version")) continue;
            listener.message(ToolVersion.VERSION.BUILD_VERSION);
            return true;
        }
        try {
            Model wsdlModel;
            block20: {
                WSDLModeler wsdlModeler;
                this.options.parseArguments(args);
                this.options.validate();
                if (this.options.debugMode) {
                    listener.enableDebugging();
                }
                this.options.parseBindings(receiver);
                if (!this.options.quiet) {
                    listener.message(WscompileMessages.WSIMPORT_PARSING_WSDL());
                }
                if ((wsdlModel = (wsdlModeler = new WSDLModeler(this.options, receiver)).buildModel()) != null) break block20;
                listener.message(WsdlMessages.PARSING_PARSE_FAILED());
                int i$ = 0;
                return i$ != 0;
            }
            try {
                if (!this.options.quiet) {
                    listener.message(WscompileMessages.WSIMPORT_GENERATING_CODE());
                }
                TJavaGeneratorExtension[] genExtn = (TJavaGeneratorExtension[])ServiceFinder.find(TJavaGeneratorExtension.class).toArray();
                CustomExceptionGenerator.generate(wsdlModel, this.options, receiver);
                SeiGenerator.generate(wsdlModel, this.options, receiver, genExtn);
                ServiceGenerator.generate(wsdlModel, this.options, receiver);
                WSCodeWriter cw = new WSCodeWriter(this.options.sourceDir, this.options);
                if (this.options.verbose) {
                    cw = new ProgressCodeWriter((CodeWriter)cw, System.out);
                }
                this.options.getCodeModel().build((CodeWriter)cw);
            }
            catch (AbortException e) {
            }
            catch (IOException e) {
                receiver.error(e);
            }
            if (!this.options.nocompile && !this.compileGeneratedClasses(receiver, listener)) {
                listener.message(WscompileMessages.WSCOMPILE_COMPILATION_FAILED());
                boolean e = false;
                return e;
            }
        }
        catch (Options.WeAreDone done) {
            this.usage(done.getOptions());
        }
        catch (BadCommandLineException e) {
            if (e.getMessage() != null) {
                System.out.println(e.getMessage());
                System.out.println();
            }
            this.usage(e.getOptions());
            boolean bl = false;
            return bl;
        }
        finally {
            if (!this.options.keep) {
                this.options.removeGeneratedFiles();
            }
        }
        return true;
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.options.entityResolver = resolver;
    }

    protected boolean compileGeneratedClasses(ErrorReceiver receiver, WsimportListener listener) {
        ArrayList<String> sourceFiles = new ArrayList<String>();
        for (File f : this.options.getGeneratedFiles()) {
            if (!f.exists() || !f.getName().endsWith(".java")) continue;
            sourceFiles.add(f.getAbsolutePath());
        }
        if (sourceFiles.size() > 0) {
            String classDir = this.options.destDir.getAbsolutePath();
            String classpathString = this.createClasspathString();
            String[] args = new String[5 + (this.options.debug ? 1 : 0) + sourceFiles.size()];
            args[0] = "-d";
            args[1] = classDir;
            args[2] = "-classpath";
            args[3] = classpathString;
            args[4] = "-Xbootclasspath/p:" + JavaCompilerHelper.getJarFile(EndpointReference.class) + File.pathSeparator + JavaCompilerHelper.getJarFile(XmlSeeAlso.class);
            int baseIndex = 5;
            if (this.options.debug) {
                args[baseIndex++] = "-g";
            }
            for (int i = 0; i < sourceFiles.size(); ++i) {
                args[baseIndex + i] = (String)sourceFiles.get(i);
            }
            listener.message(WscompileMessages.WSIMPORT_COMPILING_CODE());
            if (this.options.verbose) {
                StringBuffer argstr = new StringBuffer();
                for (String arg : args) {
                    argstr.append(arg).append(" ");
                }
                listener.message("javac " + argstr.toString());
            }
            return JavaCompilerHelper.compile(args, this.out, receiver);
        }
        return true;
    }

    private String createClasspathString() {
        return System.getProperty("java.class.path");
    }

    protected void usage(Options options) {
        System.out.println(WscompileMessages.WSIMPORT_HELP(WSIMPORT));
        System.out.println(WscompileMessages.WSIMPORT_USAGE_EXAMPLES());
    }
}

