/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the "License").  You may not use this file except
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at
 * https://jwsdp.dev.java.net/CDDLv1.0.html
 * See the License for the specific language governing
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL
 * HEADER in each file and include the License file at
 * https://jwsdp.dev.java.net/CDDLv1.0.html  If applicable,
 * add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your
 * own identifying information: Portions Copyright [yyyy]
 * [name of copyright owner]
 */

package com.sun.tools.ws.wscompile;

import com.sun.tools.xjc.api.ErrorListener;
import org.xml.sax.SAXParseException;

/**
 * @author Vivek Pandey
 */
public class WsimportListener implements ErrorListener {
    /**
     * Called for each file generated by wsimport or wsgen.
     *
     * <p>
     * The file name includes the path portions that correspond with the package name.
     *
     * <p>
     * When generating files into a directory, file names will be relative to the
     * output directory.
     *
     * @param fileName
     *      file names like "org/acme/foo/Foo.java"
     *
     */
    public void generatedFile(String fileName) {}

    /**
     * Other miscellenous messages that do not have structures
     * will be reported through this method.
     *
     * This method is used like {@link java.io.PrintStream#println(String)}.
     * The callee is expected to add '\n'.
     */
    public void message(String msg) {}
    
    public void error(SAXParseException exception) {

    }

    public void fatalError(SAXParseException exception) {

    }

    public void warning(SAXParseException exception) {

    }

    public void info(SAXParseException exception) {

    }

    /**
     * wsimport will periodically invoke this method to see if it should cancel a compilation.
     * 
     * @return
     *      true if the {@link com.sun.tools.ws.wscompile.WsimportListener} wants to abort the processing.
     * @since 2.1
     */
    public boolean isCanceled() {
        return false;
    }

}
