/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.wsdl.writer;

import com.sun.istack.NotNull;
import com.sun.xml.txw2.TypedXmlWriter;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.model.CheckedException;
import com.sun.xml.ws.api.model.JavaMethod;
import com.sun.xml.ws.api.model.SEIModel;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.api.wsdl.writer.WSDLGeneratorExtension;
import com.sun.xml.ws.wsdl.writer.UsingAddressing;
import javax.xml.ws.Action;
import javax.xml.ws.FaultAction;
import javax.xml.ws.soap.AddressingFeature;

public class W3CAddressingWSDLGeneratorExtension
extends WSDLGeneratorExtension {
    private boolean enabled;
    private boolean required = false;

    public void start(@NotNull TypedXmlWriter root, @NotNull SEIModel model, @NotNull WSBinding binding, @NotNull Container container) {
        this.enabled = binding.isFeatureEnabled("http://www.w3.org/2005/08/addressing/module");
        if (!this.enabled) {
            return;
        }
        AddressingFeature ftr = (AddressingFeature)binding.getFeature("http://www.w3.org/2005/08/addressing/module");
        this.required = ftr.isRequired();
        root._namespace(AddressingVersion.W3C.wsdlNsUri, AddressingVersion.W3C.getWsdlPrefix());
    }

    public void addOperationInputExtension(TypedXmlWriter input, JavaMethod method) {
        if (!this.enabled) {
            return;
        }
        Action a = method.getSEIMethod().getAnnotation(Action.class);
        if (a != null && !a.input().equals("")) {
            this.addAttribute(input, a.input());
        }
    }

    public void addOperationOutputExtension(TypedXmlWriter output, JavaMethod method) {
        if (!this.enabled) {
            return;
        }
        Action a = method.getSEIMethod().getAnnotation(Action.class);
        if (a != null && !a.output().equals("")) {
            this.addAttribute(output, a.output());
        }
    }

    public void addOperationFaultExtension(TypedXmlWriter fault, JavaMethod method, CheckedException ce) {
        if (!this.enabled) {
            return;
        }
        Action a = method.getSEIMethod().getAnnotation(Action.class);
        Class<?>[] exs = method.getSEIMethod().getExceptionTypes();
        if (exs == null) {
            return;
        }
        if (a != null && a.fault() != null) {
            for (FaultAction fa : a.fault()) {
                if (!fa.className().getName().equals(ce.getExceptionClass().getName())) continue;
                if (fa.value().equals("")) {
                    return;
                }
                this.addAttribute(fault, fa.value());
                return;
            }
        }
    }

    private void addAttribute(TypedXmlWriter writer, String attrValue) {
        writer._attribute(AddressingVersion.W3C.wsdlActionTag, (Object)attrValue);
    }

    public void addBindingExtension(TypedXmlWriter binding) {
        if (!this.enabled) {
            return;
        }
        UsingAddressing ua = (UsingAddressing)binding._element(AddressingVersion.W3C.wsdlExtensionTag, UsingAddressing.class);
        if (this.required) {
            ua.required(true);
        }
    }
}

