/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.server;

import com.sun.xml.ws.api.server.DocumentAddressResolver;
import com.sun.xml.ws.api.server.PortAddressResolver;
import com.sun.xml.ws.api.server.SDDocument;
import com.sun.xml.ws.api.server.SDDocumentFilter;
import com.sun.xml.ws.api.server.SDDocumentSource;
import com.sun.xml.ws.server.ServerRtException;
import com.sun.xml.ws.server.ServiceDefinitionImpl;
import com.sun.xml.ws.server.WSDLPatcher;
import com.sun.xml.ws.streaming.XMLStreamReaderUtil;
import com.sun.xml.ws.wsdl.parser.ParserUtil;
import com.sun.xml.ws.wsdl.parser.WSDLConstants;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

class SDDocumentImpl
extends SDDocumentSource
implements SDDocument {
    private final QName rootName;
    private final SDDocumentSource source;
    ServiceDefinitionImpl owner;
    private final URL url;
    private static final XMLInputFactory xif = XMLInputFactory.newInstance();
    private static final XMLOutputFactory xof = XMLOutputFactory.newInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SDDocumentImpl create(SDDocumentSource src, QName serviceName, QName portTypeName) {
        URL systemId = src.getSystemId();
        try {
            boolean hasService;
            boolean hasPortType;
            String tns;
            QName rootName;
            XMLStreamReader reader;
            block16: {
                reader = src.read(xif);
                XMLStreamReaderUtil.nextElementContent(reader);
                rootName = reader.getName();
                if (rootName.equals(WSDLConstants.QNAME_SCHEMA)) {
                    String tns2 = ParserUtil.getMandatoryNonEmptyAttribute(reader, "targetNamespace");
                    SchemaImpl schemaImpl = new SchemaImpl(rootName, systemId, src, tns2);
                    return schemaImpl;
                }
                if (rootName.equals(WSDLConstants.QNAME_DEFINITIONS)) {
                    tns = ParserUtil.getMandatoryNonEmptyAttribute(reader, "targetNamespace");
                    hasPortType = false;
                    hasService = false;
                    break block16;
                } else {
                    SDDocumentImpl sDDocumentImpl = new SDDocumentImpl(rootName, systemId, src);
                    return sDDocumentImpl;
                }
                finally {
                    reader.close();
                }
            }
            while (XMLStreamReaderUtil.nextElementContent(reader) != 2 && reader.getEventType() != 8) {
                QName name = reader.getName();
                if (WSDLConstants.QNAME_PORT_TYPE.equals(name)) {
                    String pn = ParserUtil.getMandatoryNonEmptyAttribute(reader, "name");
                    if (portTypeName != null && portTypeName.getLocalPart().equals(pn) && portTypeName.getNamespaceURI().equals(tns)) {
                        hasPortType = true;
                    }
                    XMLStreamReaderUtil.skipElement(reader);
                    continue;
                }
                if (WSDLConstants.QNAME_SERVICE.equals(name)) {
                    String sn = ParserUtil.getMandatoryNonEmptyAttribute(reader, "name");
                    QName sqn = new QName(tns, sn);
                    if (serviceName.equals(sqn)) {
                        hasService = true;
                    }
                    XMLStreamReaderUtil.skipElement(reader);
                    continue;
                }
                XMLStreamReaderUtil.skipElement(reader);
            }
            WSDLImpl wSDLImpl = new WSDLImpl(rootName, systemId, src, tns, hasPortType, hasService);
            return wSDLImpl;
        }
        catch (IOException e) {
            throw new ServerRtException("runtime.parser.wsdl", systemId, e);
        }
        catch (XMLStreamException e) {
            throw new ServerRtException("runtime.parser.wsdl", systemId, e);
        }
    }

    protected SDDocumentImpl(QName rootName, URL url, SDDocumentSource source) {
        assert (url != null);
        this.rootName = rootName;
        this.source = source;
        this.url = url;
    }

    public QName getRootName() {
        return this.rootName;
    }

    public boolean isWSDL() {
        return false;
    }

    public boolean isSchema() {
        return false;
    }

    public URL getURL() {
        return this.url;
    }

    public XMLStreamReader read(XMLInputFactory xif) throws IOException, XMLStreamException {
        return this.source.read(xif);
    }

    public URL getSystemId() {
        return this.url;
    }

    public void writeTo(PortAddressResolver portAddressResolver, DocumentAddressResolver resolver, OutputStream os) throws IOException {
        try {
            XMLStreamWriter w = xof.createXMLStreamWriter(os);
            w.writeStartDocument();
            this.writeTo(portAddressResolver, resolver, w);
            w.writeEndDocument();
            w.flush();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    public void writeTo(PortAddressResolver portAddressResolver, DocumentAddressResolver resolver, XMLStreamWriter out) throws XMLStreamException, IOException {
        for (SDDocumentFilter f : this.owner.filters) {
            out = f.filter(this, out);
        }
        new WSDLPatcher(this.owner.owner, this, portAddressResolver, resolver).bridge(this.source.read(xif), out);
    }

    private static final class WSDLImpl
    extends SDDocumentImpl
    implements SDDocument.WSDL {
        private final String targetNamespace;
        private final boolean hasPortType;
        private final boolean hasService;

        public WSDLImpl(QName rootName, URL url, SDDocumentSource source, String targetNamespace, boolean hasPortType, boolean hasService) {
            super(rootName, url, source);
            this.targetNamespace = targetNamespace;
            this.hasPortType = hasPortType;
            this.hasService = hasService;
        }

        public String getTargetNamespace() {
            return this.targetNamespace;
        }

        public boolean hasPortType() {
            return this.hasPortType;
        }

        public boolean hasService() {
            return this.hasService;
        }

        public boolean isWSDL() {
            return true;
        }
    }

    private static final class SchemaImpl
    extends SDDocumentImpl
    implements SDDocument.Schema {
        private final String targetNamespace;

        public SchemaImpl(QName rootName, URL url, SDDocumentSource source, String targetNamespace) {
            super(rootName, url, source);
            this.targetNamespace = targetNamespace;
        }

        public String getTargetNamespace() {
            return this.targetNamespace;
        }

        public boolean isSchema() {
            return true;
        }
    }
}

