/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.server;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractTubeImpl;
import com.sun.xml.ws.api.server.AsyncProviderCallback;
import com.sun.xml.ws.api.server.Invoker;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.api.server.WSWebServiceContext;
import com.sun.xml.ws.server.EndpointMessageContextImpl;
import com.sun.xml.ws.server.WSEndpointImpl;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InvokerTube<T>
extends AbstractTubeImpl {
    private final Invoker invoker;
    private WSEndpoint endpoint;
    private static final ThreadLocal<Packet> packets = new ThreadLocal();
    private final Invoker wrapper = new Invoker(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Packet p, Method m, Object ... args) throws InvocationTargetException, IllegalAccessException {
            Packet old = this.set(p);
            try {
                Object object = InvokerTube.this.invoker.invoke(p, m, args);
                return object;
            }
            finally {
                this.set(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T invokeProvider(Packet p, T arg) throws IllegalAccessException, InvocationTargetException {
            Packet old = this.set(p);
            try {
                T t = InvokerTube.this.invoker.invokeProvider(p, arg);
                return t;
            }
            finally {
                this.set(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> void invokeAsyncProvider(Packet p, T arg, AsyncProviderCallback cbak, WebServiceContext ctxt) throws IllegalAccessException, InvocationTargetException {
            Packet old = this.set(p);
            try {
                InvokerTube.this.invoker.invokeAsyncProvider(p, arg, cbak, ctxt);
            }
            finally {
                this.set(old);
            }
        }

        private Packet set(Packet p) {
            Packet old = (Packet)packets.get();
            packets.set(p);
            return old;
        }
    };
    private final WSWebServiceContext webServiceContext = new WSWebServiceContext(){

        public MessageContext getMessageContext() {
            return new EndpointMessageContextImpl(this.getRequestPacket());
        }

        public Principal getUserPrincipal() {
            Packet packet = this.getRequestPacket();
            return packet.webServiceContextDelegate.getUserPrincipal(packet);
        }

        @Override
        @NotNull
        public Packet getRequestPacket() {
            Packet p = (Packet)packets.get();
            assert (p != null);
            return p;
        }

        public boolean isUserInRole(String role) {
            Packet packet = this.getRequestPacket();
            return packet.webServiceContextDelegate.isUserInRole(packet, role);
        }

        public EndpointReference getEndpointReference(Element ... referenceParameters) {
            return this.getEndpointReference(W3CEndpointReference.class, referenceParameters);
        }

        public <T extends EndpointReference> T getEndpointReference(Class<T> clazz, Element ... referenceParameters) {
            Packet packet = this.getRequestPacket();
            String address = packet.webServiceContextDelegate.getEPRAddress(packet, InvokerTube.this.endpoint);
            return ((WSEndpointImpl)InvokerTube.this.endpoint).getEndpointReference(clazz, address);
        }
    };

    protected InvokerTube(Invoker invoker) {
        this.invoker = invoker;
    }

    public void setEndpoint(WSEndpoint endpoint) {
        this.endpoint = endpoint;
        this.invoker.start(this.webServiceContext, endpoint);
    }

    protected WSEndpoint getEndpoint() {
        return this.endpoint;
    }

    @NotNull
    public final Invoker getInvoker(Packet request) {
        return this.wrapper;
    }

    @Override
    public final AbstractTubeImpl copy(TubeCloner cloner) {
        cloner.add(this, this);
        return this;
    }

    @Override
    public void preDestroy() {
        this.invoker.dispose();
    }

    public static Packet getCurrentPacket() {
        return packets.get();
    }
}

