/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.server;

import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.api.server.WSWebServiceContext;
import com.sun.xml.ws.server.AbstractInstanceResolver;
import java.lang.reflect.Method;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.xml.ws.WebServiceContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMultiInstanceResolver<T>
extends AbstractInstanceResolver<T> {
    protected final Class<T> clazz;
    private AbstractInstanceResolver.InjectionPlan<T, WebServiceContext> injectionPlan;
    private WebServiceContext webServiceContext;
    protected WSEndpoint owner;
    private final Method postConstructMethod;
    private final Method preDestroyMethod;

    public AbstractMultiInstanceResolver(Class<T> clazz) {
        this.clazz = clazz;
        this.postConstructMethod = this.findAnnotatedMethod(clazz, PostConstruct.class);
        this.preDestroyMethod = this.findAnnotatedMethod(clazz, PreDestroy.class);
    }

    protected final void prepare(T t) {
        assert (this.webServiceContext != null);
        this.injectionPlan.inject(t, this.webServiceContext);
        AbstractMultiInstanceResolver.invokeMethod(this.postConstructMethod, t, new Object[0]);
    }

    protected final T create() {
        T t = AbstractMultiInstanceResolver.createNewInstance(this.clazz);
        this.prepare(t);
        return t;
    }

    @Override
    public void start(WSWebServiceContext wsc, WSEndpoint endpoint) {
        this.injectionPlan = AbstractMultiInstanceResolver.buildInjectionPlan(this.clazz, WebServiceContext.class, false);
        this.webServiceContext = wsc;
        this.owner = endpoint;
    }

    protected final void dispose(T instance) {
        AbstractMultiInstanceResolver.invokeMethod(this.preDestroyMethod, instance, new Object[0]);
    }
}

