/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.encoding.xml;

import com.sun.istack.NotNull;
import com.sun.xml.messaging.saaj.soap.AttachmentPartImpl;
import com.sun.xml.messaging.saaj.util.ByteOutputStream;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.message.Attachment;
import com.sun.xml.ws.api.message.AttachmentSet;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.ContentType;
import com.sun.xml.ws.encoding.MimeMultipartParser;
import com.sun.xml.ws.encoding.XMLHTTPBindingCodec;
import com.sun.xml.ws.message.AbstractMessageImpl;
import com.sun.xml.ws.streaming.XMLStreamReaderFactory;
import com.sun.xml.ws.streaming.XMLStreamWriterFactory;
import com.sun.xml.ws.util.FastInfosetReflection;
import com.sun.xml.ws.util.xml.XMLStreamReaderToXMLStreamWriter;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.activation.DataSource;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.WebServiceException;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public final class XMLMessage {
    private static final int PLAIN_XML_FLAG = 1;
    private static final int MIME_MULTIPART_FLAG = 2;
    private static final int FI_ENCODED_FLAG = 16;

    private static InputStream hasSomeData(InputStream in) throws IOException {
        if (in != null && in.available() < 1) {
            if (!in.markSupported()) {
                in = new BufferedInputStream(in);
            }
            in.mark(1);
            if (in.read() != -1) {
                in.reset();
            } else {
                in = null;
            }
        }
        return in;
    }

    public static Message create(String ct, InputStream in) {
        Message data;
        try {
            in = XMLMessage.hasSomeData(in);
            if (in == null) {
                Message data2 = Messages.createEmpty(SOAPVersion.SOAP_11);
                return data2;
            }
            if (ct != null) {
                boolean isFastInfoset;
                com.sun.xml.messaging.saaj.packaging.mime.internet.ContentType contentType = new com.sun.xml.messaging.saaj.packaging.mime.internet.ContentType(ct);
                int contentTypeId = XMLMessage.identifyContentType(contentType);
                boolean bl = isFastInfoset = (contentTypeId & 0x10) != 0;
                data = (contentTypeId & 2) != 0 ? new XMLMultiPart(ct, in, isFastInfoset) : ((contentTypeId & 1) != 0 || isFastInfoset ? ((contentTypeId & 0x10) != 0 ? Messages.createUsingPayload(FastInfosetReflection.FastInfosetSource_new(in), SOAPVersion.SOAP_11) : Messages.createUsingPayload(new StreamSource(in), SOAPVersion.SOAP_11)) : new UnknownContent(ct, in));
            } else {
                data = Messages.createEmpty(SOAPVersion.SOAP_11);
            }
        }
        catch (Exception ex) {
            throw new WebServiceException((Throwable)ex);
        }
        return data;
    }

    public static Message create(Source source) {
        return source == null ? Messages.createEmpty(SOAPVersion.SOAP_11) : Messages.createUsingPayload(source, SOAPVersion.SOAP_11);
    }

    public static Message create(DataSource ds) {
        try {
            return ds == null ? Messages.createEmpty(SOAPVersion.SOAP_11) : XMLMessage.create(ds.getContentType(), ds.getInputStream());
        }
        catch (IOException ioe) {
            throw new WebServiceException((Throwable)ioe);
        }
    }

    private static int getContentId(String ct) {
        try {
            com.sun.xml.messaging.saaj.packaging.mime.internet.ContentType contentType = new com.sun.xml.messaging.saaj.packaging.mime.internet.ContentType(ct);
            return XMLMessage.identifyContentType(contentType);
        }
        catch (Exception ex) {
            throw new WebServiceException((Throwable)ex);
        }
    }

    public static boolean isFastInfoset(String ct) {
        return (XMLMessage.getContentId(ct) & 0x10) != 0;
    }

    public static int identifyContentType(com.sun.xml.messaging.saaj.packaging.mime.internet.ContentType contentType) {
        String primary = contentType.getPrimaryType();
        String sub = contentType.getSubType();
        if (primary.equalsIgnoreCase("multipart") && sub.equalsIgnoreCase("related")) {
            String type = contentType.getParameter("type");
            if (type != null) {
                if (XMLMessage.isXMLType(type)) {
                    return 3;
                }
                if (XMLMessage.isFastInfosetType(type)) {
                    return 18;
                }
            }
            return 0;
        }
        if (XMLMessage.isXMLType(primary, sub)) {
            return 1;
        }
        if (XMLMessage.isFastInfosetType(primary, sub)) {
            return 16;
        }
        return 0;
    }

    protected static boolean isXMLType(String primary, String sub) {
        return (primary.equalsIgnoreCase("text") || primary.equalsIgnoreCase("application")) && sub.equalsIgnoreCase("xml");
    }

    protected static boolean isXMLType(String type) {
        return type.toLowerCase().startsWith("text/xml") || type.toLowerCase().startsWith("application/xml");
    }

    protected static boolean isFastInfosetType(String primary, String sub) {
        return primary.equalsIgnoreCase("application") && sub.equalsIgnoreCase("fastinfoset");
    }

    protected static boolean isFastInfosetType(String type) {
        return type.toLowerCase().startsWith("application/fastinfoset");
    }

    public static DataSource getDataSource(Message msg) {
        if (msg instanceof MessageDataSource) {
            return ((MessageDataSource)((Object)msg)).getDataSource();
        }
        AttachmentSet atts = msg.getAttachments();
        if (atts != null && !atts.isEmpty()) {
            ByteOutputStream bos = new ByteOutputStream();
            try {
                XMLHTTPBindingCodec codec = new XMLHTTPBindingCodec();
                ContentType ct = codec.getStaticContentType(new Packet(msg));
                codec.encode(new Packet(msg), (OutputStream)bos);
                return XMLMessage.createDataSource(ct.getContentType(), (InputStream)bos.newInputStream());
            }
            catch (IOException ioe) {
                throw new WebServiceException((Throwable)ioe);
            }
        }
        ByteOutputStream bos = new ByteOutputStream();
        XMLStreamWriter writer = XMLStreamWriterFactory.createXMLStreamWriter((OutputStream)bos);
        try {
            msg.writePayloadTo(writer);
            writer.flush();
        }
        catch (XMLStreamException e) {
            throw new WebServiceException((Throwable)e);
        }
        return XMLMessage.createDataSource("text/xml", (InputStream)bos.newInputStream());
    }

    public static DataSource createDataSource(final String contentType, final InputStream is) {
        return new DataSource(){

            public InputStream getInputStream() {
                return is;
            }

            public OutputStream getOutputStream() {
                return null;
            }

            public String getContentType() {
                return contentType;
            }

            public String getName() {
                return "";
            }
        };
    }

    static {
        new AttachmentPartImpl();
    }

    public static class UnknownContent
    extends AbstractMessageImpl
    implements MessageDataSource {
        private final DataSource ds;
        private final HeaderList headerList = new HeaderList();

        public UnknownContent(String ct, InputStream in) {
            super(SOAPVersion.SOAP_11);
            this.ds = XMLMessage.createDataSource(ct, in);
        }

        public UnknownContent(DataSource ds) {
            super(SOAPVersion.SOAP_11);
            this.ds = ds;
        }

        public boolean hasUnconsumedDataSource() {
            return true;
        }

        public DataSource getDataSource() {
            assert (this.ds != null);
            return this.ds;
        }

        protected void writePayloadTo(ContentHandler contentHandler, ErrorHandler errorHandler, boolean fragment) throws SAXException {
            throw new UnsupportedOperationException();
        }

        public boolean hasHeaders() {
            return false;
        }

        public boolean isFault() {
            return false;
        }

        public HeaderList getHeaders() {
            return this.headerList;
        }

        public String getPayloadLocalPart() {
            throw new UnsupportedOperationException();
        }

        public String getPayloadNamespaceURI() {
            throw new UnsupportedOperationException();
        }

        public boolean hasPayload() {
            return false;
        }

        public Source readPayloadAsSource() {
            return null;
        }

        public XMLStreamReader readPayload() throws XMLStreamException {
            throw new WebServiceException("There isn't XML payload. Shouldn't come here.");
        }

        public void writePayloadTo(XMLStreamWriter sw) throws XMLStreamException {
        }

        public Message copy() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class XMLAttachmentSet
    implements AttachmentSet {
        private final Map<String, Attachment> attMap = new HashMap<String, Attachment>();

        public XMLAttachmentSet(MimeMultipartParser mpp) {
            this.attMap.putAll(mpp.getAttachmentParts());
        }

        @Override
        public Attachment get(String contentId) {
            return this.attMap.get(contentId);
        }

        @Override
        public boolean isEmpty() {
            return this.attMap.isEmpty();
        }

        @Override
        public Iterator<Attachment> iterator() {
            return this.attMap.values().iterator();
        }

        @Override
        public void add(Attachment att) {
            this.attMap.put(att.getContentId(), att);
        }
    }

    public static final class XMLMultiPart
    extends AbstractMessageImpl
    implements MessageDataSource {
        private final DataSource dataSource;
        private boolean rootIsFastInfoset;
        private MimeMultipartParser mpp;

        public XMLMultiPart(String contentType, InputStream is) {
            this(contentType, is, false);
        }

        public XMLMultiPart(String contentType, InputStream is, boolean rootIsFastInfoset) {
            super(SOAPVersion.SOAP_11);
            this.dataSource = XMLMessage.createDataSource(contentType, is);
            this.rootIsFastInfoset = rootIsFastInfoset;
        }

        public XMLMultiPart(DataSource dataSource) {
            super(SOAPVersion.SOAP_11);
            this.dataSource = dataSource;
        }

        public DataSource getDataSource() {
            assert (this.dataSource != null);
            return this.dataSource;
        }

        private void convertDataSourceToMessage() {
            if (this.mpp == null) {
                try {
                    this.mpp = new MimeMultipartParser(this.dataSource.getInputStream(), this.dataSource.getContentType());
                    if (!this.rootIsFastInfoset) {
                        this.rootIsFastInfoset = XMLMessage.isFastInfosetType(this.mpp.getRootPart().getContentType());
                    }
                }
                catch (IOException ioe) {
                    throw new WebServiceException((Throwable)ioe);
                }
            }
        }

        public boolean isOneWay(@NotNull WSDLPort port) {
            return false;
        }

        public boolean isFault() {
            return false;
        }

        public boolean hasHeaders() {
            return false;
        }

        public HeaderList getHeaders() {
            return new HeaderList();
        }

        public AttachmentSet getAttachments() {
            this.convertDataSourceToMessage();
            return new XMLAttachmentSet(this.mpp);
        }

        public String getPayloadLocalPart() {
            throw new UnsupportedOperationException();
        }

        public String getPayloadNamespaceURI() {
            throw new UnsupportedOperationException();
        }

        public boolean hasPayload() {
            return true;
        }

        public Source readPayloadAsSource() {
            this.convertDataSourceToMessage();
            if (this.rootIsFastInfoset) {
                return FastInfosetReflection.FastInfosetSource_new(this.mpp.getRootPart().asInputStream());
            }
            return this.mpp.getRootPart().asSource();
        }

        public XMLStreamReader readPayload() throws XMLStreamException {
            this.convertDataSourceToMessage();
            if (this.rootIsFastInfoset) {
                return XMLStreamReaderFactory.createFIStreamReader(this.mpp.getRootPart().asInputStream());
            }
            return XMLStreamReaderFactory.createXMLStreamReader(this.mpp.getRootPart().asInputStream(), true);
        }

        public void writePayloadTo(XMLStreamWriter sw) {
            XMLStreamReaderToXMLStreamWriter c = new XMLStreamReaderToXMLStreamWriter();
            try {
                c.bridge(this.readPayload(), sw);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        protected void writePayloadTo(ContentHandler contentHandler, ErrorHandler errorHandler, boolean fragment) {
            throw new UnsupportedOperationException();
        }

        public Message copy() {
            throw new UnsupportedOperationException();
        }

        public boolean hasUnconsumedDataSource() {
            return this.mpp == null;
        }
    }

    public static interface MessageDataSource {
        public boolean hasUnconsumedDataSource();

        public DataSource getDataSource();
    }
}

