/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.client.dispatch;

import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.binding.BindingImpl;
import com.sun.xml.ws.client.WSServiceDelegate;
import com.sun.xml.ws.client.dispatch.DispatchImpl;
import com.sun.xml.ws.message.saaj.SAAJMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPMessageDispatch
extends DispatchImpl<SOAPMessage> {
    public SOAPMessageDispatch(QName port, Service.Mode mode, WSServiceDelegate owner, Tube pipe, BindingImpl binding, WSEndpointReference epr) {
        super(port, mode, owner, pipe, binding, epr);
    }

    @Override
    Packet createPacket(SOAPMessage arg) {
        if (arg == null && !SOAPMessageDispatch.isXMLHttp(this.binding)) {
            throw new WebServiceException("Can not invoke a SOAPMessage with a null invocation parameter");
        }
        MimeHeaders mhs = arg.getMimeHeaders();
        mhs.addHeader("Content-Type", "text/xml");
        mhs.addHeader("Content-Transfer-Encoding", "binary");
        HashMap ch = new HashMap();
        Iterator iter = arg.getMimeHeaders().getAllHeaders();
        while (iter.hasNext()) {
            ArrayList<String> h = new ArrayList<String>();
            MimeHeader mh = (MimeHeader)iter.next();
            h.clear();
            h.add(mh.getValue());
            ch.put(mh.getName(), h);
        }
        Packet packet = new Packet(new SAAJMessage(arg));
        packet.invocationProperties.put("javax.xml.ws.http.request.headers", ch);
        return packet;
    }

    @Override
    SOAPMessage toReturnValue(Packet response) {
        try {
            return response.getMessage().readAsSOAPMessage();
        }
        catch (SOAPException e) {
            throw new WebServiceException((Throwable)e);
        }
    }
}

