/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.client.dispatch;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.binding.BindingImpl;
import com.sun.xml.ws.client.RequestContext;
import com.sun.xml.ws.client.ResponseContextReceiver;
import com.sun.xml.ws.client.ResponseImpl;
import com.sun.xml.ws.client.Stub;
import com.sun.xml.ws.client.WSServiceDelegate;
import com.sun.xml.ws.encoding.soap.DeserializationException;
import com.sun.xml.ws.fault.SOAPFaultBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Response;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPFaultException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DispatchImpl<T>
extends Stub
implements Dispatch<T> {
    final Service.Mode mode;
    final QName portname;
    final SOAPVersion soapVersion;
    static final long AWAIT_TERMINATION_TIME = 800L;

    protected DispatchImpl(QName port, Service.Mode mode, WSServiceDelegate owner, Tube pipe, BindingImpl binding, WSEndpointReference epr) {
        super(owner, pipe, binding, owner.getWsdlService() != null ? owner.getWsdlService().get(port) : null, owner.getEndpointAddress(port), epr);
        this.portname = port;
        this.mode = mode;
        this.soapVersion = binding.getSOAPVersion();
    }

    abstract Packet createPacket(T var1);

    abstract T toReturnValue(Packet var1);

    public final Response<T> invokeAsync(T param) {
        Invoker invoker = new Invoker(param);
        ResponseImpl ft = new ResponseImpl(invoker, null);
        invoker.setReceiver(ft);
        this.owner.getExecutor().execute(ft);
        return ft;
    }

    public final Future<?> invokeAsync(T param, AsyncHandler<T> asyncHandler) {
        Invoker invoker = new Invoker(param);
        ResponseImpl<T> ft = new ResponseImpl<T>(invoker, asyncHandler);
        invoker.setReceiver(ft);
        ExecutorService exec = (ExecutorService)this.owner.getExecutor();
        try {
            exec.awaitTermination(800L, TimeUnit.MICROSECONDS);
        }
        catch (InterruptedException e) {
            throw new WebServiceException((Throwable)e);
        }
        exec.execute(ft);
        return ft;
    }

    public final T doInvoke(T in, RequestContext rc, ResponseContextReceiver receiver) {
        Packet response;
        try {
            DispatchImpl.checkNullAllowed(in, rc, this.binding, this.mode);
            Packet message = this.createPacket(in);
            this.resolveEndpointAddress(message, rc);
            this.setProperties(message, true);
            response = this.process(message, rc, receiver);
            Message msg = response.getMessage();
            if (msg != null && msg.isFault()) {
                SOAPFaultBuilder faultBuilder = SOAPFaultBuilder.create(msg);
                throw (SOAPFaultException)faultBuilder.createException(null, msg);
            }
        }
        catch (JAXBException e) {
            throw new DeserializationException("failed.to.read.response", new Object[]{e});
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new WebServiceException(e);
        }
        return this.toReturnValue(response);
    }

    public final T invoke(T in) {
        return this.doInvoke(in, this.requestContext, this);
    }

    public final void invokeOneWay(T in) {
        DispatchImpl.checkNullAllowed(in, this.requestContext, this.binding, this.mode);
        Packet request = this.createPacket(in);
        this.setProperties(request, false);
        Packet response = this.process(request, this.requestContext, this);
    }

    void setProperties(Packet packet, boolean expectReply) {
        packet.expectReply = expectReply;
    }

    static boolean isXMLHttp(WSBinding binding) {
        return binding.getBindingId().equals(BindingID.XML_HTTP);
    }

    static boolean isPAYLOADMode(Service.Mode mode) {
        return mode == Service.Mode.PAYLOAD;
    }

    static void checkNullAllowed(Object in, RequestContext rc, WSBinding binding, Service.Mode mode) {
        if (in != null) {
            return;
        }
        if (DispatchImpl.isXMLHttp(binding)) {
            if (DispatchImpl.methodNotOk(rc)) {
                throw new WebServiceException("A XML/HTTP request using MessageContext.HTTP_REQUEST_METHOD equals \"POST\" with a Null invocation Argument is not allowed");
            }
        } else if (mode == Service.Mode.MESSAGE) {
            throw new WebServiceException("SOAP/HTTP Binding in Service.Mode.message is not allowed with a null invocation argument");
        }
    }

    static boolean methodNotOk(RequestContext rc) {
        String requestMethod = (String)rc.get("javax.xml.ws.http.request.method");
        String request = requestMethod == null ? "POST" : requestMethod;
        return "POST".equalsIgnoreCase(request) || "PUT".equalsIgnoreCase(request);
    }

    public static void checkValidSOAPMessageDispatch(WSBinding binding, Service.Mode mode) {
        if (DispatchImpl.isXMLHttp(binding)) {
            throw new WebServiceException("Can not create Dispatch<SOAPMessage> with XML/HTTP Binding, SOAPBinding only.");
        }
        if (DispatchImpl.isPAYLOADMode(mode)) {
            throw new WebServiceException("Can not create Dispatch<SOAPMessage> of Service.Mode.PAYLOAD, Service.Mode.MESSAGE only");
        }
    }

    public static void checkValidDataSourceDispatch(WSBinding binding, Service.Mode mode) {
        if (!DispatchImpl.isXMLHttp(binding)) {
            throw new WebServiceException("Can not create Dispatch<DataSource> with SOAP Binding Binding, XML/HTTP Binding only.");
        }
        if (DispatchImpl.isPAYLOADMode(mode)) {
            throw new WebServiceException("Can not create Dispatch<DataSource> of Service.Mode.PAYLOAD, Service.Mode.MESSAGE only");
        }
    }

    @Override
    @NotNull
    protected final QName getPortName() {
        return this.portname;
    }

    void resolveEndpointAddress(Packet message, RequestContext requestContext) {
        String origEndpoint = (String)requestContext.get("javax.xml.ws.service.endpoint.address");
        String pathInfo = null;
        String queryString = null;
        if (requestContext.get("javax.xml.ws.http.request.pathinfo") != null) {
            pathInfo = (String)requestContext.get("javax.xml.ws.http.request.pathinfo");
        }
        if (requestContext.get("javax.xml.ws.http.request.querystring") != null) {
            queryString = (String)requestContext.get("javax.xml.ws.http.request.querystring");
        }
        String resolvedEndpoint = null;
        if (pathInfo != null || queryString != null) {
            pathInfo = DispatchImpl.checkPath(pathInfo);
            queryString = DispatchImpl.checkQuery(queryString);
            if (origEndpoint != null) {
                try {
                    URI endpointURI = new URI(origEndpoint);
                    resolvedEndpoint = this.resolveURI(endpointURI, pathInfo, queryString);
                }
                catch (URISyntaxException e) {
                    resolvedEndpoint = origEndpoint;
                }
            }
            requestContext.put("javax.xml.ws.service.endpoint.address", resolvedEndpoint);
        }
    }

    protected String resolveURI(URI endpointURI, String pathInfo, String queryString) {
        String query = null;
        String fragment = null;
        if (queryString != null) {
            URI result = endpointURI.resolve(queryString);
            query = result.getQuery();
            fragment = result.getFragment();
        }
        String path = pathInfo != null ? pathInfo : endpointURI.getPath();
        try {
            URI temp = new URI(null, null, path, query, fragment);
            return endpointURI.resolve(temp).toString();
        }
        catch (URISyntaxException e) {
            throw new WebServiceException("Unable to resolve endpoint address using the supplied path " + path);
        }
    }

    private static String checkPath(String path) {
        return path == null || path.startsWith("/") ? path : "/" + path;
    }

    private static String checkQuery(String query) {
        return query == null || query.startsWith("?") ? query : "?" + query;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Invoker
    implements Callable {
        private final T param;
        private final RequestContext rc;
        private ResponseContextReceiver receiver;

        Invoker(T param) {
            this.rc = DispatchImpl.this.requestContext.copy();
            this.param = param;
        }

        public T call() throws Exception {
            return DispatchImpl.this.doInvoke(this.param, this.rc, this.receiver);
        }

        void setReceiver(ResponseContextReceiver receiver) {
            this.receiver = receiver;
        }
    }
}

