/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.client;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.Closeable;
import com.sun.xml.ws.addressing.EndpointReferenceUtil;
import com.sun.xml.ws.api.EndpointAddress;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.client.WSBindingProvider;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Engine;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.binding.BindingImpl;
import com.sun.xml.ws.client.RequestContext;
import com.sun.xml.ws.client.ResponseContext;
import com.sun.xml.ws.client.ResponseContextReceiver;
import com.sun.xml.ws.client.WSServiceDelegate;
import com.sun.xml.ws.resources.ClientMessages;
import com.sun.xml.ws.util.Pool;
import com.sun.xml.ws.util.RuntimeVersion;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.xml.namespace.QName;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Stub
implements WSBindingProvider,
ResponseContextReceiver,
Closeable {
    private Pool<Tube> tubes;
    private final Engine engine;
    protected final WSServiceDelegate owner;
    @Nullable
    protected final WSEndpointReference endpointReference;
    protected final BindingImpl binding;
    public final RequestContext requestContext = new RequestContext();
    private ResponseContext responseContext;
    @Nullable
    protected final WSDLPort wsdlPort;

    protected Stub(WSServiceDelegate owner, Tube master, BindingImpl binding, WSDLPort wsdlPort, EndpointAddress defaultEndPointAddress, @Nullable WSEndpointReference epr) {
        this.owner = owner;
        this.tubes = new Pool.TubePool(master);
        this.wsdlPort = wsdlPort;
        this.binding = binding;
        this.requestContext.setEndpointAddress(defaultEndPointAddress);
        this.engine = new Engine();
        this.endpointReference = epr;
        if (!binding.isAddressingEnabled() && epr != null) {
            throw new WebServiceException(ClientMessages.EPR_WITHOUT_ADDRESSING_ON());
        }
    }

    @NotNull
    protected abstract QName getPortName();

    @NotNull
    protected final QName getServiceName() {
        return this.owner.getServiceName();
    }

    public final Executor getExecutor() {
        return this.owner.getExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Packet process(Packet packet, RequestContext requestContext, ResponseContextReceiver receiver) {
        Packet reply;
        Pool<Tube> pool;
        packet.proxy = this;
        packet.handlerConfig = this.binding.getHandlerConfig();
        requestContext.fill(packet);
        if (this.binding.isAddressingEnabled() && this.endpointReference != null) {
            this.endpointReference.addReferenceParameters(packet.getMessage().getHeaders());
        }
        if ((pool = this.tubes) == null) {
            throw new WebServiceException("close method has already been invoked");
        }
        Fiber fiber = this.engine.createFiber();
        Tube tube = pool.take();
        try {
            reply = fiber.runSync(tube, packet);
        }
        finally {
            pool.recycle(tube);
        }
        receiver.setResponseContext(new ResponseContext(reply));
        return reply;
    }

    @Override
    public void close() {
        if (this.tubes != null) {
            Tube p = this.tubes.take();
            this.tubes = null;
            p.preDestroy();
        }
    }

    public final WSBinding getBinding() {
        return this.binding;
    }

    public final Map<String, Object> getRequestContext() {
        return this.requestContext.getMapView();
    }

    public final ResponseContext getResponseContext() {
        return this.responseContext;
    }

    @Override
    public void setResponseContext(ResponseContext rc) {
        this.responseContext = rc;
    }

    public String toString() {
        return RuntimeVersion.VERSION + ": Stub for " + this.getRequestContext().get("javax.xml.ws.service.endpoint.address");
    }

    public final W3CEndpointReference getEndpointReference() {
        return this.getEndpointReference(W3CEndpointReference.class);
    }

    public final <T extends EndpointReference> T getEndpointReference(Class<T> clazz) {
        if (this.endpointReference != null) {
            return this.endpointReference.toSpec(clazz);
        }
        QName portTypeName = null;
        if (this.wsdlPort != null) {
            portTypeName = this.wsdlPort.getBinding().getPortTypeName();
        }
        return (T)((EndpointReference)clazz.cast(EndpointReferenceUtil.getEndpointReference(clazz, this.requestContext.getEndpointAddress().toString(), this.getServiceName(), this.getPortName().getLocalPart(), portTypeName, this.wsdlPort != null)));
    }
}

