/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.client;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.binding.BindingImpl;
import com.sun.xml.ws.binding.SOAPBindingImpl;
import com.sun.xml.ws.client.PortInfo;
import com.sun.xml.ws.client.WSServiceDelegate;
import com.sun.xml.ws.model.SOAPSEIModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.ws.WebServiceFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SEIPortInfo
extends PortInfo {
    public final Class sei;
    public final SOAPSEIModel model;

    public SEIPortInfo(WSServiceDelegate owner, Class sei, SOAPSEIModel model, @NotNull WSDLPort portModel) {
        super(owner, portModel);
        this.sei = sei;
        this.model = model;
        assert (sei != null && model != null);
    }

    @Override
    public BindingImpl createBinding() {
        return this.createBinding(null);
    }

    @Override
    public BindingImpl createBinding(WebServiceFeature[] webServiceFeatures) {
        BindingImpl bindingImpl = super.createBinding(this.resolveFeatures(webServiceFeatures));
        if (bindingImpl instanceof SOAPBindingImpl) {
            ((SOAPBindingImpl)bindingImpl).setPortKnownHeaders(this.model.getKnownHeaders());
        }
        return bindingImpl;
    }

    @Override
    protected List<WebServiceFeature> extractWSDLFeatures() {
        ArrayList<WebServiceFeature> wsdlFeatures = null;
        if (this.portModel != null) {
            WebServiceFeature wsdlFastInfosetFeature;
            wsdlFeatures = new ArrayList<WebServiceFeature>();
            WebServiceFeature wsdlAddressingFeature = this.portModel.getFeature("http://www.w3.org/2005/08/addressing/module");
            if (wsdlAddressingFeature != null) {
                wsdlFeatures.add(wsdlAddressingFeature);
            } else {
                wsdlAddressingFeature = this.portModel.getFeature("http://java.sun.com/xml/ns/jaxws/2004/08/addressing");
                if (wsdlAddressingFeature != null) {
                    wsdlFeatures.add(wsdlAddressingFeature);
                }
            }
            WebServiceFeature wsdlMTOMFeature = this.portModel.getFeature("http://www.w3.org/2004/08/soap/features/http-optimization");
            if (wsdlMTOMFeature != null) {
                wsdlFeatures.add(wsdlMTOMFeature);
            }
            if ((wsdlFastInfosetFeature = this.portModel.getFeature("http://java.sun.com/xml/ns/jaxws/fastinfoset")) != null) {
                wsdlFeatures.add(wsdlFastInfosetFeature);
            }
        }
        return wsdlFeatures;
    }

    @Override
    protected WebServiceFeature[] resolveFeatures(WebServiceFeature[] webServiceFeatures) {
        Map<String, WebServiceFeature> featureMap = SEIPortInfo.fillMap(webServiceFeatures);
        List<WebServiceFeature> wsdlFeatures = this.extractWSDLFeatures();
        for (WebServiceFeature ftr : wsdlFeatures) {
            if (featureMap.get(ftr.getID()) != null) continue;
            featureMap.put(ftr.getID(), ftr);
        }
        return featureMap.values().toArray(new WebServiceFeature[featureMap.size()]);
    }
}

