/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.binding;

import com.sun.istack.NotNull;
import com.sun.xml.ws.developer.MemberSubmissionAddressing;
import com.sun.xml.ws.developer.MemberSubmissionAddressingFeature;
import com.sun.xml.ws.developer.Stateful;
import com.sun.xml.ws.developer.StatefulFeature;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import javax.xml.ws.RespectBinding;
import javax.xml.ws.RespectBindingFeature;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.Addressing;
import javax.xml.ws.soap.AddressingFeature;
import javax.xml.ws.soap.MTOM;
import javax.xml.ws.soap.MTOMFeature;
import javax.xml.ws.spi.WebServiceFeatureAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingTypeImpl {
    public static WebServiceFeature[] parseBindingType(@NotNull Class<?> endpointClass) {
        ArrayList<AddressingFeature> wsfeatures = null;
        Annotation[] anns = endpointClass.getAnnotations();
        if (anns == null) {
            return null;
        }
        wsfeatures = new ArrayList<AddressingFeature>();
        for (Annotation a : anns) {
            Object addAnn;
            Object ftr = null;
            if (!a.annotationType().isAnnotationPresent(WebServiceFeatureAnnotation.class)) continue;
            if (a instanceof Addressing) {
                addAnn = (Addressing)a;
                ftr = new AddressingFeature(addAnn.enabled(), addAnn.required());
            } else if (a instanceof MemberSubmissionAddressing) {
                addAnn = (MemberSubmissionAddressing)a;
                ftr = new MemberSubmissionAddressingFeature(addAnn.enabled(), addAnn.required());
            } else if (a instanceof MTOM) {
                MTOM mtomAnn = (MTOM)a;
                ftr = new MTOMFeature(mtomAnn.enabled(), mtomAnn.threshold());
            } else if (a instanceof RespectBinding) {
                RespectBinding rbAnn = (RespectBinding)a;
                ftr = new RespectBindingFeature(rbAnn.enabled());
            } else if (a instanceof Stateful) {
                ftr = new StatefulFeature();
            }
            wsfeatures.add((AddressingFeature)ftr);
        }
        return wsfeatures.toArray(new WebServiceFeature[0]);
    }

    public static boolean isFeatureEnabled(@NotNull String featureID, WebServiceFeature[] wsfeatures) {
        if (wsfeatures == null) {
            return false;
        }
        for (WebServiceFeature ftr : wsfeatures) {
            if (!ftr.getID().equals(featureID) || !ftr.isEnabled()) continue;
            return true;
        }
        return false;
    }

    public static WebServiceFeature getFeature(@NotNull String featureID, WebServiceFeature[] wsfeatures) {
        if (wsfeatures == null) {
            return null;
        }
        for (WebServiceFeature ftr : wsfeatures) {
            if (!ftr.getID().equals(featureID)) continue;
            return ftr;
        }
        return null;
    }
}

