/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.api.addressing;

import com.sun.istack.NotNull;
import com.sun.xml.stream.buffer.XMLStreamBuffer;
import com.sun.xml.ws.addressing.WsaTubeHelper;
import com.sun.xml.ws.addressing.v200408.WsaTubeHelperImpl;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.addressing.OutboundReferenceParameterHeader;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.developer.MemberSubmissionAddressingFeature;
import com.sun.xml.ws.developer.MemberSubmissionEndpointReference;
import com.sun.xml.ws.message.stream.OutboundStreamHeader;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.AddressingFeature;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum AddressingVersion {
    W3C("http://www.w3.org/2005/08/addressing", "w3c-anonymous-epr.xml", "http://www.w3.org/2006/05/addressing/wsdl", "http://www.w3.org/2006/05/addressing/wsdl", W3CEndpointReference.class){

        public boolean isReferenceParameter(String localName) {
            return localName.equals("ReferenceParameters");
        }

        public WsaTubeHelper getWsaHelper(WSDLPort wsdlPort, WSBinding binding) {
            return new com.sun.xml.ws.addressing.WsaTubeHelperImpl(wsdlPort, binding);
        }

        public String getNoneUri() {
            return this.nsUri + "/none";
        }

        public String getAnonymousUri() {
            return this.nsUri + "/anonymous";
        }

        String getMapRequiredLocalName() {
            return "MessageAddressingHeaderRequired";
        }

        public String getMapRequiredText() {
            return "A required header representing a Message Addressing Property is not present";
        }

        String getInvalidMapLocalName() {
            return "InvalidAddressingHeader";
        }

        public String getInvalidMapText() {
            return "A header representing a Message Addressing Property is not valid and the message cannot be processed";
        }

        String getInvalidCardinalityLocalName() {
            return "InvalidCardinality";
        }

        Header createReferenceParameterHeader(XMLStreamBuffer mark, String nsUri, String localName) {
            return new OutboundReferenceParameterHeader(mark, nsUri, localName);
        }

        String getIsReferenceParameterLocalName() {
            return "IsReferenceParameter";
        }

        String getWsdlAnonymousLocalName() {
            return "Anonymous";
        }

        public String getPrefix() {
            return "wsa";
        }

        public String getWsdlPrefix() {
            return "wsaw";
        }

        public String getFeatureID() {
            return "http://www.w3.org/2005/08/addressing/module";
        }
    }
    ,
    MEMBER("http://schemas.xmlsoap.org/ws/2004/08/addressing", "member-anonymous-epr.xml", "http://schemas.xmlsoap.org/ws/2004/08/addressing", "http://schemas.xmlsoap.org/ws/2004/08/addressing/policy", MemberSubmissionEndpointReference.class){

        public boolean isReferenceParameter(String localName) {
            return localName.equals("ReferenceParameters") || localName.equals("ReferenceProperties");
        }

        public WsaTubeHelper getWsaHelper(WSDLPort wsdlPort, WSBinding binding) {
            return new WsaTubeHelperImpl(wsdlPort, binding);
        }

        public String getNoneUri() {
            return "";
        }

        public String getAnonymousUri() {
            return this.nsUri + "/role/anonymous";
        }

        String getMapRequiredLocalName() {
            return "MessageInformationHeaderRequired";
        }

        public String getMapRequiredText() {
            return "A required message information header, To, MessageID, or Action, is not present.";
        }

        String getInvalidMapLocalName() {
            return "InvalidMessageInformationHeader";
        }

        public String getInvalidMapText() {
            return "A message information header is not valid and the message cannot be processed.";
        }

        String getInvalidCardinalityLocalName() {
            return this.getInvalidMapLocalName();
        }

        Header createReferenceParameterHeader(XMLStreamBuffer mark, String nsUri, String localName) {
            return new OutboundStreamHeader(mark, nsUri, localName);
        }

        String getIsReferenceParameterLocalName() {
            return "";
        }

        String getWsdlAnonymousLocalName() {
            return "";
        }

        public String getPrefix() {
            return "wsa";
        }

        public String getWsdlPrefix() {
            return "wsaw";
        }

        public String getFeatureID() {
            return "http://java.sun.com/xml/ns/jaxws/2004/08/addressing";
        }
    };

    public final String nsUri;
    public final String wsdlNsUri;
    public final Class<? extends EndpointReference> eprClass;
    public final String policyNsUri;
    public final WSEndpointReference anonymousEpr;
    public final QName toTag;
    public final QName fromTag;
    public final QName replyToTag;
    public final QName faultToTag;
    public final QName actionTag;
    public final QName messageIDTag;
    public final QName relatesToTag;
    public final QName mapRequiredTag;
    public final QName actionNotSupportedTag;
    public final String actionNotSupportedText;
    public final QName invalidMapTag;
    public final QName invalidCardinalityTag;
    public final QName problemHeaderQNameTag;
    public final QName faultDetailTag;
    public final QName fault_missingAddressInEpr;
    public final QName wsdlActionTag;
    public final QName wsdlExtensionTag;
    public final QName wsdlAnonymousTag;
    public final QName isReferenceParameterTag;
    private static final String EXTENDED_FAULT_NAMESPACE = "http://jax-ws.dev.java.net/addressing/fault";
    public static final String UNSET_OUTPUT_ACTION = "http://jax-ws.dev.java.net/addressing/output-action-not-set";
    public static final String UNSET_INPUT_ACTION = "http://jax-ws.dev.java.net/addressing/input-action-not-set";
    public static final QName fault_duplicateAddressInEpr;

    private AddressingVersion(String nsUri, String anonymousEprResourceName, String wsdlNsUri, String policyNsUri, Class<? extends EndpointReference> eprClass) {
        this.nsUri = nsUri;
        this.wsdlNsUri = wsdlNsUri;
        this.policyNsUri = policyNsUri;
        this.eprClass = eprClass;
        this.toTag = new QName(nsUri, "To");
        this.fromTag = new QName(nsUri, "From");
        this.replyToTag = new QName(nsUri, "ReplyTo");
        this.faultToTag = new QName(nsUri, "FaultTo");
        this.actionTag = new QName(nsUri, "Action");
        this.messageIDTag = new QName(nsUri, "MessageID");
        this.relatesToTag = new QName(nsUri, "RelatesTo");
        this.mapRequiredTag = new QName(nsUri, this.getMapRequiredLocalName());
        this.actionNotSupportedTag = new QName(nsUri, "ActionNotSupported");
        this.actionNotSupportedText = "The \"%s\" cannot be processed at the receiver";
        this.invalidMapTag = new QName(nsUri, this.getInvalidMapLocalName());
        this.invalidCardinalityTag = new QName(nsUri, this.getInvalidCardinalityLocalName());
        this.faultDetailTag = new QName(nsUri, "FaultDetail");
        this.problemHeaderQNameTag = new QName(nsUri, "ProblemHeaderQName");
        this.fault_missingAddressInEpr = new QName(nsUri, "MissingAddressInEPR", "wsa");
        this.isReferenceParameterTag = new QName(nsUri, this.getIsReferenceParameterLocalName());
        this.wsdlActionTag = new QName(wsdlNsUri, "Action");
        this.wsdlExtensionTag = new QName(wsdlNsUri, "UsingAddressing");
        this.wsdlAnonymousTag = new QName(wsdlNsUri, this.getWsdlAnonymousLocalName());
        try {
            this.anonymousEpr = new WSEndpointReference(((Object)((Object)this)).getClass().getResourceAsStream(anonymousEprResourceName), this);
        }
        catch (XMLStreamException e) {
            throw new Error(e);
        }
    }

    public static AddressingVersion fromNsUri(String nsUri) {
        if (nsUri.equals(AddressingVersion.W3C.nsUri)) {
            return W3C;
        }
        if (nsUri.equals(AddressingVersion.MEMBER.nsUri)) {
            return MEMBER;
        }
        return null;
    }

    public static AddressingVersion fromBinding(WSBinding binding) {
        if (binding.isFeatureEnabled("http://www.w3.org/2005/08/addressing/module")) {
            return W3C;
        }
        if (binding.isFeatureEnabled("http://java.sun.com/xml/ns/jaxws/2004/08/addressing")) {
            return MEMBER;
        }
        return null;
    }

    public static AddressingVersion fromPort(WSDLPort port) {
        if (port == null) {
            return null;
        }
        WebServiceFeature wsf = port.getFeature("http://www.w3.org/2005/08/addressing/module");
        if (wsf == null) {
            wsf = port.getFeature("http://java.sun.com/xml/ns/jaxws/2004/08/addressing");
        }
        if (wsf == null) {
            return null;
        }
        return AddressingVersion.fromFeature(wsf);
    }

    public String getNsUri() {
        return this.nsUri;
    }

    public abstract boolean isReferenceParameter(String var1);

    public abstract WsaTubeHelper getWsaHelper(WSDLPort var1, WSBinding var2);

    public abstract String getNoneUri();

    public abstract String getAnonymousUri();

    public String getDefaultFaultAction() {
        return this.nsUri + "/fault";
    }

    abstract String getMapRequiredLocalName();

    public abstract String getMapRequiredText();

    abstract String getInvalidMapLocalName();

    public abstract String getInvalidMapText();

    abstract String getInvalidCardinalityLocalName();

    abstract String getWsdlAnonymousLocalName();

    public abstract String getPrefix();

    public abstract String getWsdlPrefix();

    public abstract String getFeatureID();

    abstract Header createReferenceParameterHeader(XMLStreamBuffer var1, String var2, String var3);

    abstract String getIsReferenceParameterLocalName();

    public static AddressingVersion fromFeature(WebServiceFeature af) {
        if (af.getID().equals("http://www.w3.org/2005/08/addressing/module")) {
            return W3C;
        }
        if (af.getID().equals("http://java.sun.com/xml/ns/jaxws/2004/08/addressing")) {
            return MEMBER;
        }
        return null;
    }

    @NotNull
    public static WebServiceFeature getFeature(String nsUri, boolean enabled, boolean required) {
        if (nsUri == AddressingVersion.W3C.policyNsUri) {
            return new AddressingFeature(enabled, required);
        }
        if (nsUri == AddressingVersion.MEMBER.policyNsUri) {
            return new MemberSubmissionAddressingFeature(enabled, required);
        }
        throw new WebServiceException("Unsupported namespace URI: " + nsUri);
    }

    @NotNull
    public static AddressingVersion fromSpecClass(Class<? extends EndpointReference> eprClass) {
        if (eprClass == W3CEndpointReference.class) {
            return W3C;
        }
        if (eprClass == MemberSubmissionEndpointReference.class) {
            return MEMBER;
        }
        throw new WebServiceException("Unsupported EPR type: " + eprClass);
    }

    public static boolean isRequired(WebServiceFeature wsf) {
        if (wsf.getID().equals("http://www.w3.org/2005/08/addressing/module")) {
            return ((AddressingFeature)wsf).isRequired();
        }
        if (wsf.getID().equals("http://java.sun.com/xml/ns/jaxws/2004/08/addressing")) {
            return ((MemberSubmissionAddressingFeature)wsf).isRequired();
        }
        throw new WebServiceException("WebServiceFeature not an Addressing feature: " + wsf.getID());
    }

    public static boolean isRequired(WSBinding binding) {
        WebServiceFeature wsf = binding.getFeature("http://www.w3.org/2005/08/addressing/module");
        if (wsf == null) {
            wsf = binding.getFeature("http://java.sun.com/xml/ns/jaxws/2004/08/addressing");
        }
        if (wsf == null) {
            return false;
        }
        return AddressingVersion.isRequired(wsf);
    }

    public static boolean isEnabled(WSBinding binding) {
        return binding.isFeatureEnabled("http://java.sun.com/xml/ns/jaxws/2004/08/addressing") || binding.isFeatureEnabled("http://www.w3.org/2005/08/addressing/module");
    }

    static {
        fault_duplicateAddressInEpr = new QName(EXTENDED_FAULT_NAMESPACE, "DuplicateAddressInEpr");
    }
}

