/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.addressing;

import com.sun.istack.NotNull;
import com.sun.xml.ws.addressing.WsaTube;
import com.sun.xml.ws.addressing.model.ActionNotSupportedException;
import com.sun.xml.ws.addressing.model.MapRequiredException;
import com.sun.xml.ws.api.EndpointAddress;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.binding.BindingImpl;
import com.sun.xml.ws.resources.AddressingMessages;
import com.sun.xml.ws.transport.http.client.HttpTransportPipe;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.xml.ws.WebServiceException;

public class WsaServerTube
extends WsaTube {
    private static final String REQUEST_REPLY_TO = "com.sun.xml.ws.addressing.request.replyTo";
    private static final String REQUEST_FAULT_TO = "com.sun.xml.ws.addressing.request.faultTo";

    public WsaServerTube(WSDLPort wsdlPort, WSBinding binding, Tube next) {
        super(wsdlPort, binding, next);
    }

    public WsaServerTube(WsaServerTube that, TubeCloner cloner) {
        super(that, cloner);
    }

    public WsaServerTube copy(TubeCloner cloner) {
        return new WsaServerTube(this, cloner);
    }

    @NotNull
    public NextAction processRequest(Packet request) {
        Packet p;
        HeaderList hl;
        if (this.wsdlPort == null) {
            return this.doInvoke(this.next, request);
        }
        AddressingVersion av = this.binding.getAddressingVersion();
        String replyTo = null;
        String faultTo = null;
        if (request.getMessage() != null && (hl = request.getMessage().getHeaders()) != null) {
            WSEndpointReference epr = hl.getReplyTo(av, this.binding.getSOAPVersion());
            if (epr != null) {
                replyTo = epr.getAddress();
            }
            if ((epr = hl.getFaultTo(av, this.binding.getSOAPVersion())) != null) {
                faultTo = epr.getAddress();
            }
        }
        request.invocationProperties.put(REQUEST_REPLY_TO, replyTo);
        request.invocationProperties.put(REQUEST_FAULT_TO, faultTo);
        if (faultTo == null) {
            if (replyTo != null && (!replyTo.equals(av.getAnonymousUri()) || replyTo.equals(av.getNoneUri())) && request.transportBackChannel != null) {
                request.transportBackChannel.close();
            }
        } else if ((!faultTo.equals(av.getAnonymousUri()) && replyTo != null && !replyTo.equals(av.getAnonymousUri()) || faultTo.equals(av.getNoneUri()) && replyTo != null && replyTo.equals(av.getNoneUri())) && request.transportBackChannel != null) {
            request.transportBackChannel.close();
        }
        if ((p = this.validateInboundHeaders(request)).getMessage() == null) {
            return this.doReturnWith(p);
        }
        if (p.getMessage().isFault()) {
            return this.doReturnWith(this.processFault(p, false));
        }
        if (replyTo != null) {
            if (replyTo.equals(av.getNoneUri()) && (faultTo == null || !faultTo.equals(av.getAnonymousUri()))) {
                return this.doInvoke(this.next, p);
            }
            if (!(replyTo.equals(av.getAnonymousUri()) || faultTo != null && faultTo.equals(av.getAnonymousUri()))) {
                return this.doReturnWith(this.processNonAnonymousReply(p, false, true));
            }
        }
        return this.doInvoke(this.next, p);
    }

    @NotNull
    public NextAction processResponse(Packet response) {
        if (response.getMessage() != null) {
            if (response.getMessage().isFault()) {
                response = this.processFault(response, false);
            } else {
                String uri = this.getResponseAddress(response, false);
                if (!uri.equals(this.binding.getAddressingVersion().getAnonymousUri())) {
                    response = this.processNonAnonymousReply(response, false, false);
                }
            }
        }
        return this.doReturnWith(response);
    }

    private Packet processFault(Packet responsePacket, boolean endpointInvoked) {
        if (responsePacket.getMessage() == null) {
            return responsePacket;
        }
        HeaderList hl = responsePacket.getMessage().getHeaders();
        if (hl == null) {
            return responsePacket;
        }
        AddressingVersion av = this.binding.getAddressingVersion();
        String replyTo = (String)responsePacket.invocationProperties.get(REQUEST_REPLY_TO);
        String faultTo = (String)responsePacket.invocationProperties.get(REQUEST_FAULT_TO);
        if (faultTo == null) {
            if (replyTo != null) {
                if (replyTo.equals(av.getNoneUri())) {
                    if (endpointInvoked) {
                        return responsePacket.createServerResponse(responsePacket.getMessage(), responsePacket.endpoint.getPort(), responsePacket.endpoint.getBinding());
                    }
                } else if (!replyTo.equals(av.getAnonymousUri())) {
                    return this.processNonAnonymousReply(responsePacket, false, endpointInvoked);
                }
            }
        } else if (faultTo.equals(av.getNoneUri())) {
            if (endpointInvoked) {
                responsePacket.setMessage(null);
                return responsePacket;
            }
        } else if (!faultTo.equals(av.getAnonymousUri())) {
            return this.processNonAnonymousReply(responsePacket, true, endpointInvoked);
        }
        return responsePacket;
    }

    private Packet processNonAnonymousReply(Packet packet, boolean isFault, boolean invokeEndpoint) {
        if (packet.transportBackChannel != null) {
            System.out.println(AddressingMessages.NON_ANONYMOUS_RESPONSE());
            packet.transportBackChannel.close();
        }
        String uri = this.getResponseAddress(packet, isFault);
        Packet response = packet;
        if (invokeEndpoint) {
            this.doInvoke(this.next, response);
        }
        if (!uri.startsWith("http")) {
            System.out.println(AddressingMessages.NON_ANONYMOUS_UNKNOWN_PROTOCOL(uri.substring(0, uri.indexOf("://"))));
            return packet;
        }
        System.out.println(AddressingMessages.NON_ANONYMOUS_RESPONSE_SENDING(uri));
        HttpTransportPipe tPipe = new HttpTransportPipe(((BindingImpl)this.binding).createCodec());
        response.endpointAddress = new EndpointAddress(URI.create(uri));
        response = tPipe.process(response);
        if (response != null) {
            Map reqHeaders = (Map)response.invocationProperties.get("javax.xml.ws.http.request.headers");
            if (reqHeaders != null) {
                for (String key : reqHeaders.keySet()) {
                    System.out.print("[" + key + "]: ");
                    for (String value : (List)reqHeaders.get(key)) {
                        System.out.print(value + " ");
                    }
                    System.out.println();
                }
            } else {
                System.out.println(AddressingMessages.NON_ANONYMOUS_RESPONSE_NULL_HEADERS(uri));
            }
        } else {
            System.out.printf(AddressingMessages.NON_ANONYMOUS_RESPONSE_NULL_MESSAGE(uri), new Object[0]);
        }
        return response;
    }

    private String getResponseAddress(Packet packet, boolean isFault) {
        return isFault ? (String)packet.invocationProperties.get(REQUEST_FAULT_TO) : (String)packet.invocationProperties.get(REQUEST_REPLY_TO);
    }

    public void validateAction(Packet packet) {
        WSDLBoundOperation wbo = this.getWSDLBoundOperation(packet);
        if (wbo == null) {
            return;
        }
        WSDLOperation op = wbo.getOperation();
        if (op == null) {
            return;
        }
        String gotA = packet.getMessage().getHeaders().getAction(this.binding.getAddressingVersion(), this.binding.getSOAPVersion());
        if (gotA == null) {
            throw new WebServiceException(AddressingMessages.VALIDATION_SERVER_NULL_ACTION());
        }
        String expected = this.helper.getInputAction(packet);
        String soapAction = this.helper.getSOAPAction(packet);
        if (this.helper.isInputActionDefault(packet) && soapAction != null && !soapAction.equals("")) {
            expected = soapAction;
        }
        if (expected != null && !gotA.equals(expected)) {
            throw new ActionNotSupportedException(gotA);
        }
    }

    protected void checkMandatoryHeaders(boolean foundAction, boolean foundTo) {
        if (!foundAction) {
            throw new MapRequiredException(this.binding.getAddressingVersion().actionTag);
        }
        if (!foundTo) {
            throw new MapRequiredException(this.binding.getAddressingVersion().toTag);
        }
    }
}

