/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.wsdl.parser;

import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.EndpointAddress;
import com.sun.xml.ws.api.model.ParameterBinding;
import com.sun.xml.ws.api.model.wsdl.WSDLDescriptorKind;
import com.sun.xml.ws.api.wsdl.parser.WSDLParserExtension;
import com.sun.xml.ws.model.wsdl.WSDLBoundOperationImpl;
import com.sun.xml.ws.model.wsdl.WSDLBoundPortTypeImpl;
import com.sun.xml.ws.model.wsdl.WSDLFaultImpl;
import com.sun.xml.ws.model.wsdl.WSDLInputImpl;
import com.sun.xml.ws.model.wsdl.WSDLMessageImpl;
import com.sun.xml.ws.model.wsdl.WSDLModelImpl;
import com.sun.xml.ws.model.wsdl.WSDLOperationImpl;
import com.sun.xml.ws.model.wsdl.WSDLOutputImpl;
import com.sun.xml.ws.model.wsdl.WSDLPartDescriptorImpl;
import com.sun.xml.ws.model.wsdl.WSDLPartImpl;
import com.sun.xml.ws.model.wsdl.WSDLPortImpl;
import com.sun.xml.ws.model.wsdl.WSDLPortTypeImpl;
import com.sun.xml.ws.model.wsdl.WSDLServiceImpl;
import com.sun.xml.ws.resources.ClientMessages;
import com.sun.xml.ws.streaming.TidyXMLStreamReader;
import com.sun.xml.ws.streaming.XMLStreamReaderFactory;
import com.sun.xml.ws.streaming.XMLStreamReaderUtil;
import com.sun.xml.ws.util.xml.XmlUtil;
import com.sun.xml.ws.wsdl.parser.EntityResolverWrapper;
import com.sun.xml.ws.wsdl.parser.MIMEConstants;
import com.sun.xml.ws.wsdl.parser.MemberSubmissionAddressingWSDLParserExtension;
import com.sun.xml.ws.wsdl.parser.ParserUtil;
import com.sun.xml.ws.wsdl.parser.SOAPConstants;
import com.sun.xml.ws.wsdl.parser.W3CAddressingWSDLParserExtension;
import com.sun.xml.ws.wsdl.parser.WSDLConstants;
import com.sun.xml.ws.wsdl.parser.WSDLParserExtensionFacade;
import com.sun.xml.ws.wsdl.parser.XMLEntityResolver;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jws.soap.SOAPBinding;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.ws.WebServiceException;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeWSDLParser {
    private static final BitSet errors = new BitSet();
    private static final int NOT_A_WSDL = 0;
    private final WSDLModelImpl wsdlDoc = new WSDLModelImpl();
    private String targetNamespace;
    private final Set<String> importedWSDLs = new HashSet<String>();
    private final XMLEntityResolver resolver;
    private final WSDLParserExtension extension;
    List<WSDLParserExtension> extensionParsers;

    public static WSDLModelImpl parse(URL wsdlLoc, EntityResolver resolver, WSDLParserExtension ... extensions) throws IOException, XMLStreamException, SAXException {
        assert (resolver != null);
        errors.clear();
        RuntimeWSDLParser parser = new RuntimeWSDLParser(new EntityResolverWrapper(resolver), extensions);
        WebServiceException wsdlException = null;
        try {
            parser.parseWSDL(wsdlLoc);
        }
        catch (WebServiceException e) {
            wsdlException = e;
        }
        if (errors.get(0) && wsdlLoc.getProtocol().equals("http") && wsdlLoc.getQuery() == null) {
            String urlString = wsdlLoc.toExternalForm();
            urlString = urlString + "?wsdl";
            wsdlLoc = new URL(urlString);
            errors.clear(0);
            try {
                parser.parseWSDL(wsdlLoc);
            }
            catch (WebServiceException e) {
                wsdlException = e;
            }
        }
        if (errors.get(0) && wsdlException != null) {
            throw wsdlException;
        }
        parser.wsdlDoc.freeze();
        parser.extension.finished(parser.wsdlDoc);
        return parser.wsdlDoc;
    }

    public static WSDLModelImpl parse(XMLEntityResolver.Parser wsdl, XMLEntityResolver resolver, WSDLParserExtension ... extensions) throws IOException, XMLStreamException, SAXException {
        assert (resolver != null);
        RuntimeWSDLParser parser = new RuntimeWSDLParser(resolver, extensions);
        parser.parseWSDL(wsdl);
        parser.wsdlDoc.freeze();
        parser.extension.finished(parser.wsdlDoc);
        parser.extension.postFinished(parser.wsdlDoc);
        return parser.wsdlDoc;
    }

    private RuntimeWSDLParser(XMLEntityResolver resolver, WSDLParserExtension ... extensions) {
        this.resolver = resolver;
        this.extensionParsers = new ArrayList<WSDLParserExtension>();
        this.register(new MemberSubmissionAddressingWSDLParserExtension());
        this.register(new W3CAddressingWSDLParserExtension());
        for (WSDLParserExtension e : extensions) {
            this.register(e);
        }
        this.extension = new WSDLParserExtensionFacade(this.extensionParsers.toArray(new WSDLParserExtension[0]));
    }

    private void parseWSDL(URL wsdlLoc) throws XMLStreamException, IOException, SAXException {
        String systemId = wsdlLoc.toExternalForm();
        XMLEntityResolver.Parser parser = this.resolver.resolveEntity(null, systemId);
        if (parser == null) {
            parser = new XMLEntityResolver.Parser(wsdlLoc, this.createReader(wsdlLoc));
        }
        this.parseWSDL(parser);
    }

    private void parseWSDL(XMLEntityResolver.Parser parser) throws XMLStreamException, IOException, SAXException {
        if (!this.importedWSDLs.add(parser.systemId.toExternalForm())) {
            return;
        }
        XMLStreamReader reader = parser.parser;
        XMLStreamReaderUtil.nextElementContent(reader);
        if (!reader.getName().equals(WSDLConstants.QNAME_DEFINITIONS)) {
            errors.set(0);
            throw new WebServiceException(ClientMessages.RUNTIME_WSDLPARSER_INVALID_WSDL(parser.systemId.toExternalForm(), WSDLConstants.QNAME_DEFINITIONS.toString(), reader.getName().toString(), reader.getLocation()));
        }
        String tns = ParserUtil.getMandatoryNonEmptyAttribute(reader, "targetNamespace");
        String oldTargetNamespace = this.targetNamespace;
        this.targetNamespace = tns;
        while (XMLStreamReaderUtil.nextElementContent(reader) != 2 && reader.getEventType() != 8) {
            QName name = reader.getName();
            if (WSDLConstants.QNAME_IMPORT.equals(name)) {
                this.parseImport(parser.systemId, reader);
                continue;
            }
            if (WSDLConstants.QNAME_MESSAGE.equals(name)) {
                this.parseMessage(reader);
                continue;
            }
            if (WSDLConstants.QNAME_PORT_TYPE.equals(name)) {
                this.parsePortType(reader);
                continue;
            }
            if (WSDLConstants.QNAME_BINDING.equals(name)) {
                this.parseBinding(reader);
                continue;
            }
            if (WSDLConstants.QNAME_SERVICE.equals(name)) {
                this.parseService(reader);
                continue;
            }
            this.extension.definitionsElements(reader);
        }
        this.targetNamespace = oldTargetNamespace;
        reader.close();
    }

    private void parseService(XMLStreamReader reader) {
        String serviceName = ParserUtil.getMandatoryNonEmptyAttribute(reader, "name");
        WSDLServiceImpl service = new WSDLServiceImpl(new QName(this.targetNamespace, serviceName));
        this.extension.serviceAttributes(service, reader);
        while (XMLStreamReaderUtil.nextElementContent(reader) != 2) {
            QName name = reader.getName();
            if (WSDLConstants.QNAME_PORT.equals(name)) {
                this.parsePort(reader, service);
                if (reader.getEventType() == 2) continue;
                XMLStreamReaderUtil.next(reader);
                continue;
            }
            this.extension.serviceElements(service, reader);
        }
        this.wsdlDoc.addService(service);
    }

    private void parsePort(XMLStreamReader reader, WSDLServiceImpl service) {
        String portName = ParserUtil.getMandatoryNonEmptyAttribute(reader, "name");
        String binding = ParserUtil.getMandatoryNonEmptyAttribute(reader, "binding");
        QName bindingName = ParserUtil.getQName(reader, binding);
        QName portQName = new QName(service.getName().getNamespaceURI(), portName);
        WSDLPortImpl port = new WSDLPortImpl(service, portQName, bindingName);
        this.extension.portAttributes(port, reader);
        String location = null;
        while (XMLStreamReaderUtil.nextElementContent(reader) != 2) {
            QName name = reader.getName();
            if (SOAPConstants.QNAME_ADDRESS.equals(name) || SOAPConstants.QNAME_SOAP12ADDRESS.equals(name)) {
                location = ParserUtil.getMandatoryNonEmptyAttribute(reader, "location");
                XMLStreamReaderUtil.next(reader);
                continue;
            }
            this.extension.portElements(port, reader);
        }
        if (location != null) {
            try {
                port.setAddress(new EndpointAddress(location));
            }
            catch (URISyntaxException e) {
                throw new WebServiceException("Malformed URL: " + location, (Throwable)e);
            }
        }
        service.put(portQName, port);
    }

    private void parseBinding(XMLStreamReader reader) {
        String bindingName = ParserUtil.getMandatoryNonEmptyAttribute(reader, "name");
        String portTypeName = ParserUtil.getMandatoryNonEmptyAttribute(reader, "type");
        if (bindingName == null || portTypeName == null) {
            XMLStreamReaderUtil.skipElement(reader);
            return;
        }
        WSDLBoundPortTypeImpl binding = new WSDLBoundPortTypeImpl(this.wsdlDoc, new QName(this.targetNamespace, bindingName), ParserUtil.getQName(reader, portTypeName));
        this.extension.bindingAttributes(binding, reader);
        while (XMLStreamReaderUtil.nextElementContent(reader) != 2) {
            String style;
            QName name = reader.getName();
            if (WSDLConstants.NS_SOAP_BINDING.equals(name)) {
                binding.setBindingId(BindingID.SOAP11_HTTP);
                style = reader.getAttributeValue(null, "style");
                if (style != null && style.equals("rpc")) {
                    binding.setStyle(SOAPBinding.Style.RPC);
                } else {
                    binding.setStyle(SOAPBinding.Style.DOCUMENT);
                }
                XMLStreamReaderUtil.next(reader);
                continue;
            }
            if (WSDLConstants.NS_SOAP12_BINDING.equals(name)) {
                binding.setBindingId(BindingID.SOAP12_HTTP);
                style = reader.getAttributeValue(null, "style");
                if (style != null && style.equals("rpc")) {
                    binding.setStyle(SOAPBinding.Style.RPC);
                } else {
                    binding.setStyle(SOAPBinding.Style.DOCUMENT);
                }
                XMLStreamReaderUtil.next(reader);
                continue;
            }
            if (WSDLConstants.QNAME_OPERATION.equals(name)) {
                this.parseBindingOperation(reader, binding);
                continue;
            }
            this.extension.bindingElements(binding, reader);
        }
    }

    private void parseBindingOperation(XMLStreamReader reader, WSDLBoundPortTypeImpl binding) {
        String bindingOpName = ParserUtil.getMandatoryNonEmptyAttribute(reader, "name");
        if (bindingOpName == null) {
            XMLStreamReaderUtil.skipElement(reader);
            return;
        }
        QName opName = new QName(binding.getPortTypeName().getNamespaceURI(), bindingOpName);
        WSDLBoundOperationImpl bindingOp = new WSDLBoundOperationImpl(binding, opName);
        binding.put(opName, bindingOp);
        this.extension.bindingOperationAttributes(bindingOp, reader);
        while (XMLStreamReaderUtil.nextElementContent(reader) != 2) {
            QName name = reader.getName();
            if (WSDLConstants.QNAME_INPUT.equals(name)) {
                this.parseInputBinding(reader, bindingOp);
                continue;
            }
            if (WSDLConstants.QNAME_OUTPUT.equals(name)) {
                this.parseOutputBinding(reader, bindingOp);
                continue;
            }
            if (WSDLConstants.QNAME_FAULT.equals(name)) {
                this.parseFaultBinding(reader, bindingOp);
                continue;
            }
            if (SOAPConstants.QNAME_OPERATION.equals(name) || SOAPConstants.QNAME_SOAP12OPERATION.equals(name)) {
                String style = reader.getAttributeValue(null, "style");
                if (style != null) {
                    if (style.equals("rpc")) {
                        bindingOp.setStyle(SOAPBinding.Style.RPC);
                    } else {
                        bindingOp.setStyle(SOAPBinding.Style.DOCUMENT);
                    }
                } else {
                    bindingOp.setStyle(binding.getStyle());
                }
                String soapAction = reader.getAttributeValue(null, "soapAction");
                if (soapAction != null) {
                    bindingOp.setSoapAction(soapAction);
                }
                XMLStreamReaderUtil.next(reader);
                continue;
            }
            this.extension.bindingOperationElements(bindingOp, reader);
        }
    }

    private void parseInputBinding(XMLStreamReader reader, WSDLBoundOperationImpl bindingOp) {
        boolean bodyFound = false;
        this.extension.bindingOperationInputAttributes(bindingOp, reader);
        while (XMLStreamReaderUtil.nextElementContent(reader) != 2) {
            QName name = reader.getName();
            if ((SOAPConstants.QNAME_BODY.equals(name) || SOAPConstants.QNAME_SOAP12BODY.equals(name)) && !bodyFound) {
                bodyFound = true;
                bindingOp.setInputExplicitBodyParts(RuntimeWSDLParser.parseSOAPBodyBinding(reader, bindingOp, BindingMode.INPUT));
                RuntimeWSDLParser.goToEnd(reader);
                continue;
            }
            if (SOAPConstants.QNAME_HEADER.equals(name) || SOAPConstants.QNAME_SOAP12HEADER.equals(name)) {
                RuntimeWSDLParser.parseSOAPHeaderBinding(reader, bindingOp.getInputParts());
                continue;
            }
            if (MIMEConstants.QNAME_MULTIPART_RELATED.equals(name)) {
                RuntimeWSDLParser.parseMimeMultipartBinding(reader, bindingOp, BindingMode.INPUT);
                continue;
            }
            this.extension.bindingOperationInputElements(bindingOp, reader);
        }
    }

    private void parseOutputBinding(XMLStreamReader reader, WSDLBoundOperationImpl bindingOp) {
        boolean bodyFound = false;
        this.extension.bindingOperationOutputAttributes(bindingOp, reader);
        while (XMLStreamReaderUtil.nextElementContent(reader) != 2) {
            QName name = reader.getName();
            if ((SOAPConstants.QNAME_BODY.equals(name) || SOAPConstants.QNAME_SOAP12BODY.equals(name)) && !bodyFound) {
                bodyFound = true;
                bindingOp.setOutputExplicitBodyParts(RuntimeWSDLParser.parseSOAPBodyBinding(reader, bindingOp, BindingMode.OUTPUT));
                RuntimeWSDLParser.goToEnd(reader);
                continue;
            }
            if (SOAPConstants.QNAME_HEADER.equals(name) || SOAPConstants.QNAME_SOAP12HEADER.equals(name)) {
                RuntimeWSDLParser.parseSOAPHeaderBinding(reader, bindingOp.getOutputParts());
                continue;
            }
            if (MIMEConstants.QNAME_MULTIPART_RELATED.equals(name)) {
                RuntimeWSDLParser.parseMimeMultipartBinding(reader, bindingOp, BindingMode.OUTPUT);
                continue;
            }
            this.extension.bindingOperationOutputElements(bindingOp, reader);
        }
    }

    private void parseFaultBinding(XMLStreamReader reader, WSDLBoundOperationImpl bindingOp) {
        boolean bodyFound = false;
        this.extension.bindingOperationFaultAttributes(bindingOp, reader);
        while (XMLStreamReaderUtil.nextElementContent(reader) != 2) {
            QName name = reader.getName();
            if ((SOAPConstants.QNAME_BODY.equals(name) || SOAPConstants.QNAME_SOAP12BODY.equals(name)) && !bodyFound) {
                bodyFound = true;
                bindingOp.setFaultExplicitBodyParts(RuntimeWSDLParser.parseSOAPBodyBinding(reader, bindingOp.getFaultParts()));
                RuntimeWSDLParser.goToEnd(reader);
                continue;
            }
            if (SOAPConstants.QNAME_HEADER.equals(name) || SOAPConstants.QNAME_SOAP12HEADER.equals(name)) {
                RuntimeWSDLParser.parseSOAPHeaderBinding(reader, bindingOp.getFaultParts());
                continue;
            }
            if (MIMEConstants.QNAME_MULTIPART_RELATED.equals(name)) {
                RuntimeWSDLParser.parseMimeMultipartBinding(reader, bindingOp, BindingMode.FAULT);
                continue;
            }
            this.extension.bindingOperationFaultElements(bindingOp, reader);
        }
    }

    private static boolean parseSOAPBodyBinding(XMLStreamReader reader, WSDLBoundOperationImpl op, BindingMode mode) {
        String namespace = reader.getAttributeValue(null, "namespace");
        if (mode == BindingMode.INPUT) {
            op.setRequestNamespace(namespace);
            return RuntimeWSDLParser.parseSOAPBodyBinding(reader, op.getInputParts());
        }
        op.setResponseNamespace(namespace);
        return RuntimeWSDLParser.parseSOAPBodyBinding(reader, op.getOutputParts());
    }

    private static boolean parseSOAPBodyBinding(XMLStreamReader reader, Map<String, ParameterBinding> parts) {
        String partsString = reader.getAttributeValue(null, "parts");
        if (partsString != null) {
            List<String> partsList = XmlUtil.parseTokenList(partsString);
            if (partsList.isEmpty()) {
                parts.put(" ", ParameterBinding.BODY);
            } else {
                for (String part : partsList) {
                    parts.put(part, ParameterBinding.BODY);
                }
            }
            return true;
        }
        return false;
    }

    private static void parseSOAPHeaderBinding(XMLStreamReader reader, Map<String, ParameterBinding> parts) {
        String part = reader.getAttributeValue(null, "part");
        if (part == null || part.equals("")) {
            return;
        }
        parts.put(part, ParameterBinding.HEADER);
        RuntimeWSDLParser.goToEnd(reader);
    }

    private static void parseMimeMultipartBinding(XMLStreamReader reader, WSDLBoundOperationImpl op, BindingMode mode) {
        while (XMLStreamReaderUtil.nextElementContent(reader) != 2) {
            QName name = reader.getName();
            if (MIMEConstants.QNAME_PART.equals(name)) {
                RuntimeWSDLParser.parseMIMEPart(reader, op, mode);
                continue;
            }
            XMLStreamReaderUtil.skipElement(reader);
        }
    }

    private static void parseMIMEPart(XMLStreamReader reader, WSDLBoundOperationImpl op, BindingMode mode) {
        boolean bodyFound = false;
        Map<String, ParameterBinding> parts = null;
        if (mode == BindingMode.INPUT) {
            parts = op.getInputParts();
        } else if (mode == BindingMode.OUTPUT) {
            parts = op.getOutputParts();
        } else if (mode == BindingMode.FAULT) {
            parts = op.getFaultParts();
        }
        while (XMLStreamReaderUtil.nextElementContent(reader) != 2) {
            QName name = reader.getName();
            if (SOAPConstants.QNAME_BODY.equals(name) && !bodyFound) {
                bodyFound = true;
                RuntimeWSDLParser.parseSOAPBodyBinding(reader, op, mode);
                XMLStreamReaderUtil.next(reader);
                continue;
            }
            if (SOAPConstants.QNAME_HEADER.equals(name)) {
                bodyFound = true;
                RuntimeWSDLParser.parseSOAPHeaderBinding(reader, parts);
                XMLStreamReaderUtil.next(reader);
                continue;
            }
            if (MIMEConstants.QNAME_CONTENT.equals(name)) {
                String part = reader.getAttributeValue(null, "part");
                String type = reader.getAttributeValue(null, "type");
                if (part == null || type == null) {
                    XMLStreamReaderUtil.skipElement(reader);
                    continue;
                }
                ParameterBinding sb = ParameterBinding.createAttachment(type);
                if (sb != null) {
                    parts.put(part, sb);
                }
                XMLStreamReaderUtil.next(reader);
                continue;
            }
            XMLStreamReaderUtil.skipElement(reader);
        }
    }

    protected void parseImport(URL baseURL, XMLStreamReader reader) throws IOException, SAXException, XMLStreamException {
        String importLocation = ParserUtil.getMandatoryNonEmptyAttribute(reader, "location");
        URL importURL = new URL(baseURL, importLocation);
        this.parseWSDL(importURL);
        while (XMLStreamReaderUtil.nextElementContent(reader) != 2) {
            XMLStreamReaderUtil.skipElement(reader);
        }
    }

    private void parsePortType(XMLStreamReader reader) {
        String portTypeName = ParserUtil.getMandatoryNonEmptyAttribute(reader, "name");
        if (portTypeName == null) {
            XMLStreamReaderUtil.skipElement(reader);
            return;
        }
        WSDLPortTypeImpl portType = new WSDLPortTypeImpl(this.wsdlDoc, new QName(this.targetNamespace, portTypeName));
        this.extension.portTypeAttributes(portType, reader);
        this.wsdlDoc.addPortType(portType);
        while (XMLStreamReaderUtil.nextElementContent(reader) != 2) {
            QName name = reader.getName();
            if (WSDLConstants.QNAME_OPERATION.equals(name)) {
                this.parsePortTypeOperation(reader, portType);
                continue;
            }
            this.extension.portTypeElements(portType, reader);
        }
    }

    private void parsePortTypeOperation(XMLStreamReader reader, WSDLPortTypeImpl portType) {
        String operationName = ParserUtil.getMandatoryNonEmptyAttribute(reader, "name");
        if (operationName == null) {
            XMLStreamReaderUtil.skipElement(reader);
            return;
        }
        QName operationQName = new QName(portType.getName().getNamespaceURI(), operationName);
        WSDLOperationImpl operation = new WSDLOperationImpl(portType, operationQName);
        this.extension.portTypeOperationAttributes(operation, reader);
        String parameterOrder = ParserUtil.getAttribute(reader, "parameterOrder");
        operation.setParameterOrder(parameterOrder);
        portType.put(operationName, operation);
        while (XMLStreamReaderUtil.nextElementContent(reader) != 2) {
            QName name = reader.getName();
            if (name.equals(WSDLConstants.QNAME_INPUT)) {
                this.parsePortTypeOperationInput(reader, operation);
                continue;
            }
            if (name.equals(WSDLConstants.QNAME_OUTPUT)) {
                this.parsePortTypeOperationOutput(reader, operation);
                continue;
            }
            if (name.equals(WSDLConstants.QNAME_FAULT)) {
                this.parsePortTypeOperationFault(reader, operation);
                continue;
            }
            this.extension.portTypeOperationElements(operation, reader);
        }
    }

    private void parsePortTypeOperationFault(XMLStreamReader reader, WSDLOperationImpl operation) {
        String msg = ParserUtil.getMandatoryNonEmptyAttribute(reader, "message");
        QName msgName = ParserUtil.getQName(reader, msg);
        String name = ParserUtil.getMandatoryNonEmptyAttribute(reader, "name");
        WSDLFaultImpl fault = new WSDLFaultImpl(name, msgName);
        operation.addFault(fault);
        this.extension.portTypeOperationFaultAttributes(fault, reader);
        this.extension.portTypeOperationFault(operation, reader);
        while (XMLStreamReaderUtil.nextElementContent(reader) != 2) {
            this.extension.portTypeOperationFaultElements(fault, reader);
        }
    }

    private void parsePortTypeOperationInput(XMLStreamReader reader, WSDLOperationImpl operation) {
        String msg = ParserUtil.getMandatoryNonEmptyAttribute(reader, "message");
        QName msgName = ParserUtil.getQName(reader, msg);
        String name = ParserUtil.getAttribute(reader, "name");
        WSDLInputImpl input = new WSDLInputImpl(name, msgName, operation);
        operation.setInput(input);
        this.extension.portTypeOperationInputAttributes(input, reader);
        this.extension.portTypeOperationInput(operation, reader);
        while (XMLStreamReaderUtil.nextElementContent(reader) != 2) {
            this.extension.portTypeOperationInputElements(input, reader);
        }
    }

    private void parsePortTypeOperationOutput(XMLStreamReader reader, WSDLOperationImpl operation) {
        String msg = ParserUtil.getAttribute(reader, "message");
        QName msgName = ParserUtil.getQName(reader, msg);
        String name = ParserUtil.getAttribute(reader, "name");
        WSDLOutputImpl output = new WSDLOutputImpl(name, msgName, operation);
        operation.setOutput(output);
        this.extension.portTypeOperationOutputAttributes(output, reader);
        this.extension.portTypeOperationOutput(operation, reader);
        while (XMLStreamReaderUtil.nextElementContent(reader) != 2) {
            this.extension.portTypeOperationOutputElements(output, reader);
        }
    }

    private void parseMessage(XMLStreamReader reader) {
        String msgName = ParserUtil.getMandatoryNonEmptyAttribute(reader, "name");
        WSDLMessageImpl msg = new WSDLMessageImpl(new QName(this.targetNamespace, msgName));
        this.extension.messageAttributes(msg, reader);
        int partIndex = 0;
        while (XMLStreamReaderUtil.nextElementContent(reader) != 2) {
            QName name = reader.getName();
            if (WSDLConstants.QNAME_PART.equals(name)) {
                String part = ParserUtil.getMandatoryNonEmptyAttribute(reader, "name");
                String desc = null;
                int index = reader.getAttributeCount();
                WSDLDescriptorKind kind = WSDLDescriptorKind.ELEMENT;
                for (int i = 0; i < index; ++i) {
                    QName descName = reader.getAttributeName(i);
                    if (descName.getLocalPart().equals("element")) {
                        kind = WSDLDescriptorKind.ELEMENT;
                    } else if (descName.getLocalPart().equals("TYPE")) {
                        kind = WSDLDescriptorKind.TYPE;
                    }
                    if (!descName.getLocalPart().equals("element") && !descName.getLocalPart().equals("type")) continue;
                    desc = reader.getAttributeValue(i);
                    break;
                }
                if (desc == null) continue;
                WSDLPartImpl wsdlPart = new WSDLPartImpl(part, partIndex, new WSDLPartDescriptorImpl(ParserUtil.getQName(reader, desc), kind));
                msg.add(wsdlPart);
                if (reader.getEventType() == 2) continue;
                RuntimeWSDLParser.goToEnd(reader);
                continue;
            }
            this.extension.messageElements(msg, reader);
        }
        this.wsdlDoc.addMessage(msg);
        if (reader.getEventType() != 2) {
            RuntimeWSDLParser.goToEnd(reader);
        }
    }

    private static void goToEnd(XMLStreamReader reader) {
        while (XMLStreamReaderUtil.nextElementContent(reader) != 2) {
            XMLStreamReaderUtil.skipElement(reader);
        }
    }

    private XMLStreamReader createReader(URL wsdlLoc) throws IOException {
        InputStream stream = wsdlLoc.openStream();
        return new TidyXMLStreamReader(XMLStreamReaderFactory.createFreshXMLStreamReader(wsdlLoc.toExternalForm(), stream), stream);
    }

    private void register(WSDLParserExtension e) {
        this.extensionParsers.add(e);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum BindingMode {
        INPUT,
        OUTPUT,
        FAULT;

    }
}

