/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.http.servlet;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.server.WebServiceContextDelegate;
import com.sun.xml.ws.transport.Headers;
import com.sun.xml.ws.transport.http.WSHTTPConnection;
import com.sun.xml.ws.transport.http.servlet.ServletAdapter;
import com.sun.xml.ws.util.PropertySet;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ServletConnectionImpl
extends WSHTTPConnection
implements WebServiceContextDelegate {
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final ServletContext context;
    private int status;
    private Headers requestHeaders;
    private Map<String, List<String>> responseHeaders;
    private static final PropertySet.PropertyMap model = ServletConnectionImpl.parse(ServletConnectionImpl.class);

    public ServletConnectionImpl(ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        this.context = context;
        this.request = request;
        this.response = response;
    }

    @Override
    @PropertySet.Property(value="javax.xml.ws.http.request.headers")
    @NotNull
    public Map<String, List<String>> getRequestHeaders() {
        if (this.requestHeaders == null) {
            this.requestHeaders = new Headers();
            Enumeration enums = this.request.getHeaderNames();
            while (enums.hasMoreElements()) {
                String headerName = (String)enums.nextElement();
                String headerValue = this.request.getHeader(headerName);
                ArrayList<String> values = this.requestHeaders.get(headerName);
                if (values == null) {
                    values = new ArrayList<String>();
                    this.requestHeaders.put(headerName, (List<String>)values);
                }
                values.add(headerValue);
            }
        }
        return this.requestHeaders;
    }

    @Override
    public void setResponseHeaders(Map<String, List<String>> headers) {
        this.responseHeaders = headers;
        if (headers == null) {
            return;
        }
        if (this.status != 0) {
            this.response.setStatus(this.status);
        }
        this.response.reset();
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            String name = entry.getKey();
            for (String value : entry.getValue()) {
                this.response.addHeader(name, value);
            }
        }
    }

    @PropertySet.Property(value="javax.xml.ws.http.response.headers")
    public Map<String, List<String>> getResponseHeaders() {
        return this.responseHeaders;
    }

    @Override
    public void setStatus(int status) {
        this.status = status;
    }

    @Override
    @PropertySet.Property(value="javax.xml.ws.http.response.code")
    public int getStatus() {
        return this.status;
    }

    @Override
    public void setContentTypeResponseHeader(@NotNull String value) {
        this.response.setContentType(value);
    }

    @Override
    @NotNull
    public InputStream getInput() throws IOException {
        return this.request.getInputStream();
    }

    @Override
    @NotNull
    public OutputStream getOutput() throws IOException {
        this.response.setStatus(this.status);
        return this.response.getOutputStream();
    }

    @Override
    @NotNull
    public WebServiceContextDelegate getWebServiceContextDelegate() {
        return this;
    }

    @Override
    public Principal getUserPrincipal(Packet p) {
        return this.request.getUserPrincipal();
    }

    @Override
    public boolean isUserInRole(Packet p, String role) {
        return this.request.isUserInRole(role);
    }

    @Override
    public String getEPRAddress(Packet p) {
        return ServletAdapter.getBaseAddress(this.request) + this.request.getServletPath();
    }

    @Override
    @PropertySet.Property(value="javax.xml.ws.http.request.method")
    @NotNull
    public String getRequestMethod() {
        return this.request.getMethod();
    }

    @Override
    public String getRequestHeader(String headerName) {
        return this.request.getHeader(headerName);
    }

    @Override
    @PropertySet.Property(value="javax.xml.ws.http.request.querystring")
    public String getQueryString() {
        return this.request.getQueryString();
    }

    @Override
    @PropertySet.Property(value="javax.xml.ws.http.request.pathinfo")
    @NotNull
    public String getPathInfo() {
        return this.request.getPathInfo();
    }

    @PropertySet.Property(value="javax.xml.ws.servlet.context")
    public ServletContext getContext() {
        return this.context;
    }

    @PropertySet.Property(value="javax.xml.ws.servlet.response")
    public HttpServletResponse getResponse() {
        return this.response;
    }

    @PropertySet.Property(value="javax.xml.ws.servlet.request")
    public HttpServletRequest getRequest() {
        return this.request;
    }

    @Override
    protected PropertySet.PropertyMap getPropertyMap() {
        return model;
    }
}

