/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport;

import com.sun.xml.ws.api.EndpointAddress;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.ClientPipeAssemblerContext;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.api.pipe.PipeCloner;
import com.sun.xml.ws.api.pipe.TransportPipeFactory;

public final class DeferredTransportPipe
implements Pipe {
    private Pipe transport;
    private EndpointAddress address;
    private final ClassLoader classLoader;
    private final ClientPipeAssemblerContext context;

    public DeferredTransportPipe(ClassLoader classLoader, ClientPipeAssemblerContext context) {
        this.classLoader = classLoader;
        this.context = context;
    }

    public Packet process(Packet request) {
        if (request.endpointAddress == this.address) {
            return this.transport.process(request);
        }
        if (this.transport != null) {
            this.transport.preDestroy();
            this.transport = null;
            this.address = null;
        }
        ClientPipeAssemblerContext newContext = new ClientPipeAssemblerContext(request.endpointAddress, this.context.getWsdlModel(), this.context.getService(), this.context.getBinding());
        this.address = request.endpointAddress;
        this.transport = TransportPipeFactory.create(this.classLoader, newContext);
        assert (this.transport != null);
        return this.transport.process(request);
    }

    public void preDestroy() {
        if (this.transport != null) {
            this.transport.preDestroy();
            this.transport = null;
            this.address = null;
        }
    }

    public Pipe copy(PipeCloner cloner) {
        DeferredTransportPipe copy = new DeferredTransportPipe(this.classLoader, this.context);
        cloner.add(this, copy);
        if (this.transport != null) {
            copy.transport = cloner.copy(this.transport);
            copy.address = this.address;
        }
        return copy;
    }
}

