/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.streaming;

import com.sun.xml.ws.util.exception.XMLStreamException2;
import com.sun.xml.ws.util.xml.DummyLocation;
import com.sun.xml.ws.util.xml.XmlUtil;
import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

public class DOMStreamReader
implements XMLStreamReader,
NamespaceContext {
    Node _current;
    Node _start;
    NamedNodeMap _namedNodeMap;
    List<Attr> _currentAttributes = new ArrayList<Attr>();
    List<Attr> _currentNamespaces = new ArrayList<Attr>();
    boolean _needAttributesSplit;
    int _state;

    public DOMStreamReader() {
    }

    public DOMStreamReader(Node node) {
        this.setCurrentNode(node);
    }

    public void setCurrentNode(Node node) {
        this._start = this._current = node;
        this._state = 7;
    }

    public void close() throws XMLStreamException {
    }

    private void splitAttributes() {
        if (!this._needAttributesSplit) {
            return;
        }
        this._currentAttributes.clear();
        this._currentNamespaces.clear();
        this._namedNodeMap = this._current.getAttributes();
        if (this._namedNodeMap != null) {
            int n = this._namedNodeMap.getLength();
            for (int i = 0; i < n; ++i) {
                Attr attr = (Attr)this._namedNodeMap.item(i);
                String attrName = attr.getNodeName();
                if (attrName.startsWith("xmlns:") || attrName.equals("xmlns")) {
                    this._currentNamespaces.add(attr);
                    continue;
                }
                this._currentAttributes.add(attr);
            }
        }
        this._needAttributesSplit = false;
    }

    public int getAttributeCount() {
        if (this._state == 1) {
            this.splitAttributes();
            return this._currentAttributes.size();
        }
        throw new IllegalStateException("DOMStreamReader: getAttributeCount() called in illegal state");
    }

    public String getAttributeLocalName(int index) {
        if (this._state == 1) {
            this.splitAttributes();
            String localName = this._currentAttributes.get(index).getLocalName();
            return localName != null ? localName : QName.valueOf(this._currentAttributes.get(index).getNodeName()).getLocalPart();
        }
        throw new IllegalStateException("DOMStreamReader: getAttributeLocalName() called in illegal state");
    }

    public QName getAttributeName(int index) {
        if (this._state == 1) {
            this.splitAttributes();
            Node attr = this._currentAttributes.get(index);
            String localName = attr.getLocalName();
            if (localName != null) {
                String prefix = attr.getPrefix();
                String uri = attr.getNamespaceURI();
                return new QName(uri != null ? uri : "", localName, prefix != null ? prefix : "");
            }
            return QName.valueOf(attr.getNodeName());
        }
        throw new IllegalStateException("DOMStreamReader: getAttributeName() called in illegal state");
    }

    public String getAttributeNamespace(int index) {
        if (this._state == 1) {
            this.splitAttributes();
            String uri = this._currentAttributes.get(index).getNamespaceURI();
            return uri != null ? uri : "";
        }
        throw new IllegalStateException("DOMStreamReader: getAttributeNamespace() called in illegal state");
    }

    public String getAttributePrefix(int index) {
        if (this._state == 1) {
            this.splitAttributes();
            String prefix = this._currentAttributes.get(index).getPrefix();
            return prefix != null ? prefix : "";
        }
        throw new IllegalStateException("DOMStreamReader: getAttributePrefix() called in illegal state");
    }

    public String getAttributeType(int index) {
        if (this._state == 1) {
            return "CDATA";
        }
        throw new IllegalStateException("DOMStreamReader: getAttributeType() called in illegal state");
    }

    public String getAttributeValue(int index) {
        if (this._state == 1) {
            this.splitAttributes();
            return this._currentAttributes.get(index).getNodeValue();
        }
        throw new IllegalStateException("DOMStreamReader: getAttributeValue() called in illegal state");
    }

    public String getAttributeValue(String namespaceURI, String localName) {
        if (this._state == 1) {
            this.splitAttributes();
            if (this._namedNodeMap != null) {
                Node attr = this._namedNodeMap.getNamedItemNS(namespaceURI, localName);
                return attr != null ? attr.getNodeValue() : null;
            }
            return null;
        }
        throw new IllegalStateException("DOMStreamReader: getAttributeValue() called in illegal state");
    }

    public String getCharacterEncodingScheme() {
        return null;
    }

    public String getElementText() throws XMLStreamException {
        throw new RuntimeException("DOMStreamReader: getElementText() not implemented");
    }

    public String getEncoding() {
        return null;
    }

    public int getEventType() {
        return this._state;
    }

    public String getLocalName() {
        if (this._state == 1 || this._state == 2) {
            String localName = this._current.getLocalName();
            return localName != null ? localName : QName.valueOf(this._current.getNodeName()).getLocalPart();
        }
        if (this._state == 9) {
            return this._current.getNodeName();
        }
        throw new IllegalStateException("DOMStreamReader: getAttributeValue() called in illegal state");
    }

    public Location getLocation() {
        return DummyLocation.INSTANCE;
    }

    public QName getName() {
        if (this._state == 1 || this._state == 2) {
            String localName = this._current.getLocalName();
            if (localName != null) {
                String prefix = this._current.getPrefix();
                String uri = this._current.getNamespaceURI();
                return new QName(uri != null ? uri : "", localName, prefix != null ? prefix : "");
            }
            return QName.valueOf(this._current.getNodeName());
        }
        throw new IllegalStateException("DOMStreamReader: getName() called in illegal state");
    }

    public NamespaceContext getNamespaceContext() {
        return this;
    }

    public int getNamespaceCount() {
        if (this._state == 1 || this._state == 2) {
            this.splitAttributes();
            return this._currentNamespaces.size();
        }
        throw new IllegalStateException("DOMStreamReader: getNamespaceCount() called in illegal state");
    }

    public String getNamespacePrefix(int index) {
        if (this._state == 1 || this._state == 2) {
            this.splitAttributes();
            Attr attr = this._currentNamespaces.get(index);
            String result = attr.getLocalName();
            if (result == null) {
                result = QName.valueOf(attr.getNodeName()).getLocalPart();
            }
            return result.equals("xmlns") ? null : result;
        }
        throw new IllegalStateException("DOMStreamReader: getNamespacePrefix() called in illegal state");
    }

    public String getNamespaceURI() {
        if (this._state == 1 || this._state == 2) {
            String uri = this._current.getNamespaceURI();
            return uri != null ? uri : "";
        }
        return null;
    }

    public String getNamespaceURI(int index) {
        if (this._state == 1 || this._state == 2) {
            this.splitAttributes();
            return this._currentNamespaces.get(index).getValue();
        }
        throw new IllegalStateException("DOMStreamReader: getNamespaceURI(int) called in illegal state");
    }

    public String getNamespaceURI(String prefix) {
        boolean isDefault;
        short type;
        if (prefix == null) {
            throw new IllegalArgumentException("DOMStreamReader: getNamespaceURI(String) call with a null prefix");
        }
        if (prefix.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (prefix.equals("xmlns")) {
            return "http://www.w3.org/2000/xmlns/";
        }
        Node node = this._current;
        while ((type = node.getNodeType()) != 9 && type != 1) {
            node = node.getParentNode();
        }
        boolean bl = isDefault = prefix.length() == 0;
        while (node.getNodeType() != 9) {
            Attr attr;
            NamedNodeMap namedNodeMap = node.getAttributes();
            Attr attr2 = attr = isDefault ? (Attr)namedNodeMap.getNamedItem("xmlns") : (Attr)namedNodeMap.getNamedItem("xmlns:" + prefix);
            if (attr != null) {
                return attr.getValue();
            }
            node = node.getParentNode();
        }
        return null;
    }

    public String getPrefix(String nsUri) {
        short type;
        if (nsUri == null) {
            throw new IllegalArgumentException("DOMStreamReader: getPrefix(String) call with a null namespace URI");
        }
        if (nsUri.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        if (nsUri.equals("http://www.w3.org/2000/xmlns/")) {
            return "xmlns";
        }
        Node node = this._current;
        while ((type = node.getNodeType()) != 9 && type != 1) {
            node = node.getParentNode();
        }
        while (node.getNodeType() != 9) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            for (int i = namedNodeMap.getLength() - 1; i >= 0; --i) {
                Attr attr = (Attr)namedNodeMap.item(i);
                String attrName = attr.getNodeName();
                if (!attrName.startsWith("xmlns:") && !attrName.equals("xmlns") || !attr.getValue().equals(nsUri)) continue;
                if (attrName.equals("xmlns")) {
                    return "";
                }
                String localName = attr.getLocalName();
                return localName != null ? localName : QName.valueOf(attrName).getLocalPart();
            }
            node = node.getParentNode();
        }
        return null;
    }

    public Iterator getPrefixes(String nsUri) {
        String prefix = this.getPrefix(nsUri);
        if (prefix == null) {
            return Collections.emptyList().iterator();
        }
        return Collections.singletonList(prefix).iterator();
    }

    public String getPIData() {
        if (this._state == 3) {
            return ((ProcessingInstruction)this._current).getData();
        }
        return null;
    }

    public String getPITarget() {
        if (this._state == 3) {
            return ((ProcessingInstruction)this._current).getTarget();
        }
        return null;
    }

    public String getPrefix() {
        if (this._state == 1 || this._state == 2) {
            String prefix = this._current.getPrefix();
            return prefix != null ? prefix : "";
        }
        return null;
    }

    public Object getProperty(String str) throws IllegalArgumentException {
        return null;
    }

    public String getText() {
        if (this._state == 4 || this._state == 12 || this._state == 5 || this._state == 9) {
            return this._current.getNodeValue();
        }
        throw new IllegalStateException("DOMStreamReader: getTextLength() called in illegal state");
    }

    public char[] getTextCharacters() {
        return this.getText().toCharArray();
    }

    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int targetLength) throws XMLStreamException {
        char[] text = this.getTextCharacters();
        System.arraycopy(text, sourceStart, target, targetStart, targetLength);
        return Math.min(targetLength, text.length - sourceStart);
    }

    public int getTextLength() {
        if (this._state == 4 || this._state == 12 || this._state == 5 || this._state == 9) {
            return this._current.getNodeValue().length();
        }
        throw new IllegalStateException("DOMStreamReader: getTextLength() called in illegal state");
    }

    public int getTextStart() {
        if (this._state == 4 || this._state == 12 || this._state == 5 || this._state == 9) {
            return 0;
        }
        throw new IllegalStateException("DOMStreamReader: getTextStart() called in illegal state");
    }

    public String getVersion() {
        return null;
    }

    public boolean hasName() {
        return this._state == 1 || this._state == 2;
    }

    public boolean hasNext() throws XMLStreamException {
        return this._state != 8;
    }

    public boolean hasText() {
        if (this._state == 4 || this._state == 12 || this._state == 5 || this._state == 9) {
            return this._current.getNodeValue().trim().length() > 0;
        }
        return false;
    }

    public boolean isAttributeSpecified(int param) {
        return false;
    }

    public boolean isCharacters() {
        return this._state == 4;
    }

    public boolean isEndElement() {
        return this._state == 2;
    }

    public boolean isStandalone() {
        return true;
    }

    public boolean isStartElement() {
        return this._state == 1;
    }

    public boolean isWhiteSpace() {
        short nodeType = this._current.getNodeType();
        if (nodeType == 3 || nodeType == 4) {
            return this._current.getNodeValue().trim().length() == 0;
        }
        return false;
    }

    private static int mapNodeTypeToState(int nodetype) {
        switch (nodetype) {
            case 4: {
                return 12;
            }
            case 8: {
                return 5;
            }
            case 1: {
                return 1;
            }
            case 6: {
                return 15;
            }
            case 5: {
                return 9;
            }
            case 12: {
                return 14;
            }
            case 7: {
                return 3;
            }
            case 3: {
                return 4;
            }
        }
        throw new RuntimeException("DOMStreamReader: Unexpected node type");
    }

    public int next() throws XMLStreamException {
        this._needAttributesSplit = true;
        switch (this._state) {
            case 8: {
                throw new IllegalStateException("DOMStreamReader: Calling next() at END_DOCUMENT");
            }
            case 7: {
                if (this._current.getNodeType() == 1) {
                    this._state = 1;
                    return 1;
                }
                Node child = this._current.getFirstChild();
                if (child == null) {
                    this._state = 8;
                    return 8;
                }
                this._current = child;
                this._state = DOMStreamReader.mapNodeTypeToState(this._current.getNodeType());
                return this._state;
            }
            case 1: {
                this._current.normalize();
                Node child = this._current.getFirstChild();
                if (child == null) {
                    this._state = 2;
                    return 2;
                }
                this._current = child;
                this._state = DOMStreamReader.mapNodeTypeToState(this._current.getNodeType());
                return this._state;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 12: {
                if (this._current == this._start) {
                    this._state = 8;
                    return 8;
                }
                Node sibling = this._current.getNextSibling();
                if (sibling == null) {
                    this._current = this._current.getParentNode();
                    this._state = this._current == null || this._current.getNodeType() == 9 ? 8 : 2;
                    return this._state;
                }
                this._current = sibling;
                this._state = DOMStreamReader.mapNodeTypeToState(this._current.getNodeType());
                return this._state;
            }
        }
        throw new RuntimeException("DOMStreamReader: Unexpected internal state");
    }

    public int nextTag() throws XMLStreamException {
        int eventType = this.next();
        while (eventType == 4 && this.isWhiteSpace() || eventType == 12 && this.isWhiteSpace() || eventType == 6 || eventType == 3 || eventType == 5) {
            eventType = this.next();
        }
        if (eventType != 1 && eventType != 2) {
            throw new XMLStreamException2("DOMStreamReader: Expected start or end tag");
        }
        return eventType;
    }

    public void require(int type, String namespaceURI, String localName) throws XMLStreamException {
        if (type != this._state) {
            throw new XMLStreamException2("DOMStreamReader: Required event type not found");
        }
        if (namespaceURI != null && !namespaceURI.equals(this.getNamespaceURI())) {
            throw new XMLStreamException2("DOMStreamReader: Required namespaceURI not found");
        }
        if (localName != null && !localName.equals(this.getLocalName())) {
            throw new XMLStreamException2("DOMStreamReader: Required localName not found");
        }
    }

    public boolean standaloneSet() {
        return true;
    }

    private static void displayDOM(Node node, OutputStream ostream) {
        try {
            System.out.println("\n====\n");
            XmlUtil.newTransformer().transform(new DOMSource(node), new StreamResult(ostream));
            System.out.println("\n====\n");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void verifyDOMIntegrity(Node node) {
        switch (node.getNodeType()) {
            case 1: 
            case 2: {
                if (node.getLocalName() == null) {
                    System.out.println("WARNING: DOM level 1 node found");
                    System.out.println(" -> node.getNodeName() = " + node.getNodeName());
                    System.out.println(" -> node.getNamespaceURI() = " + node.getNamespaceURI());
                    System.out.println(" -> node.getLocalName() = " + node.getLocalName());
                    System.out.println(" -> node.getPrefix() = " + node.getPrefix());
                }
                if (node.getNodeType() == 2) {
                    return;
                }
                NamedNodeMap attrs = ((Element)node).getAttributes();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    DOMStreamReader.verifyDOMIntegrity(attrs.item(i));
                }
            }
            case 9: {
                NodeList children = node.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    DOMStreamReader.verifyDOMIntegrity(children.item(i));
                }
                break;
            }
        }
    }

    public static void main(String[] args) throws Exception {
        String sample = "<?xml version='1.0' encoding='UTF-8'?><env:Envelope xmlns:env='http://schemas.xmlsoap.org/soap/envelope/'><env:Body><env:Fault><faultcode>env:Server</faultcode><faultstring>Internal server error</faultstring></env:Fault></env:Body></env:Envelope>";
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document dd = db.parse(new ByteArrayInputStream(sample.getBytes("UTF-8")));
        DOMStreamReader dsr = new DOMStreamReader(dd);
        while (dsr.hasNext()) {
            System.out.println("dsr.next() = " + dsr.next());
            if (dsr.getEventType() != 1 && dsr.getEventType() != 2) continue;
            System.out.println("dsr.getName = " + dsr.getName());
            if (dsr.getEventType() != 1) continue;
            System.out.println("dsr.getAttributeCount() = " + dsr.getAttributeCount());
        }
    }
}

