/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.server.sei;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.server.Invoker;
import com.sun.xml.ws.encoding.soap.SOAP12Constants;
import com.sun.xml.ws.encoding.soap.SOAPConstants;
import com.sun.xml.ws.fault.SOAPFaultBuilder;
import com.sun.xml.ws.model.AbstractSEIModelImpl;
import com.sun.xml.ws.model.JavaMethodImpl;
import com.sun.xml.ws.server.InvokerPipe;
import com.sun.xml.ws.server.sei.EndpointMethodHandler;
import com.sun.xml.ws.util.QNameMap;
import javax.xml.namespace.QName;

public class SEIInvokerPipe
extends InvokerPipe {
    private final QNameMap<EndpointMethodHandler> methodHandlers;
    private static final String EMPTY_PAYLOAD_LOCAL = "";
    private static final String EMPTY_PAYLOAD_NSURI = "";
    private final SOAPVersion soapVersion;

    public SEIInvokerPipe(AbstractSEIModelImpl model, Invoker invoker, WSBinding binding) {
        super(invoker);
        this.soapVersion = binding.getSOAPVersion();
        this.methodHandlers = new QNameMap();
        for (JavaMethodImpl m : model.getJavaMethods()) {
            EndpointMethodHandler handler = new EndpointMethodHandler(this, model, m, binding);
            QName payloadName = model.getQNameForJM(m);
            this.methodHandlers.put(payloadName.getNamespaceURI(), payloadName.getLocalPart(), handler);
        }
    }

    public Packet process(Packet req) {
        Packet res;
        String nsUri;
        Message msg = req.getMessage();
        String localPart = msg.getPayloadLocalPart();
        if (localPart == null) {
            localPart = "";
            nsUri = "";
        } else {
            nsUri = msg.getPayloadNamespaceURI();
        }
        EndpointMethodHandler handler = this.methodHandlers.get(nsUri, localPart);
        if (handler == null) {
            String faultString = "Cannot find dispatch method for {" + nsUri + "}" + localPart;
            QName faultCode = this.soapVersion == SOAPVersion.SOAP_11 ? SOAPConstants.FAULT_CODE_CLIENT : SOAP12Constants.FAULT_CODE_CLIENT;
            Message faultMsg = SOAPFaultBuilder.createSOAPFaultMessage(this.soapVersion, faultString, faultCode);
            res = req.createResponse(faultMsg);
        } else {
            res = handler.invoke(req);
        }
        return res;
    }
}

