/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.server.provider;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.server.Invoker;
import com.sun.xml.ws.fault.SOAPFaultBuilder;
import com.sun.xml.ws.server.provider.ProviderEndpointModel;
import com.sun.xml.ws.server.provider.ProviderInvokerPipe;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;

public class SOAPProviderInvokerPipe
extends ProviderInvokerPipe {
    private final SOAPVersion soapVersion;

    public SOAPProviderInvokerPipe(Invoker invoker, ProviderEndpointModel model, SOAPVersion soapVersion) {
        super(invoker);
        this.soapVersion = soapVersion;
        if (model.getServiceMode() == Service.Mode.PAYLOAD) {
            this.parameter = new PayloadSourceParameter();
        } else {
            ProviderInvokerPipe.Parameter<Source> parameter = this.parameter = model.isSource() ? new MessageSourceParameter() : new SOAPMessageParameter();
        }
        this.response = model.getServiceMode() == Service.Mode.PAYLOAD ? new PayloadSourceResponse() : (model.isSource() ? new MessageSourceResponse() : new SOAPMessageResponse());
    }

    protected Message getResponseMessage(Exception e) {
        return SOAPFaultBuilder.createSOAPFaultMessage(this.soapVersion, null, e);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SOAPMessageResponse
    implements ProviderInvokerPipe.Response<SOAPMessage> {
        private SOAPMessageResponse() {
        }

        @Override
        public Message getResponse(SOAPMessage soapMsg) {
            return Messages.create(soapMsg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MessageSourceResponse
    implements ProviderInvokerPipe.Response<Source> {
        private MessageSourceResponse() {
        }

        @Override
        public Message getResponse(Source source) {
            return Messages.create(source, SOAPProviderInvokerPipe.this.soapVersion);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class PayloadSourceResponse
    implements ProviderInvokerPipe.Response<Source> {
        private PayloadSourceResponse() {
        }

        @Override
        public Message getResponse(Source source) {
            return Messages.createUsingPayload(source, SOAPProviderInvokerPipe.this.soapVersion);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SOAPMessageParameter
    implements ProviderInvokerPipe.Parameter<SOAPMessage> {
        private SOAPMessageParameter() {
        }

        @Override
        public SOAPMessage getParameter(Message msg) {
            try {
                return msg.readAsSOAPMessage();
            }
            catch (SOAPException se) {
                throw new WebServiceException((Throwable)se);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MessageSourceParameter
    implements ProviderInvokerPipe.Parameter<Source> {
        private MessageSourceParameter() {
        }

        @Override
        public Source getParameter(Message msg) {
            return msg.readEnvelopeAsSource();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PayloadSourceParameter
    implements ProviderInvokerPipe.Parameter<Source> {
        private PayloadSourceParameter() {
        }

        @Override
        public Source getParameter(Message msg) {
            return msg.readPayloadAsSource();
        }
    }
}

