/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.server;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.addressing.EndpointReferenceUtil;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.SEIModel;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Engine;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.api.pipe.FiberContextSwitchInterceptor;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.api.pipe.PipeCloner;
import com.sun.xml.ws.api.pipe.PipelineAssembler;
import com.sun.xml.ws.api.pipe.PipelineAssemblerFactory;
import com.sun.xml.ws.api.pipe.ServerPipeAssemblerContext;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.api.server.TransportBackChannel;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.api.server.WebServiceContextDelegate;
import com.sun.xml.ws.fault.SOAPFaultBuilder;
import com.sun.xml.ws.server.EndpointFactory;
import com.sun.xml.ws.server.InvokerPipe;
import com.sun.xml.ws.server.ServiceDefinitionImpl;
import java.lang.reflect.Method;
import java.util.concurrent.Executor;
import java.util.logging.Logger;
import javax.annotation.PreDestroy;
import javax.xml.namespace.QName;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.handler.Handler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WSEndpointImpl<T>
extends WSEndpoint<T> {
    private final WSBinding binding;
    private final SEIModel seiModel;
    @NotNull
    private final Container container;
    private final WSDLPort port;
    private final Pipe masterPipeline;
    private final ServiceDefinitionImpl serviceDef;
    private final SOAPVersion soapVersion;
    private final Engine engine;
    private boolean disposed;
    private final Class<T> implementationClass;
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.server.endpoint");

    public WSEndpointImpl(WSBinding binding, Container container, SEIModel seiModel, WSDLPort port, Class<T> implementationClass, @Nullable ServiceDefinitionImpl serviceDef, InvokerPipe terminalPipe, boolean isSynchronous) {
        this.binding = binding;
        this.soapVersion = binding.getSOAPVersion();
        this.container = container;
        this.port = port;
        this.implementationClass = implementationClass;
        this.serviceDef = serviceDef;
        this.seiModel = seiModel;
        if (serviceDef != null) {
            serviceDef.setOwner(this);
        }
        PipelineAssembler assembler = PipelineAssemblerFactory.create(Thread.currentThread().getContextClassLoader(), binding.getBindingId());
        assert (assembler != null);
        ServerPipeAssemblerContext context = new ServerPipeAssemblerContext(seiModel, port, this, terminalPipe, isSynchronous);
        this.masterPipeline = assembler.createServer(context);
        terminalPipe.setEndpoint(this);
        this.engine = new Engine();
    }

    @Override
    @NotNull
    public Class<T> getImplementationClass() {
        return this.implementationClass;
    }

    @Override
    @NotNull
    public WSBinding getBinding() {
        return this.binding;
    }

    @Override
    @NotNull
    public Container getContainer() {
        return this.container;
    }

    @Override
    public WSDLPort getPort() {
        return this.port;
    }

    @Nullable
    public SEIModel getSEIModel() {
        return this.seiModel;
    }

    @Override
    public void setExecutor(Executor exec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void schedule(Packet request, Fiber.CompletionCallback callback, FiberContextSwitchInterceptor interceptor) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public WSEndpoint.PipeHead createPipeHead() {
        return new WSEndpoint.PipeHead(){
            private final Pipe pipe;
            {
                this.pipe = PipeCloner.clone(WSEndpointImpl.this.masterPipeline);
            }

            @NotNull
            public Packet process(Packet request, WebServiceContextDelegate wscd, TransportBackChannel tbc) {
                Packet response;
                request.webServiceContextDelegate = wscd;
                request.transportBackChannel = tbc;
                request.endpoint = WSEndpointImpl.this;
                try {
                    response = this.pipe.process(request);
                }
                catch (RuntimeException re) {
                    re.printStackTrace();
                    Message faultMsg = SOAPFaultBuilder.createSOAPFaultMessage(WSEndpointImpl.this.soapVersion, null, re);
                    response = request.createResponse(faultMsg);
                }
                return response;
            }
        };
    }

    @Override
    public synchronized void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        this.masterPipeline.preDestroy();
        block2: for (Handler handler : this.binding.getHandlerChain()) {
            for (Method method : handler.getClass().getMethods()) {
                if (method.getAnnotation(PreDestroy.class) == null) continue;
                try {
                    method.invoke((Object)handler, new Object[0]);
                }
                catch (Exception e) {
                    logger.warning("exception ignored from handler @PreDestroy method: " + e.getMessage());
                }
                continue block2;
            }
        }
    }

    @Override
    public ServiceDefinitionImpl getServiceDefinition() {
        return this.serviceDef;
    }

    public <T extends EndpointReference> T getEndpointReference(Class<T> clazz, String address) {
        QName service = this.getServiceName();
        QName portQN = this.getPortName(service);
        QName portType = this.getPortTypeName();
        return EndpointReferenceUtil.getEndpointReference(clazz, address, service, portQN == null ? null : portQN.getLocalPart(), portType, this.port != null);
    }

    private QName getServiceName() {
        if (this.port == null) {
            return EndpointFactory.getDefaultServiceName(this.implementationClass);
        }
        return this.port.getOwner().getName();
    }

    private QName getPortName(QName service) {
        if (this.port == null) {
            return EndpointFactory.getDefaultPortName(service, this.implementationClass);
        }
        return this.port.getName();
    }

    private QName getPortTypeName() {
        if (this.port == null) {
            return null;
        }
        return this.port.getBinding().getPortTypeName();
    }
}

