/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.message.saaj;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.bind.api.Bridge;
import com.sun.xml.bind.unmarshaller.DOMScanner;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.message.Attachment;
import com.sun.xml.ws.api.message.AttachmentSet;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.message.AttachmentUnmarshallerImpl;
import com.sun.xml.ws.message.saaj.SAAJHeader;
import com.sun.xml.ws.streaming.DOMStreamReader;
import com.sun.xml.ws.util.DOMUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.activation.DataHandler;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.WebServiceException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAAJMessage
extends Message {
    private final SOAPMessage sm;
    private HeaderList headers;
    private String payloadLocalName;
    private String payloadNamspace;
    private Element payload;
    private boolean parsedHeader;

    public SAAJMessage(SOAPMessage sm) {
        this.sm = sm;
        try {
            SOAPBody body = sm.getSOAPBody();
            this.payload = DOMUtil.getFirstElementChild((Node)body);
            if (this.payload != null) {
                this.payloadLocalName = this.payload.getLocalName();
                this.payloadNamspace = this.payload.getNamespaceURI();
            }
        }
        catch (SOAPException e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    private SAAJMessage(HeaderList headers, AttachmentSet as, SOAPMessage sm) {
        this(sm);
        this.headers = headers;
        this.attachmentSet = as;
    }

    @Override
    public boolean hasHeaders() {
        return this.getHeaders().size() > 0;
    }

    @Override
    public HeaderList getHeaders() {
        if (this.parsedHeader) {
            return this.headers;
        }
        if (this.headers == null) {
            this.headers = new HeaderList();
        }
        try {
            SOAPHeader header = this.sm.getSOAPHeader();
            if (header != null) {
                Iterator iter = header.examineAllHeaderElements();
                while (iter.hasNext()) {
                    this.headers.add(new SAAJHeader((SOAPHeaderElement)iter.next()));
                }
            }
            this.parsedHeader = true;
        }
        catch (SOAPException e) {
            e.printStackTrace();
        }
        return this.headers;
    }

    @Override
    @NotNull
    public AttachmentSet getAttachments() {
        if (this.attachmentSet == null) {
            this.attachmentSet = new SAAJAttachmentSet(this.sm);
        }
        return this.attachmentSet;
    }

    @Override
    protected boolean hasAttachments() {
        return !this.getAttachments().isEmpty();
    }

    @Override
    public String getPayloadLocalPart() {
        return this.payloadLocalName;
    }

    @Override
    public String getPayloadNamespaceURI() {
        return this.payloadNamspace;
    }

    @Override
    public boolean hasPayload() {
        return this.payloadNamspace != null;
    }

    @Override
    public Source readEnvelopeAsSource() {
        try {
            SOAPEnvelope se = this.sm.getSOAPPart().getEnvelope();
            return new DOMSource((Node)se);
        }
        catch (SOAPException e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    @Override
    public Source readPayloadAsSource() {
        return this.payload != null ? new DOMSource(this.payload) : null;
    }

    @Override
    public SOAPMessage readAsSOAPMessage() {
        return this.sm;
    }

    @Override
    public <T> T readPayloadAsJAXB(Unmarshaller unmarshaller) throws JAXBException {
        try {
            Node pn = this.sm.getSOAPBody().getFirstChild();
            if (pn != null) {
                return (T)unmarshaller.unmarshal(pn);
            }
            return null;
        }
        catch (SOAPException e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    @Override
    public <T> T readPayloadAsJAXB(Bridge<T> bridge) throws JAXBException {
        try {
            Node pn = this.sm.getSOAPBody().getFirstChild();
            if (pn != null) {
                return (T)bridge.unmarshal(pn, (AttachmentUnmarshaller)new AttachmentUnmarshallerImpl(this.getAttachments()));
            }
            return null;
        }
        catch (SOAPException e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    @Override
    public XMLStreamReader readPayload() throws XMLStreamException {
        if (this.payload == null) {
            return null;
        }
        DOMStreamReader dss = new DOMStreamReader();
        dss.setCurrentNode(this.payload);
        dss.nextTag();
        assert (dss.getEventType() == 1);
        return dss;
    }

    @Override
    public void writePayloadTo(XMLStreamWriter sw) {
        try {
            if (this.payload != null) {
                DOMUtil.serializeNode(this.payload, sw);
            }
        }
        catch (XMLStreamException e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    @Override
    public void writeTo(ContentHandler contentHandler, ErrorHandler errorHandler) throws SAXException {
        DOMScanner ds = new DOMScanner();
        ds.setContentHandler(contentHandler);
        ds.scan((Document)this.sm.getSOAPPart());
    }

    @Override
    public Message copy() {
        try {
            SOAPBody sb = this.sm.getSOAPPart().getEnvelope().getBody();
            SOAPMessage msg = SOAPVersion.fromNsUri((String)sb.getNamespaceURI()).saajMessageFactory.createMessage();
            SOAPBody newBody = msg.getSOAPPart().getEnvelope().getBody();
            if (this.payload != null) {
                Node n = newBody.getOwnerDocument().importNode(this.payload, true);
                newBody.appendChild(n);
            }
            return new SAAJMessage(this.getHeaders(), this.getAttachments(), msg);
        }
        catch (SOAPException e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    @Override
    public void writeTo(XMLStreamWriter writer) throws XMLStreamException {
        try {
            writer.writeStartDocument();
            SOAPEnvelope env = this.sm.getSOAPPart().getEnvelope();
            writer.writeStartElement(env.getPrefix(), "Envelope", env.getNamespaceURI());
            this.writeAttributes(env.getAttributes(), writer);
            if (this.hasHeaders()) {
                writer.writeStartElement(env.getPrefix(), "Header", env.getNamespaceURI());
                int len = this.headers.size();
                for (int i = 0; i < len; ++i) {
                    this.headers.get(i).writeTo(writer);
                }
                writer.writeEndElement();
            }
            DOMUtil.serializeNode((Element)this.sm.getSOAPBody(), writer);
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.flush();
        }
        catch (SOAPException ex) {
            ex.printStackTrace();
            throw new XMLStreamException(ex);
        }
    }

    private void writeAttributes(@Nullable NamedNodeMap attrs, XMLStreamWriter writer) throws XMLStreamException {
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                Attr attr = (Attr)attrs.item(i);
                if (attr.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/")) {
                    writer.setPrefix(attr.getLocalName(), attr.getValue());
                    writer.writeNamespace(attr.getLocalName(), attr.getValue());
                    continue;
                }
                writer.writeAttribute(attr.getPrefix(), attr.getNamespaceURI(), attr.getLocalName(), attr.getValue());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SAAJAttachmentSet
    implements AttachmentSet {
        private Map<String, Attachment> attMap;
        private Iterator attIter;

        public SAAJAttachmentSet(SOAPMessage sm) {
            this.attIter = sm.getAttachments();
        }

        @Override
        public Attachment get(String contentId) {
            if (this.attMap == null) {
                if (!this.attIter.hasNext()) {
                    return null;
                }
                this.attMap = this.createAttachmentMap();
            }
            return this.attMap.get('<' + contentId + '>');
        }

        @Override
        public boolean isEmpty() {
            if (this.attMap != null) {
                return this.attMap.isEmpty();
            }
            return !this.attIter.hasNext();
        }

        @Override
        public Iterator<Attachment> iterator() {
            if (this.attMap == null) {
                this.attMap = this.createAttachmentMap();
            }
            return this.attMap.values().iterator();
        }

        private Map<String, Attachment> createAttachmentMap() {
            HashMap<String, Attachment> map = new HashMap<String, Attachment>();
            while (this.attIter.hasNext()) {
                AttachmentPart ap = (AttachmentPart)this.attIter.next();
                map.put(ap.getContentId(), new SAAJAttachment(ap));
            }
            return map;
        }

        @Override
        public void add(Attachment att) {
            this.attMap.put('<' + att.getContentId() + '>', att);
        }
    }

    private class SAAJAttachment
    implements Attachment {
        AttachmentPart ap;

        public SAAJAttachment(AttachmentPart part) {
            this.ap = part;
        }

        public String getContentId() {
            return this.ap.getContentId();
        }

        public String getContentType() {
            return this.ap.getContentType();
        }

        public byte[] asByteArray() {
            try {
                return this.ap.getRawContentBytes();
            }
            catch (SOAPException e) {
                throw new WebServiceException((Throwable)e);
            }
        }

        public DataHandler asDataHandler() {
            try {
                return this.ap.getDataHandler();
            }
            catch (SOAPException e) {
                throw new WebServiceException((Throwable)e);
            }
        }

        public Source asSource() {
            try {
                return new StreamSource(this.ap.getRawContent());
            }
            catch (SOAPException e) {
                throw new WebServiceException((Throwable)e);
            }
        }

        public InputStream asInputStream() {
            try {
                return this.ap.getRawContent();
            }
            catch (SOAPException e) {
                throw new WebServiceException((Throwable)e);
            }
        }

        public void writeTo(OutputStream os) throws IOException {
            os.write(this.asByteArray());
        }

        public void writeTo(SOAPMessage saaj) {
            saaj.addAttachmentPart(this.ap);
        }

        AttachmentPart asAttachmentPart() {
            return this.ap;
        }
    }
}

