/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.message.jaxb;

import com.sun.istack.FragmentContentHandler;
import com.sun.istack.NotNull;
import com.sun.xml.bind.api.Bridge;
import com.sun.xml.bind.api.JAXBRIContext;
import com.sun.xml.stream.buffer.XMLStreamBuffer;
import com.sun.xml.stream.buffer.XMLStreamBufferResult;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.message.AttachmentSet;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.message.AbstractMessageImpl;
import com.sun.xml.ws.message.AttachmentSetImpl;
import com.sun.xml.ws.message.RootElementSniffer;
import com.sun.xml.ws.message.jaxb.AttachmentMarshallerImpl;
import com.sun.xml.ws.message.jaxb.JAXBBridgeSource;
import com.sun.xml.ws.message.jaxb.MarshallerBridge;
import java.io.OutputStream;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.bind.util.JAXBResult;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.ws.WebServiceException;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JAXBMessage
extends AbstractMessageImpl {
    private HeaderList headers;
    private final Object jaxbObject;
    private final AttachmentSetImpl attachmentSet;
    private final Bridge bridge;
    private String nsUri;
    private String localName;
    private XMLStreamBuffer infoset;

    public JAXBMessage(JAXBRIContext context, Object jaxbObject, SOAPVersion soapVer) {
        super(soapVer);
        this.bridge = new MarshallerBridge(context);
        this.jaxbObject = jaxbObject;
        this.attachmentSet = new AttachmentSetImpl();
    }

    public JAXBMessage(Bridge bridge, Object jaxbObject, SOAPVersion soapVer) {
        super(soapVer);
        this.bridge = bridge;
        this.jaxbObject = jaxbObject;
        QName tagName = bridge.getTypeReference().tagName;
        this.nsUri = tagName.getNamespaceURI();
        this.localName = tagName.getLocalPart();
        this.attachmentSet = new AttachmentSetImpl();
    }

    public JAXBMessage(JAXBMessage that) {
        super(that);
        this.headers = that.headers;
        if (this.headers != null) {
            this.headers = new HeaderList(this.headers);
        }
        this.attachmentSet = that.attachmentSet;
        this.jaxbObject = that.jaxbObject;
        this.bridge = that.bridge;
    }

    @Override
    @NotNull
    public AttachmentSet getAttachments() {
        return this.attachmentSet;
    }

    @Override
    public boolean hasHeaders() {
        return this.headers != null && !this.headers.isEmpty();
    }

    @Override
    public HeaderList getHeaders() {
        if (this.headers == null) {
            this.headers = new HeaderList();
        }
        return this.headers;
    }

    @Override
    public String getPayloadLocalPart() {
        if (this.localName == null) {
            this.sniff();
        }
        return this.localName;
    }

    @Override
    public String getPayloadNamespaceURI() {
        if (this.nsUri == null) {
            this.sniff();
        }
        return this.nsUri;
    }

    @Override
    public boolean hasPayload() {
        return true;
    }

    private void sniff() {
        RootElementSniffer sniffer = new RootElementSniffer(false);
        try {
            this.bridge.marshal(this.jaxbObject, (ContentHandler)sniffer);
        }
        catch (JAXBException e) {
            this.nsUri = sniffer.getNsUri();
            this.localName = sniffer.getLocalName();
        }
    }

    @Override
    public Source readPayloadAsSource() {
        return new JAXBBridgeSource(this.bridge, this.jaxbObject);
    }

    @Override
    public <T> T readPayloadAsJAXB(Unmarshaller unmarshaller) throws JAXBException {
        JAXBResult out = new JAXBResult(unmarshaller);
        try {
            out.getHandler().startDocument();
            this.bridge.marshal(this.jaxbObject, (Result)out);
            out.getHandler().endDocument();
        }
        catch (SAXException e) {
            throw new JAXBException((Throwable)e);
        }
        return (T)out.getResult();
    }

    @Override
    public XMLStreamReader readPayload() throws XMLStreamException {
        try {
            if (this.infoset == null) {
                XMLStreamBufferResult sbr = new XMLStreamBufferResult();
                this.bridge.marshal(this.jaxbObject, (Result)sbr);
                this.infoset = sbr.getXMLStreamBuffer();
            }
            return this.infoset.readAsXMLStreamReader();
        }
        catch (JAXBException e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    @Override
    protected void writePayloadTo(ContentHandler contentHandler, ErrorHandler errorHandler, boolean fragment) throws SAXException {
        try {
            if (fragment) {
                contentHandler = new FragmentContentHandler(contentHandler);
            }
            this.bridge.marshal(this.jaxbObject, contentHandler, (AttachmentMarshaller)new AttachmentMarshallerImpl(this.attachmentSet));
        }
        catch (JAXBException e) {
            throw new WebServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void writePayloadTo(XMLStreamWriter sw) throws XMLStreamException {
        try {
            OutputStream os;
            AttachmentMarshallerImpl am = new AttachmentMarshallerImpl(this.attachmentSet);
            if (sw instanceof Map && (os = (OutputStream)((Map)((Object)sw)).get("sjsxp-outputstream")) != null) {
                sw.writeCharacters("");
                this.bridge.marshal(this.jaxbObject, os, sw.getNamespaceContext(), (AttachmentMarshaller)am);
                return;
            }
            this.bridge.marshal(this.jaxbObject, sw, (AttachmentMarshaller)am);
        }
        catch (JAXBException e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    @Override
    public Message copy() {
        return new JAXBMessage(this);
    }
}

