/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.handler;

import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.ws.binding.BindingImpl;
import com.sun.xml.ws.client.HandlerConfiguration;
import com.sun.xml.ws.handler.HandlerPipe;
import com.sun.xml.ws.handler.HandlerProcessor;
import com.sun.xml.ws.handler.MessageUpdatableContext;
import com.sun.xml.ws.handler.SOAPHandlerProcessor;
import com.sun.xml.ws.handler.SOAPMessageContextImpl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;

public class ServerSOAPHandlerPipe
extends HandlerPipe {
    private WSBinding binding;
    private List<SOAPHandler> soapHandlers;
    private Set<String> roles;

    public ServerSOAPHandlerPipe(WSBinding binding, WSDLPort port, Pipe next) {
        super(next, port);
        if (binding.getSOAPVersion() != null) {
            // empty if block
        }
        this.binding = binding;
        this.setUpProcessorOnce();
    }

    public ServerSOAPHandlerPipe(WSBinding binding, Pipe next, HandlerPipe cousinPipe) {
        super(next, cousinPipe);
        this.binding = binding;
        this.setUpProcessorOnce();
    }

    private ServerSOAPHandlerPipe(ServerSOAPHandlerPipe that, TubeCloner cloner) {
        super(that, cloner);
        this.binding = that.binding;
        this.setUpProcessorOnce();
    }

    boolean isHandlerChainEmpty() {
        return this.soapHandlers.isEmpty();
    }

    public void close(MessageContext msgContext) {
        if (this.requestProcessingSucessful && this.cousinPipe != null) {
            this.cousinPipe.closeCall(msgContext);
        }
        if (this.processor != null) {
            this.closeSOAPHandlers(msgContext);
        }
    }

    public void closeCall(MessageContext msgContext) {
        this.closeSOAPHandlers(msgContext);
    }

    private void closeSOAPHandlers(MessageContext msgContext) {
        if (this.processor == null) {
            return;
        }
        if (this.remedyActionTaken) {
            this.processor.closeHandlers(msgContext, this.processor.getIndex(), this.soapHandlers.size() - 1);
            this.remedyActionTaken = false;
        } else {
            this.processor.closeHandlers(msgContext, 0, this.soapHandlers.size() - 1);
        }
    }

    public AbstractFilterTubeImpl copy(TubeCloner cloner) {
        return new ServerSOAPHandlerPipe(this, cloner);
    }

    private void setUpProcessorOnce() {
        this.soapHandlers = new ArrayList<SOAPHandler>();
        HandlerConfiguration handlerConfig = ((BindingImpl)this.binding).getHandlerConfig();
        List<SOAPHandler> soapSnapShot = handlerConfig.getSoapHandlers();
        if (!soapSnapShot.isEmpty()) {
            this.soapHandlers.addAll(soapSnapShot);
            this.roles = new HashSet<String>();
            this.roles.addAll(handlerConfig.getRoles());
            this.processor = new SOAPHandlerProcessor(false, this, this.binding, this.soapHandlers);
        }
    }

    void setUpProcessor() {
    }

    MessageUpdatableContext getContext(Packet packet) {
        SOAPMessageContextImpl context = new SOAPMessageContextImpl(this.binding, packet);
        context.setRoles(this.roles);
        return context;
    }

    boolean callHandlersOnRequest(MessageUpdatableContext context, boolean isOneWay) {
        boolean handlerResult;
        try {
            handlerResult = this.processor.callHandlersRequest(HandlerProcessor.Direction.INBOUND, context, !isOneWay);
        }
        catch (WebServiceException wse) {
            this.remedyActionTaken = true;
            throw wse;
        }
        catch (RuntimeException re) {
            this.remedyActionTaken = true;
            throw re;
        }
        if (!handlerResult) {
            this.remedyActionTaken = true;
        }
        return handlerResult;
    }

    void callHandlersOnResponse(MessageUpdatableContext context, boolean handleFault) {
        try {
            this.processor.callHandlersResponse(HandlerProcessor.Direction.OUTBOUND, context, handleFault);
        }
        catch (WebServiceException wse) {
            throw wse;
        }
        catch (RuntimeException re) {
            throw re;
        }
    }
}

