/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.handler;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.encoding.soap.SOAP12Constants;
import com.sun.xml.ws.encoding.soap.SOAPConstants;
import com.sun.xml.ws.handler.HandlerPipe;
import com.sun.xml.ws.handler.HandlerProcessor;
import com.sun.xml.ws.handler.MessageUpdatableContext;
import java.util.List;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.ws.ProtocolException;
import javax.xml.ws.handler.Handler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SOAPHandlerProcessor<C extends MessageUpdatableContext>
extends HandlerProcessor<C> {
    public SOAPHandlerProcessor(boolean isClient, HandlerPipe owner, WSBinding binding, List<? extends Handler> chain) {
        super(owner, binding, chain);
        this.isClient = isClient;
    }

    @Override
    final void insertFaultMessage(C context, ProtocolException exception) {
        try {
            if (!((MessageUpdatableContext)context).getPacketMessage().isFault()) {
                Message faultMessage = Messages.create(this.binding.getSOAPVersion(), exception, this.determineFaultCode(this.binding.getSOAPVersion()));
                ((MessageUpdatableContext)context).setPacketMessage(faultMessage);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "exception while creating fault message in handler chain", e);
            throw new RuntimeException(e);
        }
    }

    private QName determineFaultCode(SOAPVersion soapVersion) {
        if (this.isClient) {
            if (soapVersion == SOAPVersion.SOAP_12) {
                return SOAP12Constants.FAULT_CODE_CLIENT;
            }
            return SOAPConstants.FAULT_CODE_CLIENT;
        }
        if (soapVersion == SOAPVersion.SOAP_12) {
            return SOAP12Constants.FAULT_CODE_SERVER;
        }
        return SOAPConstants.FAULT_CODE_SERVER;
    }
}

