/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.handler;

import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.util.ReadOnlyPropertyException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.ws.handler.MessageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MessageContextImpl
implements MessageContext {
    private Map<String, Object> internalMap = new HashMap<String, Object>();
    private Set<String> handlerScopeProps;
    Packet packet;
    boolean packetPropsAccessed = false;

    void populateMap() {
        if (!this.packetPropsAccessed) {
            this.packetPropsAccessed = true;
            this.handlerScopeProps = this.packet.getHandlerScopePropertyNames(false);
            this.internalMap.putAll(this.packet.createMapView());
            this.internalMap.putAll(this.packet.invocationProperties);
        }
    }

    public MessageContextImpl(Packet packet) {
        this.packet = packet;
    }

    protected void updatePacket() {
        throw new UnsupportedOperationException("wrong call");
    }

    public void setScope(String name, MessageContext.Scope scope) {
        this.populateMap();
        if (!this.keyExists(name)) {
            throw new IllegalArgumentException("Property " + name + " does not exist.");
        }
        if (scope == MessageContext.Scope.APPLICATION) {
            this.handlerScopeProps.remove(name);
        } else {
            this.handlerScopeProps.add(name);
        }
    }

    public MessageContext.Scope getScope(String name) {
        this.populateMap();
        if (!this.keyExists(name)) {
            throw new IllegalArgumentException("Property " + name + " does not exist.");
        }
        if (this.handlerScopeProps.contains(name)) {
            return MessageContext.Scope.HANDLER;
        }
        return MessageContext.Scope.APPLICATION;
    }

    public int size() {
        this.populateMap();
        return this.internalMap.size();
    }

    public boolean isEmpty() {
        this.populateMap();
        return this.internalMap.isEmpty();
    }

    public boolean containsKey(Object key) {
        this.populateMap();
        return this.internalMap.containsKey(key);
    }

    public boolean containsValue(Object value) {
        this.populateMap();
        return this.internalMap.containsValue(value);
    }

    public Object put(String key, Object value) {
        this.populateMap();
        if (!this.keyExists(key)) {
            this.handlerScopeProps.add(key);
        }
        return this.internalMap.put(key, value);
    }

    public Object get(Object key) {
        this.populateMap();
        return this.internalMap.get(key);
    }

    public void putAll(Map<? extends String, ? extends Object> t) {
        this.populateMap();
        for (String string : t.keySet()) {
            if (this.keyExists(string)) continue;
            this.handlerScopeProps.add(string);
        }
        this.internalMap.putAll(t);
    }

    public void clear() {
        this.populateMap();
        this.internalMap.clear();
    }

    public Object remove(Object key) {
        this.populateMap();
        this.handlerScopeProps.remove(key);
        return this.internalMap.remove(key);
    }

    public Set<String> keySet() {
        this.populateMap();
        return this.internalMap.keySet();
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        this.populateMap();
        return this.internalMap.entrySet();
    }

    public Collection<Object> values() {
        this.populateMap();
        return this.internalMap.values();
    }

    private boolean keyExists(String name) {
        return this.keySet().contains(name);
    }

    void fill(Packet packet) {
        if (this.packetPropsAccessed) {
            for (Map.Entry<String, Object> entry : this.internalMap.entrySet()) {
                String key = entry.getKey();
                if (packet.supports(key)) {
                    try {
                        packet.put(key, entry.getValue());
                    }
                    catch (ReadOnlyPropertyException e) {}
                    continue;
                }
                packet.invocationProperties.put(key, entry.getValue());
            }
            packet.createMapView().keySet().retainAll(this.internalMap.keySet());
            packet.invocationProperties.keySet().retainAll(this.internalMap.keySet());
        }
    }
}

