/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.encoding;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Codec;
import com.sun.xml.ws.api.pipe.ContentType;
import com.sun.xml.ws.binding.SOAPBindingImpl;
import com.sun.xml.ws.client.ContentNegotiation;
import com.sun.xml.ws.encoding.MimeCodec;
import com.sun.xml.ws.encoding.MimeMultipartParser;
import com.sun.xml.ws.encoding.MtomCodec;
import com.sun.xml.ws.encoding.StreamSOAPCodec;
import com.sun.xml.ws.encoding.SwACodec;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.StringTokenizer;

public class SOAPBindingCodec
extends MimeCodec {
    private static final String BASE_ACCEPT_VALUE = "text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2";
    private boolean _useFastInfosetForEncoding;
    private final StreamSOAPCodec xmlSoapCodec;
    private final Codec fiSoapCodec;
    private final MimeCodec xmlMtomCodec;
    private final MimeCodec xmlSwaCodec;
    private final MimeCodec fiSwaCodec;
    private final SOAPBindingImpl binding;
    private final String xmlMimeType;
    private final String fiMimeType;
    private final String xmlAccept;
    private final String fiXmlAccept;
    private AcceptContentType _adaptingContentType = new AcceptContentType();

    public SOAPBindingCodec(WSBinding binding) {
        super(binding.getSOAPVersion());
        this.xmlSoapCodec = StreamSOAPCodec.create(this.version);
        this.xmlMimeType = this.xmlSoapCodec.getMimeType();
        this.fiSoapCodec = SOAPBindingCodec.getFICodec(this.version);
        this.fiMimeType = this.fiSoapCodec != null ? this.fiSoapCodec.getMimeType() : "";
        this.xmlMtomCodec = new MtomCodec(this.version, this.xmlSoapCodec);
        this.xmlSwaCodec = new SwACodec(this.version, this.xmlSoapCodec);
        this.fiSwaCodec = this.fiSoapCodec != null ? new SwACodec(this.version, this.fiSoapCodec) : null;
        this.xmlAccept = this.xmlSoapCodec.getMimeType() + ", " + this.xmlMtomCodec.getMimeType() + ", " + BASE_ACCEPT_VALUE;
        this.fiXmlAccept = this.fiSoapCodec.getMimeType() + ", " + this.xmlAccept;
        this.binding = (SOAPBindingImpl)binding;
    }

    public String getMimeType() {
        return null;
    }

    public ContentType getStaticContentType(Packet packet) {
        ContentType toAdapt = this.getEncoder(packet).getStaticContentType(packet);
        return toAdapt != null ? this._adaptingContentType.set(packet, toAdapt) : null;
    }

    public ContentType encode(Packet packet, OutputStream out) throws IOException {
        return this._adaptingContentType.set(packet, this.getEncoder(packet).encode(packet, out));
    }

    public ContentType encode(Packet packet, WritableByteChannel buffer) {
        return this._adaptingContentType.set(packet, this.getEncoder(packet).encode(packet, buffer));
    }

    public void decode(InputStream in, String contentType, Packet packet) throws IOException {
        if (this.isMultipartRelated(contentType)) {
            super.decode(in, contentType, packet);
        } else if (this.isFastInfoset(contentType)) {
            if (this.fiSoapCodec == null) {
                throw new RuntimeException("Fast Infoset Runtime not present");
            }
            this._useFastInfosetForEncoding = true;
            this.fiSoapCodec.decode(in, contentType, packet);
        } else {
            this.xmlSoapCodec.decode(in, contentType, packet);
        }
        if (!this._useFastInfosetForEncoding) {
            this._useFastInfosetForEncoding = this.isFastInfosetAcceptable(packet.acceptableMimeTypes);
        }
    }

    public void decode(ReadableByteChannel in, String contentType, Packet packet) {
        if (this.isMultipartRelated(contentType)) {
            super.decode(in, contentType, packet);
        } else if (this.isFastInfoset(contentType)) {
            if (this.fiSoapCodec == null) {
                throw new RuntimeException("Fast Infoset Runtime not present");
            }
            this._useFastInfosetForEncoding = true;
            this.fiSoapCodec.decode(in, contentType, packet);
        } else {
            this.xmlSoapCodec.decode(in, contentType, packet);
        }
        if (!this._useFastInfosetForEncoding) {
            this._useFastInfosetForEncoding = this.isFastInfosetAcceptable(packet.acceptableMimeTypes);
        }
    }

    public SOAPBindingCodec copy() {
        return new SOAPBindingCodec(this.binding);
    }

    protected void decode(MimeMultipartParser mpp, Packet packet) throws IOException {
        String rootContentType = mpp.getRootPart().getContentType();
        if (this.isApplicationXopXml(rootContentType)) {
            this.xmlMtomCodec.decode(mpp, packet);
        } else if (this.isFastInfoset(rootContentType)) {
            if (this.fiSoapCodec == null) {
                throw new RuntimeException("Fast Infoset Runtime not present");
            }
            this._useFastInfosetForEncoding = true;
            this.fiSwaCodec.decode(mpp, packet);
        } else if (this.isXml(rootContentType)) {
            this.xmlSwaCodec.decode(mpp, packet);
        } else {
            throw new IOException("");
        }
    }

    private boolean isMultipartRelated(String contentType) {
        return this.compareStrings(contentType, "multipart/related");
    }

    private boolean isApplicationXopXml(String contentType) {
        return this.compareStrings(contentType, "application/xop+xml");
    }

    private boolean isXml(String contentType) {
        return this.compareStrings(contentType, this.xmlMimeType);
    }

    private boolean isFastInfoset(String contentType) {
        return this.compareStrings(contentType, this.fiMimeType);
    }

    private boolean compareStrings(String a, String b) {
        return a.length() >= b.length() && b.equalsIgnoreCase(a.substring(0, b.length()));
    }

    private boolean isFastInfosetAcceptable(String accept) {
        if (accept == null) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(accept, ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (!token.equalsIgnoreCase(this.fiMimeType)) continue;
            return true;
        }
        return false;
    }

    private Codec getEncoder(Packet p) {
        if (p.contentNegotiation == ContentNegotiation.none) {
            this._useFastInfosetForEncoding = false;
        } else if (p.contentNegotiation == ContentNegotiation.optimistic) {
            this._useFastInfosetForEncoding = true;
        }
        if (this._useFastInfosetForEncoding && this.fiSoapCodec != null) {
            Message m = p.getMessage();
            if (m == null || m.getAttachments().isEmpty() || this.binding.isMTOMEnabled()) {
                return this.fiSoapCodec;
            }
            return this.fiSwaCodec;
        }
        if (this.binding.isMTOMEnabled()) {
            return this.xmlMtomCodec;
        }
        Message m = p.getMessage();
        if (m == null || m.getAttachments().isEmpty()) {
            return this.xmlSoapCodec;
        }
        return this.xmlSwaCodec;
    }

    private static Codec getFICodec(SOAPVersion version) {
        try {
            Class<?> c = Class.forName("com.sun.xml.ws.encoding.fastinfoset.FastInfosetStreamSOAPCodec");
            Method m = c.getMethod("create", SOAPVersion.class);
            return (Codec)m.invoke(null, new Object[]{version});
        }
        catch (Exception e) {
            return null;
        }
    }

    private class AcceptContentType
    implements ContentType {
        private ContentType _c;
        private String _accept;

        private AcceptContentType() {
        }

        public AcceptContentType set(Packet p, ContentType c) {
            this._accept = p.contentNegotiation == ContentNegotiation.optimistic || p.contentNegotiation == ContentNegotiation.pessimistic ? SOAPBindingCodec.this.fiXmlAccept : SOAPBindingCodec.this.xmlAccept;
            this._c = c;
            return this;
        }

        public String getContentType() {
            return this._c.getContentType();
        }

        public String getSOAPActionHeader() {
            return this._c.getSOAPActionHeader();
        }

        public String getAcceptHeader() {
            return this._accept;
        }
    }
}

