/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.client.dispatch;

import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.binding.BindingImpl;
import com.sun.xml.ws.client.WSServiceDelegate;
import com.sun.xml.ws.client.dispatch.DispatchImpl;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBDispatch
extends DispatchImpl<Object> {
    private final JAXBContext jaxbcontext;

    public JAXBDispatch(QName port, JAXBContext jc, Service.Mode mode, WSServiceDelegate service, Pipe pipe, BindingImpl binding) {
        super(port, mode, service, pipe, binding);
        this.jaxbcontext = jc;
    }

    @Override
    Object toReturnValue(Packet response) {
        try {
            Unmarshaller unmarshaller = this.jaxbcontext.createUnmarshaller();
            Message msg = response.getMessage();
            switch (this.mode) {
                case PAYLOAD: {
                    return msg.readPayloadAsJAXB(unmarshaller);
                }
                case MESSAGE: {
                    Source result = msg.readEnvelopeAsSource();
                    return unmarshaller.unmarshal(result);
                }
            }
            throw new WebServiceException("Unrecognized dispatch mode");
        }
        catch (JAXBException e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    @Override
    Packet createPacket(Object msg) {
        assert (this.jaxbcontext != null);
        try {
            Marshaller marshaller = this.jaxbcontext.createMarshaller();
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            Message message = msg == null ? Messages.createEmpty(this.soapVersion) : Messages.create(marshaller, msg, this.soapVersion);
            return new Packet(message);
        }
        catch (JAXBException e) {
            throw new WebServiceException((Throwable)e);
        }
    }
}

