/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.client;

import com.sun.istack.NotNull;
import com.sun.xml.ws.Closeable;
import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.EndpointAddress;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.WSService;
import com.sun.xml.ws.api.client.ContainerResolver;
import com.sun.xml.ws.api.pipe.ClientPipeAssemblerContext;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.api.pipe.PipelineAssembler;
import com.sun.xml.ws.api.pipe.PipelineAssemblerFactory;
import com.sun.xml.ws.api.pipe.Stubs;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.binding.BindingImpl;
import com.sun.xml.ws.client.HandlerResolverImpl;
import com.sun.xml.ws.client.PortInfo;
import com.sun.xml.ws.client.SEIPortInfo;
import com.sun.xml.ws.client.sei.SEIStub;
import com.sun.xml.ws.handler.PortInfoImpl;
import com.sun.xml.ws.model.AbstractSEIModelImpl;
import com.sun.xml.ws.model.RuntimeModeler;
import com.sun.xml.ws.model.SOAPSEIModel;
import com.sun.xml.ws.model.wsdl.WSDLPortImpl;
import com.sun.xml.ws.model.wsdl.WSDLServiceImpl;
import com.sun.xml.ws.resources.ClientMessages;
import com.sun.xml.ws.util.xml.XmlUtil;
import com.sun.xml.ws.wsdl.WSDLContext;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.jws.HandlerChain;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Dispatch;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.Service;
import javax.xml.ws.WebEndpoint;
import javax.xml.ws.WebServiceClient;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.soap.SOAPBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSServiceDelegate
extends WSService {
    private final Map<QName, PortInfo> ports = new HashMap<QName, PortInfo>();
    private HandlerResolver handlerResolver;
    private WSDLContext wsdlContext;
    private final Class<? extends Service> serviceClass;
    private final QName serviceName;
    private final Map<Class, SEIPortInfo> seiContext = new HashMap<Class, SEIPortInfo>();
    private final HashMap<QName, Set<String>> rolesMap = new HashMap();
    private Executor executor;
    private WSDLServiceImpl wsdlService;
    private final Container container;

    public WSServiceDelegate(URL wsdlDocumentLocation, QName serviceName, final Class<? extends Service> serviceClass) {
        HandlerChain handlerChain;
        if (serviceName == null) {
            throw new WebServiceException(ClientMessages.INVALID_SERVICE_NAME_NULL(serviceName));
        }
        this.serviceName = serviceName;
        this.serviceClass = serviceClass;
        this.container = ContainerResolver.getInstance().getContainer();
        if (wsdlDocumentLocation != null) {
            this.parseWSDL(wsdlDocumentLocation);
            this.populatePorts();
        }
        if (serviceClass != Service.class && (handlerChain = AccessController.doPrivileged(new PrivilegedAction<HandlerChain>(){

            @Override
            public HandlerChain run() {
                return serviceClass.getAnnotation(HandlerChain.class);
            }
        })) != null) {
            HandlerResolverImpl hresolver = new HandlerResolverImpl(this);
            this.setHandlerResolver(hresolver);
        }
    }

    private void parseWSDL(URL wsdlDocumentLocation) {
        this.wsdlContext = new WSDLContext(wsdlDocumentLocation, XmlUtil.createDefaultCatalogResolver());
        this.wsdlService = this.wsdlContext.getWSDLModel().getService(this.serviceName);
        if (this.wsdlService == null) {
            throw new WebServiceException(ClientMessages.INVALID_SERVICE_NAME(this.serviceName, this.buildNameList(this.wsdlContext.getWSDLModel().getServices().keySet())));
        }
    }

    private void populatePorts() {
        if (this.wsdlContext != null) {
            for (WSDLPortImpl port : this.wsdlContext.getPorts(this.serviceName)) {
                this.ports.put(port.getName(), new PortInfo(this, port));
            }
        }
    }

    public Executor getExecutor() {
        if (this.executor != null) {
            return this.executor;
        }
        this.executor = Executors.newCachedThreadPool(new DaemonThreadFactory());
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public HandlerResolver getHandlerResolver() {
        return this.handlerResolver;
    }

    public void setHandlerResolver(HandlerResolver resolver) {
        this.handlerResolver = resolver;
    }

    public <T> T getPort(QName portName, Class<T> portInterface) throws WebServiceException {
        if (portName == null || portInterface == null) {
            throw new IllegalArgumentException();
        }
        this.addSEI(portName, portInterface);
        return this.createEndpointIFBaseProxy(portName, portInterface);
    }

    public <T> T getPort(QName qName, Class<T> aClass, WebServiceFeature ... webServiceFeatures) {
        throw new UnsupportedOperationException();
    }

    public <T> T getPort(EndpointReference endpointReference, Class<T> serviceEndpointInterface, WebServiceFeature ... features) {
        throw new UnsupportedOperationException();
    }

    public <T> T getPort(Class<T> aClass, WebServiceFeature ... webServiceFeatures) {
        throw new UnsupportedOperationException();
    }

    public <T> T getPort(Class<T> portInterface) throws WebServiceException {
        QName portTypeName = RuntimeModeler.getPortTypeName(portInterface);
        QName portName = this.wsdlContext.getWSDLModel().getPortName(this.serviceName, portTypeName);
        return this.getPort(portName, portInterface);
    }

    private void addPort(QName portName, String bindingId, String[] features, String endpointAddress) {
        if (this.ports.containsKey(portName)) {
            throw new WebServiceException("WSDLPort " + portName.toString() + " already exists can not create a port with the same name.");
        }
        BindingID bid = bindingId == null ? BindingID.SOAP11_HTTP : BindingID.parse(bindingId);
        this.ports.put(portName, new PortInfo(this, EndpointAddress.create(endpointAddress), portName, bid, features));
    }

    public void addPort(QName portName, String bindingId, String endpointAddress) throws WebServiceException {
        if (this.ports.containsKey(portName)) {
            throw new WebServiceException("WSDLPort " + portName.toString() + " already exists can not create a port with the same name.");
        }
        BindingID bid = bindingId == null ? BindingID.SOAP11_HTTP : BindingID.parse(bindingId);
        this.ports.put(portName, new PortInfo(this, EndpointAddress.create(endpointAddress), portName, bid));
    }

    public <T> Dispatch<T> createDispatch(QName portName, Class<T> aClass, Service.Mode mode) throws WebServiceException {
        PortInfo port = this.safeGetPort(portName);
        BindingImpl binding = port.createBinding();
        return Stubs.createDispatch(portName, this, binding, aClass, mode, this.createPipeline(port, binding));
    }

    public <T> Dispatch<T> createDispatch(QName qName, Class<T> aClass, Service.Mode mode, WebServiceFeature ... webServiceFeatures) {
        throw new UnsupportedOperationException();
    }

    public <T> Dispatch<T> createDispatch(EndpointReference endpointReference, Class<T> type, Service.Mode mode, WebServiceFeature ... features) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public PortInfo safeGetPort(QName portName) {
        PortInfo port = this.ports.get(portName);
        if (port == null) {
            throw new WebServiceException(ClientMessages.INVALID_PORT_NAME(portName, this.buildNameList(this.ports.keySet())));
        }
        return port;
    }

    private StringBuilder buildNameList(Collection<QName> names) {
        StringBuilder sb = new StringBuilder();
        for (QName qn : names) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(qn);
        }
        return sb;
    }

    private Pipe createPipeline(PortInfo portInfo, WSBinding binding) {
        BindingID bindingId = portInfo.bindingId;
        PipelineAssembler assembler = PipelineAssemblerFactory.create(Thread.currentThread().getContextClassLoader(), bindingId);
        if (assembler == null) {
            throw new WebServiceException("Unable to process bindingID=" + bindingId);
        }
        return assembler.createClient(new ClientPipeAssemblerContext(portInfo.targetEndpoint, portInfo.portModel, this, binding, this.container));
    }

    public EndpointAddress getEndpointAddress(QName qName) {
        return this.ports.get((Object)qName).targetEndpoint;
    }

    public Dispatch<Object> createDispatch(QName portName, JAXBContext jaxbContext, Service.Mode mode) throws WebServiceException {
        PortInfo port = this.safeGetPort(portName);
        BindingImpl binding = port.createBinding();
        return Stubs.createJAXBDispatch(portName, this, binding, jaxbContext, mode, this.createPipeline(port, binding));
    }

    public Dispatch<Object> createDispatch(QName qName, JAXBContext jaxbContext, Service.Mode mode, WebServiceFeature ... webServiceFeatures) {
        return null;
    }

    public Dispatch<Object> createDispatch(EndpointReference endpointReference, JAXBContext context, Service.Mode mode, WebServiceFeature ... features) {
        return null;
    }

    public QName getServiceName() {
        return this.serviceName;
    }

    protected Class getServiceClass() {
        return this.serviceClass;
    }

    protected Set<String> getRoles(QName portName) {
        return this.rolesMap.get(portName);
    }

    protected void setRoles(QName portName, Set<String> roles) {
        this.rolesMap.put(portName, roles);
    }

    public Iterator<QName> getPorts() throws WebServiceException {
        if (this.ports.isEmpty()) {
            throw new WebServiceException("dii.service.no.wsdl.available");
        }
        return this.ports.keySet().iterator();
    }

    public URL getWSDLDocumentLocation() {
        return this.wsdlContext.getWsdlLocation();
    }

    private <T> T createEndpointIFBaseProxy(QName portName, Class<T> portInterface) throws WebServiceException {
        if (this.wsdlContext == null) {
            throw new WebServiceException(ClientMessages.INVALID_SERVICE_NO_WSDL(this.serviceName));
        }
        if (!this.wsdlContext.contains(this.serviceName, portName)) {
            throw new WebServiceException("WSDLPort " + portName + "is not found in service " + this.serviceName);
        }
        SEIPortInfo eif = this.seiContext.get(portInterface);
        BindingImpl binding = eif.createBinding();
        SEIStub pis = new SEIStub(this, binding, eif.model, this.createPipeline(eif, binding));
        return portInterface.cast(Proxy.newProxyInstance(portInterface.getClassLoader(), new Class[]{portInterface, BindingProvider.class, Closeable.class}, (InvocationHandler)pis));
    }

    protected BindingImpl createBinding(QName portName, BindingID bindingId) {
        Set<String> roles;
        ArrayList<Handler> handlerChain;
        if (this.handlerResolver != null) {
            PortInfoImpl portInfo = new PortInfoImpl(bindingId, portName, this.serviceName);
            handlerChain = this.handlerResolver.getHandlerChain((javax.xml.ws.handler.PortInfo)portInfo);
        } else {
            handlerChain = new ArrayList();
        }
        BindingImpl bindingImpl = BindingImpl.create(bindingId);
        PortInfo portInfo = this.ports.get(portName);
        if (portInfo.portModel != null && portInfo.portModel.getBinding().isMTOMEnabled()) {
            bindingImpl.setMTOMEnabled(true);
        }
        if (bindingImpl instanceof SOAPBinding && (roles = this.rolesMap.get(portName)) != null) {
            ((SOAPBinding)bindingImpl).setRoles(roles);
        }
        bindingImpl.setHandlerChain(handlerChain);
        return bindingImpl;
    }

    private WSDLPortImpl getPortModel(QName portName) {
        WSDLPortImpl port = this.wsdlService.get(portName);
        if (port == null) {
            throw new WebServiceException("Port \"" + portName + "\" not found in service \"" + this.serviceName + "\"");
        }
        return port;
    }

    private void addSEI(QName portName, Class portInterface) throws WebServiceException {
        SEIPortInfo spi = this.seiContext.get(portInterface);
        if (spi != null) {
            return;
        }
        WSDLPortImpl wsdlPort = this.getPortModel(portName);
        RuntimeModeler modeler = new RuntimeModeler(portInterface, this.serviceName, wsdlPort);
        modeler.setPortName(portName);
        AbstractSEIModelImpl model = modeler.buildRuntimeModel();
        spi = new SEIPortInfo(this, portInterface, (SOAPSEIModel)model, wsdlPort);
        this.seiContext.put(spi.sei, spi);
        this.ports.put(spi.portName, spi);
    }

    public WSDLServiceImpl getWsdlService() {
        return this.wsdlService;
    }

    private QName guessPortName(Class<?> sei) {
        if (this.serviceClass == null) {
            return null;
        }
        WebServiceClient wsClient = this.serviceClass.getAnnotation(WebServiceClient.class);
        for (Method method : this.serviceClass.getMethods()) {
            WebEndpoint webEndpoint;
            if (method.getDeclaringClass() != this.serviceClass || (webEndpoint = method.getAnnotation(WebEndpoint.class)) == null || method.getGenericReturnType() != sei || !method.getName().startsWith("get")) continue;
            return new QName(wsClient.targetNamespace(), webEndpoint.name());
        }
        return null;
    }

    public WSDLContext getWSDLContext() {
        return this.wsdlContext;
    }

    class DaemonThreadFactory
    implements ThreadFactory {
        DaemonThreadFactory() {
        }

        public Thread newThread(Runnable r) {
            Thread daemonThread = new Thread(r);
            daemonThread.setDaemon(Boolean.TRUE);
            return daemonThread;
        }
    }
}

