/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.client;

import com.sun.istack.Nullable;
import com.sun.xml.ws.Closeable;
import com.sun.xml.ws.api.EndpointAddress;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.binding.BindingImpl;
import com.sun.xml.ws.client.RequestContext;
import com.sun.xml.ws.client.ResponseContext;
import com.sun.xml.ws.client.ResponseContextReceiver;
import com.sun.xml.ws.util.Pool;
import com.sun.xml.ws.util.RuntimeVersion;
import java.util.Map;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Stub
implements BindingProvider,
ResponseContextReceiver,
Closeable {
    private Pool<Pipe> pipes;
    protected EndpointReference endpointReference;
    protected final BindingImpl binding;
    public final RequestContext requestContext = new RequestContext();
    private ResponseContext responseContext;
    @Nullable
    protected final WSDLPort wsdlPort;

    protected Stub(Pipe master, BindingImpl binding, WSDLPort wsdlPort, EndpointAddress defaultEndPointAddress) {
        this.pipes = new Pool.PipePool(master);
        this.wsdlPort = wsdlPort;
        this.binding = binding;
        this.requestContext.setEndpointAddress(defaultEndPointAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Packet process(Packet packet, RequestContext requestContext, ResponseContextReceiver receiver) {
        Packet reply;
        packet.proxy = this;
        packet.handlerConfig = this.binding.getHandlerConfig();
        requestContext.fill(packet);
        Pool<Pipe> pool = this.pipes;
        if (pool == null) {
            throw new WebServiceException("close method has already been invoked");
        }
        Pipe pipe = pool.take();
        try {
            reply = pipe.process(packet);
        }
        finally {
            pool.recycle(pipe);
        }
        receiver.setResponseContext(new ResponseContext(reply));
        return reply;
    }

    @Override
    public void close() {
        if (this.pipes != null) {
            Pipe p = this.pipes.take();
            this.pipes = null;
            p.preDestroy();
        }
    }

    public final WSBinding getBinding() {
        return this.binding;
    }

    public final Map<String, Object> getRequestContext() {
        return this.requestContext.getMapView();
    }

    public final ResponseContext getResponseContext() {
        return this.responseContext;
    }

    @Override
    public void setResponseContext(ResponseContext rc) {
        this.responseContext = rc;
    }

    public String toString() {
        return RuntimeVersion.VERSION + ": Stub for " + this.getRequestContext().get("javax.xml.ws.service.endpoint.address");
    }

    public W3CEndpointReference getEndpointReference() {
        return (W3CEndpointReference)this.getEndpointReference(W3CEndpointReference.class);
    }
}

