/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.api.server;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.server.InstanceResolver;
import com.sun.xml.ws.server.ServerRtException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.xml.ws.WebServiceContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SingletonResolver<T>
extends InstanceResolver<T> {
    @NotNull
    private final T singleton;

    public SingletonResolver(@NotNull T singleton) {
        this.singleton = singleton;
    }

    @Override
    @NotNull
    public T resolve(Packet request) {
        return this.singleton;
    }

    @Override
    public void start(WebServiceContext wsc) {
        this.doFieldsInjection(wsc);
        this.doMethodsInjection(wsc);
        this.invokeAnnotatedMethod(PostConstruct.class);
    }

    @Override
    public void dispose() {
        this.invokeAnnotatedMethod(PreDestroy.class);
    }

    private void invokeAnnotatedMethod(Class<? extends Annotation> annType) {
        Class<?> c = this.singleton.getClass();
        boolean once = false;
        for (Method method : c.getDeclaredMethods()) {
            if (method.getAnnotation(annType) == null) continue;
            if (once) {
                throw new ServerRtException("annotation.only.once", annType);
            }
            if (method.getParameterTypes().length != 0) {
                throw new ServerRtException("not.zero.parameters", method.getName());
            }
            this.invokeMethod(method, new Object[0]);
            once = true;
        }
    }

    private void invokeMethod(final Method method, final Object ... args) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws IllegalAccessException, InvocationTargetException {
                    if (!method.isAccessible()) {
                        method.setAccessible(true);
                    }
                    method.invoke(SingletonResolver.this.singleton, args);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new ServerRtException("server.rt.err", e.getException());
        }
    }

    private void doFieldsInjection(WebServiceContext wsc) {
        Field[] fields;
        Class<?> c = this.singleton.getClass();
        for (Field field : fields = c.getDeclaredFields()) {
            Resource resource = field.getAnnotation(Resource.class);
            if (resource == null) continue;
            Class resourceType = resource.type();
            Class<WebServiceContext> fieldType = field.getType();
            if (resourceType.equals(Object.class)) {
                if (!fieldType.equals(WebServiceContext.class)) continue;
                this.injectField(field, wsc);
                continue;
            }
            if (!resourceType.equals(WebServiceContext.class)) continue;
            if (fieldType.isAssignableFrom(WebServiceContext.class)) {
                this.injectField(field, wsc);
                continue;
            }
            throw new ServerRtException("wrong.field.type", field.getName());
        }
    }

    private void injectField(final Field field, final WebServiceContext wsc) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws IllegalAccessException {
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    field.set(SingletonResolver.this.singleton, wsc);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new ServerRtException("server.rt.err", e.getException());
        }
    }

    private void doMethodsInjection(WebServiceContext wsc) {
        Method[] methods;
        Class<?> c = this.singleton.getClass();
        for (Method method : methods = c.getDeclaredMethods()) {
            Resource resource = method.getAnnotation(Resource.class);
            if (resource == null) continue;
            Class<?>[] paramTypes = method.getParameterTypes();
            if (paramTypes.length != 1) {
                throw new ServerRtException("wrong.no.parameters", method.getName());
            }
            Class resourceType = resource.type();
            Class<WebServiceContext> argType = paramTypes[0];
            if (resourceType.equals(Object.class) && argType.equals(WebServiceContext.class)) {
                this.invokeMethod(method, wsc);
                continue;
            }
            if (!resourceType.equals(WebServiceContext.class)) continue;
            if (argType.isAssignableFrom(WebServiceContext.class)) {
                this.invokeMethod(method, wsc);
                continue;
            }
            throw new ServerRtException("wrong.parameter.type", method.getName());
        }
    }
}

